#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 monoid-subclasses
version:              1.2.6
visibility:           public
id:                   monoid-subclasses-1.2.6-EdRaP7Nrq143ylHdpTHh8u
key:                  monoid-subclasses-1.2.6-EdRaP7Nrq143ylHdpTHh8u
license:              BSD-3-Clause
copyright:            (c) 2013-2024 Mario Blažević
maintainer:           Mario Blažević <blamario@protonmail.com>
author:               Mario Blažević
homepage:             https://github.com/blamario/monoid-subclasses/
synopsis:             Subclasses of Monoid
description:
    A hierarchy of subclasses of '\''Monoid'\'' together with their instances for all data structures from base, containers, and
    text packages.

category:             Data, Algebra, Text
abi:                  8a43f5df53c48490fa83cd0623513b15
exposed:              True
exposed-modules:
    Data.Monoid.Cancellative Data.Monoid.Factorial Data.Monoid.GCD
    Data.Monoid.Instances.ByteString.UTF8
    Data.Monoid.Instances.CharVector Data.Monoid.Instances.Concat
    Data.Monoid.Instances.Measured Data.Monoid.Instances.Positioned
    Data.Monoid.Instances.PrefixMemory Data.Monoid.Instances.Stateful
    Data.Monoid.LCM Data.Monoid.Monus Data.Monoid.Null
    Data.Monoid.Textual Data.Semigroup.Cancellative
    Data.Semigroup.Factorial

import-dirs:          /usr/lib/ghc-9.4.8/site-local/monoid-subclasses-1.2.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/monoid-subclasses-1.2.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/monoid-subclasses-1.2.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monoid-subclasses
hs-libraries:         HSmonoid-subclasses-1.2.6-EdRaP7Nrq143ylHdpTHh8u
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    commutative-semigroups-0.2.0.1-8XLwNFnEO8JH5WoKEjdOs6
    containers-0.6.7 primes-0.2.1.0-LmLNpOWl018Fc2AFLcapwU text-2.0.2
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX

haddock-interfaces:
    /usr/share/doc/haskell-monoid-subclasses/html/monoid-subclasses.haddock

haddock-html:         /usr/share/doc/haskell-monoid-subclasses/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

