#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-6Xs2BvW8btiHpFlfYHbLGM
key:                  mueval-0.9.3-6Xs2BvW8btiHpFlfYHbLGM
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  10127901c81251faa18e422dbca46ef9
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-9.4.8/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mueval-0.9.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mueval
hs-libraries:         HSmueval-0.9.3-6Xs2BvW8btiHpFlfYHbLGM
depends:
    Cabal-3.8.1.0 QuickCheck-2.14.3-6d1PIKLXLdiAlrbWNDjj9l
    base-4.17.2.1 containers-0.6.7 directory-1.3.7.1
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    filepath-1.4.2.2 hint-0.9.0.7-ClJbMVpLN7J7EcGKecBVVu mtl-2.2.2
    process-1.6.18.0 show-0.6-1VnJe5okMZPEXWfAS9a1KC
    simple-reflect-0.3.3-Kct69QODYQA4F7issyqpIH unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

