#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mwc-random
version:              0.15.2.0
visibility:           public
id:                   mwc-random-0.15.2.0-Fkjd6adLI8o7nWGnH5VNAE
key:                  mwc-random-0.15.2.0-Fkjd6adLI8o7nWGnH5VNAE
license:              BSD-2-Clause
copyright:            2009, 2010, 2011 Bryan O'\''Sullivan
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/haskell/mwc-random
synopsis:             Fast, high quality pseudo random number generation
description:
    This package contains code for generating high quality random
    numbers that follow either a uniform or normal distribution.  The
    generated numbers are suitable for use in statistical applications.
    .
    The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
    multiply-with-carry generator, which has a period of 2^8222 and
    fares well in tests of randomness.  It is also extremely fast,
    between 2 and 3 times faster than the Mersenne Twister.
    .
    Compared to the mersenne-random package, this package has a more
    convenient API, is faster, and supports more statistical
    distributions.

category:             Math, Statistics
abi:                  fe32a2fef51cb41dcffd283a5b864a1c
exposed:              True
exposed-modules:
    System.Random.MWC System.Random.MWC.CondensedTable
    System.Random.MWC.Distributions System.Random.MWC.SeedSource

import-dirs:          /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mwc-random-0.15.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mwc-random
hs-libraries:         HSmwc-random-0.15.2.0-Fkjd6adLI8o7nWGnH5VNAE
depends:
    base-4.17.2.1 math-functions-0.3.4.4-LVfkMVjZYBrLSqoQfgIYp9
    primitive-0.7.4.0-KqFD2LgtKT625pNAu5KXoF
    random-1.2.1.2-J6mYBSGGDLVAHQqGKIioSR time-1.12.2
    vector-0.13.1.0-3m7HMvWbOJNDnUiYgFdHrI

haddock-interfaces:   /usr/share/doc/haskell-mwc-random/html/mwc-random.haddock
haddock-html:         /usr/share/doc/haskell-mwc-random/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

