#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 parameterized-utils
version:              2.1.10.0
visibility:           public
id:                   parameterized-utils-2.1.10.0-216L08Jm6OWAvwObUSLjOC
key:                  parameterized-utils-2.1.10.0-216L08Jm6OWAvwObUSLjOC
license:              BSD-3-Clause
copyright:            ©2016-2022 Galois, Inc.
maintainer:           kquick@galois.com, rscott@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  7d0779d2987be18921dd9b9e5bcdfebd
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All Data.Parameterized.Axiom
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.Fin
    Data.Parameterized.FinMap Data.Parameterized.FinMap.Safe
    Data.Parameterized.FinMap.Unsafe Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.TraversableFC.WithIndex
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/parameterized-utils-2.1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-parameterized-utils
hs-libraries:         HSparameterized-utils-2.1.10.0-216L08Jm6OWAvwObUSLjOC
depends:
    base-4.17.2.1 base-orphans-0.8.8.2-FEffy3DtXbz5YHgxbB6Zcu
    constraints-0.13.4-9t7M4RAom435nssV0Rpobx containers-0.6.7
    deepseq-1.4.8.0 ghc-prim-0.9.1
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    hashtables-1.3.1-ADrvCNjeKuDHf53POqMa3o
    indexed-traversable-0.1.4-EiyQIsHWfilLwzPb8OdnEq
    lens-5.2.3-CUB7er19pGW1jvefO3TVCG mtl-2.2.2
    profunctors-5.6.2-FU1ZJ7jAwY3FBezLPRDd4l template-haskell-2.19.0.0
    text-2.0.2 th-abstraction-0.4.5.0-EtQVnbIEkAX5f6KN9Uwjhw
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

