#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-K5b2PB1OyX13y0FLBGPpHI
key:                  postgresql-binary-0.12.5-K5b2PB1OyX13y0FLBGPpHI
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  060b1ebf9f6392b51f14f14cda3037e0
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-K5b2PB1OyX13y0FLBGPpHI
depends:
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm base-4.17.2.1
    binary-parser-0.5.7.7-45R8nIEc2pn4st2bmoxiyh bytestring-0.11.5.3
    bytestring-strict-builder-0.4.5.8-F717fSP4cWJDm2hQEnvYMP
    containers-0.6.7 network-ip-0.3.0.3-3CFwHICYcmFJZRJigzUr43
    scientific-0.3.8.0-3KgWCwEWnxjIUGX8ssH1BR text-2.0.2 time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    uuid-1.3.16-BGbd2DS4gajB9FP9VbIx28
    vector-0.13.2.0-EQFZws9ZIK8A2ESM3MR23n

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

