#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.30
visibility:           public
id:                   quickcheck-instances-0.3.30-GNWoV8uScf6GZzsmjnn3FO
key:                  quickcheck-instances-0.3.30-GNWoV8uScf6GZzsmjnn3FO
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  93b420aeff343acff96987a2eee72942
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.30-GNWoV8uScf6GZzsmjnn3FO
depends:
    OneTuple-0.4.2-EwAqbHwYhlyA3MFVMP44aa
    QuickCheck-2.14.3-DOFi1GQ9eE04hBoMxr6sJJ array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap containers-0.6.7
    data-fix-0.3.2-JNkfgh3sBrmALE891C7vSD
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    integer-logarithms-1.0.3.1-JfoQIJXh5PhDnmGGlkJE4T
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.7.4.0-GWGNy3IYYzTHqwC4kY0YCL
    scientific-0.3.7.0-Jh9tJE2sLMpFL2bSsP8DMA
    splitmix-0.1.0.5-A3kleAWrfxK19djJhV1RvG
    strict-0.5-AlYa9UfaMtb1TcBU9cAEhh
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-LHOZ8YG3dHr4Bc2V2LTWU4
    these-1.2-9OWMruQL2NeCIHBfPxUu8V time-1.12.2
    time-compat-1.9.6.1-KaJ6EnR2cP13bltOdWho5D transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    uuid-types-1.0.6-IQyEC4RLNlX9sNuZIMNyMl
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

