#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.30
visibility:           public
id:                   quickcheck-instances-0.3.30-10qdzmlX1moJZIk4SAgoyv
key:                  quickcheck-instances-0.3.30-10qdzmlX1moJZIk4SAgoyv
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  e3473e3387ae16f7a62a501344b1e026
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.30-10qdzmlX1moJZIk4SAgoyv
depends:
    OneTuple-0.4.2-GEbDRyrphBlA1EfhqH1d2u
    QuickCheck-2.14.3-1JAfsK5YqEi18geygBPUiU array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi containers-0.6.7
    data-fix-0.3.2-At1uUHrE6lC1Zo5K7qlX0q
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    integer-logarithms-1.0.3.1-JfoQIJXh5PhDnmGGlkJE4T
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.7.4.0-K4IT7bUBj0c2CIJh0yt8eH
    scientific-0.3.7.0-LKd2L2qVPICBdMYOyCcex4
    splitmix-0.1.0.5-3XGZlf81FGe4ifCWAGJWlG
    strict-0.5-327XbhI6RNzK6TodlJYYET
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-7jMKNwZWvow5bGSTCFjHPD
    these-1.2-L4EL7Iwezbp3j1oAddIVlT time-1.12.2
    time-compat-1.9.6.1-880Vipt1UYYKIVCT3LOV8F transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ
    unordered-containers-0.2.20-2oScjwZejU42oDENjBi2vG
    uuid-types-1.0.6-9iiZ7bUVqGV7cZb96oex9D
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

