#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-8AuFgE6I03YDEvMRJEFPsT
key:                  ral-0.2.1-8AuFgE6I03YDEvMRJEFPsT
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  30d9eae0225168fb2e789f85b4261fad
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-8AuFgE6I03YDEvMRJEFPsT
depends:
    QuickCheck-2.14.3-DOFi1GQ9eE04hBoMxr6sJJ
    adjunctions-4.4.2-ForbUBtptLgFxuqD5qt97S base-4.17.2.1
    bin-0.1.3-FUFMoZH0GxSLgg3VKYBzz0
    boring-0.2.1-J4SnML7YpXV9bowsupJp7A deepseq-1.4.8.0
    distributive-0.6.2.1-D3SXffd2XIlAT2MovnSdW4
    fin-0.3-CMXrrPu0h7qFq9Zi9buLsK
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    indexed-traversable-0.1.4-7ph7dHdACfa9uO4tGpH9sc
    semigroupoids-6.0.0.1-7jmB6QISbXh15MEXUZPyZv

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

