#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   sdl2
version:                2.5.5.1
visibility:             public
id:                     sdl2-2.5.5.1-9EukOxt85tj8W3LRVeiQ4N
key:                    sdl2-2.5.5.1-9EukOxt85tj8W3LRVeiQ4N
license:                BSD-3-Clause
copyright:              Copyright © 2013-2017  Gabríel Arthúr Pétursson
maintainer:             gabriel@system.is, ollie@ocharles.org.uk
author:                 Gabríel Arthúr Pétursson, Oliver Charles
synopsis:
    Both high- and low-level bindings to the SDL library (version 2.0.6+).

description:
    This package contains bindings to the SDL 2 library, in both high- and
    low-level forms:

    The '\''SDL'\'' namespace contains high-level bindings, where enumerations are split
    into sum types, and we perform automatic error-checking.

    The '\''SDL.Raw'\'' namespace contains an almost 1-1 translation of the C API into
    Haskell FFI calls. As such, this does not contain sum types nor error
    checking. Thus this namespace is suitable for building your own abstraction
    over SDL, but is not recommended for day-to-day programming.

    Read "SDL" for a getting started guide.

category:               Graphics
abi:                    f2bbf21d07e85a5a69ae6f08fbe5cca9
exposed:                True
exposed-modules:
    SDL SDL.Audio SDL.Event SDL.Exception SDL.Filesystem SDL.Hint
    SDL.Init SDL.Input SDL.Input.GameController SDL.Input.Joystick
    SDL.Input.Keyboard SDL.Input.Keyboard.Codes SDL.Input.Mouse
    SDL.Internal.Exception SDL.Internal.Numbered SDL.Internal.Types
    SDL.Internal.Vect SDL.Power SDL.Raw SDL.Raw.Audio SDL.Raw.Basic
    SDL.Raw.Enum SDL.Raw.Error SDL.Raw.Event SDL.Raw.Filesystem
    SDL.Raw.Haptic SDL.Raw.Platform SDL.Raw.Power SDL.Raw.Thread
    SDL.Raw.Timer SDL.Raw.Types SDL.Raw.Video SDL.Time SDL.Vect
    SDL.Video SDL.Video.OpenGL SDL.Video.Renderer SDL.Video.Vulkan

hidden-modules:         Data.Bitmask
import-dirs:            /usr/lib/ghc-9.4.8/site-local/sdl2-2.5.5.1
library-dirs:           /usr/lib/ghc-9.4.8/site-local/sdl2-2.5.5.1
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/sdl2-2.5.5.1
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-sdl2
hs-libraries:           HSsdl2-2.5.5.1-9EukOxt85tj8W3LRVeiQ4N
extra-libraries:        SDL2 SDL2
extra-libraries-static: SDL2
include-dirs:           /usr/include/SDL2
includes:               SDL.h SDL_vulkan.h sdlhelper.h
depends:
    StateVar-1.2.2-2qg6a9t7WOj8KHyna31Hkh base-4.17.2.1
    bytestring-0.11.5.3 exceptions-0.10.5
    linear-1.22-5ucMogxcFvc4I8CZUy2nU3 text-2.0.2 transformers-0.5.6.2
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:     /usr/share/doc/haskell-sdl2/html/sdl2.haddock
haddock-html:           /usr/share/doc/haskell-sdl2/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

