#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3
visibility:           public
id:                   semialign-1.3-6v8VR1bISk921DN2jgqoNg
key:                  semialign-1.3-6v8VR1bISk921DN2jgqoNg
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  5a9018a534df9e0a2fb38757a36dad5f
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3-6v8VR1bISk921DN2jgqoNg
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    indexed-traversable-0.1.4-BSYyyvjYdHp35O5zcaRCt5
    indexed-traversable-instances-0.1.2-A3PJtzoBqd29kL5je5xT0
    semigroupoids-6.0.0.1-EsDekxjOCgO6Hkl2ZFNy0d
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2-HHBDt6FdrNkB5x4JzaevG8 transformers-0.5.6.2
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

