#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3
visibility:           public
id:                   semialign-1.3-7FNiLULDu9HLBvM6gONS63
key:                  semialign-1.3-7FNiLULDu9HLBvM6gONS63
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  027dc1a97402777a706c677da7c820ee
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3-7FNiLULDu9HLBvM6gONS63
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    indexed-traversable-0.1.4-AIrw26zjgKT4obC66VIWQz
    indexed-traversable-instances-0.1.2-IizBWnM9NpjG9H2LtI8Aek
    semigroupoids-6.0.0.1-6XCIA6U3UWn2hao4L7fY7n
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2-FJpJ4Y80QbS4FsZ2fGftoO transformers-0.5.6.2
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

