#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 shake
version:              0.19.6
visibility:           public
id:                   shake-0.19.6-EcBK5tSb3rIkp5RdoRm00
key:                  shake-0.19.6-EcBK5tSb3rIkp5RdoRm00
license:              BSD-3-Clause
copyright:            Neil Mitchell 2011-2021
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://shakebuild.com
synopsis:
    Build system library, like Make, but more accurate dependencies.

description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. The homepage contains links to a user
    manual, an academic paper and further information:
    <https://shakebuild.com>

    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).

category:             Development, Shake
abi:                  e19b28d65c9cbe2aad32321ad656fe33
exposed:              True
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.Database Development.Shake.FilePath
    Development.Shake.Forward Development.Shake.Rule
    Development.Shake.Util

hidden-modules:
    Development.Ninja.Env Development.Ninja.Lexer
    Development.Ninja.Parse Development.Ninja.Type
    Development.Shake.Internal.Args
    Development.Shake.Internal.CmdOption
    Development.Shake.Internal.CompactUI
    Development.Shake.Internal.Core.Action
    Development.Shake.Internal.Core.Build
    Development.Shake.Internal.Core.Database
    Development.Shake.Internal.History.Shared
    Development.Shake.Internal.History.Symlink
    Development.Shake.Internal.History.Bloom
    Development.Shake.Internal.History.Cloud
    Development.Shake.Internal.History.Network
    Development.Shake.Internal.History.Server
    Development.Shake.Internal.History.Serialise
    Development.Shake.Internal.History.Types
    Development.Shake.Internal.Core.Monad
    Development.Shake.Internal.Core.Pool
    Development.Shake.Internal.Core.Rules
    Development.Shake.Internal.Core.Run
    Development.Shake.Internal.Core.Storage
    Development.Shake.Internal.Core.Types
    Development.Shake.Internal.Demo Development.Shake.Internal.Derived
    Development.Shake.Internal.Errors
    Development.Shake.Internal.FileInfo
    Development.Shake.Internal.FileName
    Development.Shake.Internal.FilePattern
    Development.Shake.Internal.Options Development.Shake.Internal.Paths
    Development.Shake.Internal.Profile
    Development.Shake.Internal.Progress
    Development.Shake.Internal.Resource
    Development.Shake.Internal.Rules.Default
    Development.Shake.Internal.Rules.Directory
    Development.Shake.Internal.Rules.File
    Development.Shake.Internal.Rules.Files
    Development.Shake.Internal.Rules.Oracle
    Development.Shake.Internal.Rules.OrderOnly
    Development.Shake.Internal.Rules.Rerun
    Development.Shake.Internal.Value General.Bilist General.Binary
    General.Chunks General.Cleanup General.Fence General.EscCodes
    General.Extra General.FileLock General.GetOpt General.Ids
    General.Intern General.ListBuilder General.Makefile General.Pool
    General.Process General.Template General.Thread General.Timing
    General.TypeMap General.Wait Paths_shake

import-dirs:          /usr/lib/ghc-9.4.8/site-local/shake-0.19.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/shake-0.19.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/shake-0.19.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-shake
hs-libraries:         HSshake-0.19.6-EcBK5tSb3rIkp5RdoRm00
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 deepseq-1.4.8.0
    directory-1.3.7.1 extra-1.7.16-9yFW5HMy3QJKMvZBMWGOPz
    filepath-1.4.2.2 filepattern-0.1.3-GjbLXAmIFR6Ft6Qx2TSRtX
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    heaps-0.4.1-6DMDHeuU89VATLJhdRNa8v
    js-dgtable-0.5.2-GJOZPjRBXVeCze8bD7YdfT
    js-flot-0.8.3-IKtJvuN3TOl6yoqyRfRs9e
    js-jquery-3.3.1-FsB6o4nh5WtDhgp9CVq9k8
    primitive-0.7.4.0-K4IT7bUBj0c2CIJh0yt8eH process-1.6.18.0
    random-1.2.1.2-IN7ymD0AKvltzeAmi6gkc time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unordered-containers-0.2.20-2oScjwZejU42oDENjBi2vG
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP

haddock-interfaces:   /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html:         /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

