#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 splitmix
version:              0.1.2
visibility:           public
id:                   splitmix-0.1.2-7yBRfJwuB5KIOfErQI2ckx
key:                  splitmix-0.1.2-7yBRfJwuB5KIOfErQI2ckx
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
synopsis:             Fast Splittable PRNG
description:
    Pure Haskell implementation of SplitMix described in

    Guy L. Steele, Jr., Doug Lea, and Christine H. Flood. 2014.
    Fast splittable pseudorandom number generators. In Proceedings
    of the 2014 ACM International Conference on Object Oriented
    Programming Systems Languages & Applications (OOPSLA '\''14). ACM,
    New York, NY, USA, 453-472. DOI:
    <https://doi.org/10.1145/2660193.2660195>

    The paper describes a new algorithm /SplitMix/ for /splittable/
    pseudorandom number generator that is quite fast: 9 64 bit arithmetic/logical
    operations per 64 bits generated.

    /SplitMix/ is tested with two standard statistical test suites (DieHarder and
    TestU01, this implementation only using the former) and it appears to be
    adequate for "everyday" use, such as Monte Carlo algorithms and randomized
    data structures where speed is important.

    In particular, it __should not be used for cryptographic or security applications__,
    because generated sequences of pseudorandom values are too predictable
    (the mixing functions are easily inverted, and two successive outputs
    suffice to reconstruct the internal state).

category:             System, Random
abi:                  b690a079d39c81aa37b4b8e0d4cd30d2
exposed:              True
exposed-modules:      System.Random.SplitMix System.Random.SplitMix32
hidden-modules:       Data.Bits.Compat System.Random.SplitMix.Init
import-dirs:          /usr/lib/ghc-9.4.8/site-local/splitmix-0.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/splitmix-0.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/splitmix-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-splitmix
hs-libraries:         HSsplitmix-0.1.2-7yBRfJwuB5KIOfErQI2ckx
depends:              base-4.17.2.1 deepseq-1.4.8.0
haddock-interfaces:   /usr/share/doc/haskell-splitmix/html/splitmix.haddock
haddock-html:         /usr/share/doc/haskell-splitmix/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

