#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 statistics
version:              0.16.3.0
visibility:           public
id:                   statistics-0.16.3.0-7t1mcZWqDWLHthMGHHf0e
key:                  statistics-0.16.3.0-7t1mcZWqDWLHthMGHHf0e
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
      distributions.  (There are dozens of exotic distributions in use;
      we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
      estimation, histograms, bootstrap methods, significance testing,
      and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
      samples.

category:             Math, Statistics
abi:                  aaf2a9aaef2c35dfe1a5af5ab87db289
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/statistics-0.16.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.3.0-7t1mcZWqDWLHthMGHHf0e
depends:
    aeson-2.1.2.1-25ntyCXNIMdHgIjcbgcdOM
    async-2.2.5-EyV9emCuOIPGUIakwGPKTd base-4.17.2.1 binary-0.8.9.1
    data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc deepseq-1.4.8.0
    dense-linear-algebra-0.1.0.0-IKseKbsCto6H9KTgqeOzHP
    math-functions-0.3.4.4-Kr33lelOH93FH8lvL6z89V
    mwc-random-0.15.2.0-54OlUXMOYIHL723c7F0xik
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    primitive-0.7.4.0-K4IT7bUBj0c2CIJh0yt8eH
    random-1.2.1.2-IN7ymD0AKvltzeAmi6gkc
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX
    vector-algorithms-0.9.1.0-J7tu3wzSwVH4L5Los1KJps
    vector-binary-instances-0.2.5.2-9VkZDsLUSZ8JxR4ppg18ah
    vector-th-unbox-0.2.2-41ATWj7ohNN3oMswHZkfTA

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

