#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 storablevector
version:              0.2.13.2
visibility:           public
id:                   storablevector-0.2.13.2-Hx3zsXjw92JE7m53CT5uTh
key:                  storablevector-0.2.13.2-Hx3zsXjw92JE7m53CT5uTh
license:              BSD-3-Clause
maintainer:           Henning Thielemann <storablevector@henning-thielemann.de>
author:
    Spencer Janssen <sjanssen@cse.unl.edu>, Henning Thielemann <storablevector@henning-thielemann.de>

stability:            Experimental
homepage:             http://www.haskell.org/haskellwiki/Storable_Vector
synopsis:
    Fast, packed, strict storable arrays with a list interface like ByteString

description:
    Fast, packed, strict storable arrays
    with a list interface,
    a chunky lazy list interface with variable chunk size
    and an interface for write access via the @ST@ monad.
    This is much like @bytestring@ and @binary@
    but can be used for every '\''Foreign.Storable.Storable'\'' type.
    See also package
    <http://hackage.haskell.org/package/vector>
    with a similar intention.

    We do not provide advanced fusion optimization,
    since especially for lazy vectors
    this would either be incorrect or not applicable.
    However we provide fusion with lazy lists in the package
    <http://hackage.haskell.org/package/storablevector-streamfusion>.

category:             Data
abi:                  8706a587926218e79b712ebcac27ce7e
exposed:              True
exposed-modules:
    Data.StorableVector Data.StorableVector.Base
    Data.StorableVector.Lazy Data.StorableVector.Lazy.Builder
    Data.StorableVector.Lazy.Pattern Data.StorableVector.Lazy.Pointer
    Data.StorableVector.Lazy.Typed Data.StorableVector.Pointer
    Data.StorableVector.ST.Lazy Data.StorableVector.ST.Strict

hidden-modules:
    Data.StorableVector.Memory Data.StorableVector.ST.Private
    Data.StorableVector.Lazy.PointerPrivate
    Data.StorableVector.Lazy.PointerPrivateIndex
    Data.StorableVector.Cursor

import-dirs:          /usr/lib/ghc-9.4.8/site-local/storablevector-0.2.13.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/storablevector-0.2.13.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/storablevector-0.2.13.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-storablevector
hs-libraries:         HSstorablevector-0.2.13.2-Hx3zsXjw92JE7m53CT5uTh
depends:
    QuickCheck-2.14.3-DOFi1GQ9eE04hBoMxr6sJJ base-4.17.2.1
    deepseq-1.4.8.0 non-negative-0.1.2-J0bmqMKPvtgt4U6MxP35u
    syb-0.7.2.4-5EQR9W4f34Nc1xy39zlm4 transformers-0.5.6.2
    unsafe-0.0-GQ6Zydb4lCS7B1Ck4GrK4S
    utility-ht-0.0.17.2-5i9xsR3R6EHCeH9zT7IqbH

haddock-interfaces:
    /usr/share/doc/haskell-storablevector/html/storablevector.haddock

haddock-html:         /usr/share/doc/haskell-storablevector/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

