#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-term
version:              1.10.0
visibility:           public
id:                   tamarin-prover-term-1.10.0-EawgkmT7x9gKI6ZQXLq1lU
key:                  tamarin-prover-term-1.10.0-EawgkmT7x9gKI6ZQXLq1lU
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.

category:             Theorem Provers
abi:                  8683f5f9425c1f9753d7cc67c879f683
exposed:              True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Macro Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm

hidden-modules:
    Term.Term Term.Term.Classes Term.Term.Raw Term.Term.FunctionSymbols
    Term.Narrowing.Narrow Term.Substitution.SubstVFree
    Term.Substitution.SubstVFresh

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tamarin-prover-term-1.10.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tamarin-prover-term-1.10.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tamarin-prover-term-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-term
hs-libraries:         HStamarin-prover-term-1.10.0-EawgkmT7x9gKI6ZQXLq1lU
depends:
    HUnit-1.6.2.0-E9thsnykSZzAJrramSPMCv
    attoparsec-0.14.4-75nKbPMSPaLAG220BErtuR base-4.18.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    dlist-1.0-BHr4eMvMSL7KTcd3FjxURn mtl-2.3.1 process-1.6.19.0
    safe-0.3.21-J8yTbFjKPpT3oBMPyWIsQW
    tamarin-prover-utils-1.10.0-9nfAVxb60ayDx24JrCOVZ

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

