#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-51yZiMuIlF16NY9T4o7BKW
key:                  tamarin-prover-utils-1.10.0-51yZiMuIlF16NY9T4o7BKW
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  1a55b945a1e39d5025942c222dbd7b8f
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-51yZiMuIlF16NY9T4o7BKW
depends:
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl base-4.17.2.1
    base64-bytestring-1.2.1.0-4fqTDsScuuX4b4re0JajdK binary-0.8.9.1
    blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0 dlist-1.0-I6FB5Nlk17hG16fxQzZSEb
    exceptions-0.10.5 fclabels-2.0.5.1-GNh7ZjwYdcD7satJIB2vRy
    graphviz-2999.20.2.1-DLhfW589gAr9Rr3R7KY7f
    list-t-1.0.5.5-Bq2yPc85Te9FvgzM9vvZa6 mtl-2.2.2 pretty-1.1.3.6
    safe-0.3.21-4dOvXTUjyTXF7ZNQNu197N
    split-0.2.5-1cvcRB3t1btB7X53ioPSfn
    syb-0.7.2.4-5EQR9W4f34Nc1xy39zlm4 text-2.0.2 time-1.12.2
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

