#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-IraZtoVF5lXCkMq4GwwsP0
key:                  tree-diff-0.3.0.1-IraZtoVF5lXCkMq4GwwsP0
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  ca9ca317242d0abf2bafffb48b4d9a2e
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-IraZtoVF5lXCkMq4GwwsP0
depends:
    QuickCheck-2.14.3-6d1PIKLXLdiAlrbWNDjj9l
    aeson-2.1.2.1-G4Y2VMvw6jlHlUlOzfqhge
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc
    ansi-wl-pprint-0.6.9-JiLCTD1fQOjCX9bEtQhD6h base-4.17.2.1
    base-compat-0.12.2-3peTS4EQIw912qC0ETmbL5 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw parsec-3.1.16.1
    parsers-0.12.12-FnpoOiuqefJ3wO6niERnzh pretty-1.1.3.6
    primitive-0.8.0.0-CgxKCR9ULfZ73CnNdOTvCD
    scientific-0.3.7.0-BkypiqTAkpN3suN2c81wMx
    semialign-1.3-ED7UxzCSv2Q8AbkTDA2r1r
    strict-0.5-4YIKjr8Hi454ypMcDfsmgm
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2-FJpJ4Y80QbS4FsZ2fGftoO time-1.12.2
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    uuid-types-1.0.6-D5yfte8gZaD2fsaKfuenjE
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

