#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-KoJVBEWIRHG479cdilC1wv
key:                  tree-diff-0.3.0.1-KoJVBEWIRHG479cdilC1wv
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  0ffa9cb51829ebbbf6f100110f595c03
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-KoJVBEWIRHG479cdilC1wv
depends:
    QuickCheck-2.15.0.1-JsWG6I4IuTa3MyVRCp1l9o
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    ansi-terminal-1.0.2-BPjCUZulbk02l8COiFLYJh
    ansi-wl-pprint-1.0.2-4O0Ceywxuw6Jfi3uDtYxbF base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-AkdCWGE5Cqm4vrMrQip090 parsec-3.1.16.1
    parsers-0.12.12-Gl5A3EMYL0rCwb1k3iRCD2 pretty-1.1.3.6
    primitive-0.9.1.0-5oPemL25pV0IilCVm0ELcB
    scientific-0.3.8.0-DJ6xks3YjY5SsKPtBx4Fi
    semialign-1.3.1-KTvSz4HbA9B7dANFtIytHe
    strict-0.5.1-BwU6ZyNzHHHL2Ah9v5JOFV
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig text-2.0.2
    these-1.2.1-K2R7aNOKLIIBgfjdvRgTEV time-1.12.2
    unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA
    uuid-types-1.0.6-GmLdfinEjHH6p6tE8CprHm
    vector-0.13.2.0-6vtrErFI1tV1Z02auPMCSS

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

