#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-CjssJvA8AFJ15tzEzLYvVE
key:                  trifecta-2.1.4-CjssJvA8AFJ15tzEzLYvVE
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  3cb1196756920dc3d2d40824725f51e2
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-CjssJvA8AFJ15tzEzLYvVE
depends:
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-CBx6h5MV2lk7ZdDgEHs1DN
    blaze-markup-0.8.3.0-EZXFp4MJaJ3KYn4Ngmh6rA bytestring-0.11.5.3
    charset-0.3.11-6WDajK0dai57VuXtZMKsW
    comonad-5.0.8-9doKR95co85HQUesdrJkPD containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-8DRwhxcExWPKPvW5r9fDDN
    ghc-prim-0.9.1 hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    indexed-traversable-0.1.4-7ph7dHdACfa9uO4tGpH9sc
    lens-5.2.3-JlyZXwZS00NBv5ScwlVipn mtl-2.2.2
    parsers-0.12.12-DSXrb12WW9pAlDntPLXdEB
    prettyprinter-1.7.1-CrZ7BsQJ9pDCXOGGFM6iz2
    prettyprinter-ansi-terminal-1.1.3-IEr2TcuCyQgMLg4vnxF9Z
    profunctors-5.6.2-1y5eXinqMYuK1INvDQniNm
    reducers-3.12.5-L3YvMadJ4D26LN5yBQTLTv transformers-0.5.6.2
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

