#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-40mwfQWhCZy7LNozctxnXn
key:                  trifecta-2.1.4-40mwfQWhCZy7LNozctxnXn
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  8750ca9964b51d93c738e02a19a10d14
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-40mwfQWhCZy7LNozctxnXn
depends:
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-D3qwGV9Roxc8l6EnhwxO2e
    blaze-markup-0.8.3.0-G85FQKlrkvzKFx9LnNhKzo bytestring-0.11.5.3
    charset-0.3.11-5l1wHgEcAto2WgFFP3DV7w
    comonad-5.0.8-HjXm8wDvlWV5Uokq8mIEQc containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-DZLTgxBhMurLq6qNornCOn
    ghc-prim-0.9.1 hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    indexed-traversable-0.1.4-BSYyyvjYdHp35O5zcaRCt5
    lens-5.2.3-9tvnz3pLdcPH5JzlkQxTXA mtl-2.2.2
    parsers-0.12.12-5OyYB0LWB7z3XJTkbw3KeS
    prettyprinter-1.7.1-KavgWlSYS7L7YXURHbWfqH
    prettyprinter-ansi-terminal-1.1.3-Hgen3XCgk2kK5VSvwdzMmJ
    profunctors-5.6.2-FCezC193SLE8IKnRHeV6TK
    reducers-3.12.5-4VyFxZoDs7MLHFH6lGf7rb transformers-0.5.6.2
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

