#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-12GjdOJkKeVKx4uynfs33w
key:                  trifecta-2.1.4-12GjdOJkKeVKx4uynfs33w
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  79f98e2085ff5128ad6b9920277ce8ab
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-12GjdOJkKeVKx4uynfs33w
depends:
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-4j6jevlp0QUEusbPG23DSX
    blaze-markup-0.8.3.0-E3xIpXEfOxQ70jxLTxkTyw bytestring-0.11.5.3
    charset-0.3.11-L8RhRHoQYYC8cQ3bZabbEO
    comonad-5.0.8-FaXCdIH358gBTaN3fXTS5x containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-KIsDGs6dB1pGDnIl3O0CzY
    ghc-prim-0.9.1 hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    indexed-traversable-0.1.4-EiyQIsHWfilLwzPb8OdnEq
    lens-5.2.3-CUB7er19pGW1jvefO3TVCG mtl-2.2.2
    parsers-0.12.12-5DckDyYNV2JEaDynl65IQL
    prettyprinter-1.7.1-HnygYT0md3kGchHDXSnUtq
    prettyprinter-ansi-terminal-1.1.3-GLHJV3CRqnmGeQE2kGDKkf
    profunctors-5.6.2-FU1ZJ7jAwY3FBezLPRDd4l
    reducers-3.12.5-LqM7V1xLW3TEkbRBuAOpqv transformers-0.5.6.2
    unordered-containers-0.2.20-FzN23deFW3GkzXU7VwkDd
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

