#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wai-extra
version:              3.1.15
visibility:           public
id:                   wai-extra-3.1.15-41dDaWlg83MTU2NmqfRAb
key:                  wai-extra-3.1.15-41dDaWlg83MTU2NmqfRAb
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  43523d7cefb74be4f95c2159d4e78746
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.ValidateHeaders Network.Wai.Middleware.Vhost
    Network.Wai.Parse Network.Wai.Request Network.Wai.Test
    Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.15
library-dirs:         /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.15
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.15-41dDaWlg83MTU2NmqfRAb
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    aeson-2.1.2.1-25ntyCXNIMdHgIjcbgcdOM
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc base-4.17.2.1
    base64-bytestring-1.2.1.0-9rjbyifcAWs81fTufDCHjJ
    bytestring-0.11.5.3 call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi containers-0.6.7
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm
    data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc directory-1.3.7.1
    fast-logger-3.1.2-9yPztK5UNn5H7qGHwIPw0f
    http-types-0.12.4-84PTldXFVlSHvwiFY4h2Wj
    iproute-1.7.15-9JxnpczC4e89Id6JnOCa0T
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    resourcet-1.2.6-Emy1WDuYe6W3crmrzZuLqP
    streaming-commons-0.2.2.6-LPUPGkna0351Ib2Wvmo9tO text-2.0.2
    time-1.12.2 transformers-0.5.6.2 unix-2.7.3
    vault-0.3.1.5-G2HaUpHmWt97UYQ6YQOO3p
    wai-3.2.4-EQmFL7xABCGF5LTxYaF04l
    wai-logger-2.5.0-2jT91xZOIhG9AQGkOAm7tS
    warp-3.3.30-InrHVAHvwNM9xTnQ2Vn2RB
    word8-0.1.3-H2XlNdB8B5CGwrdA9Iis9I

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

