#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wai-extra
version:              3.1.18
visibility:           public
id:                   wai-extra-3.1.18-AFygdGMBury4EFoszcDuf4
key:                  wai-extra-3.1.18-AFygdGMBury4EFoszcDuf4
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  f43a924c3e1e6560fe3d8c79097e7ab8
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.ValidateHeaders Network.Wai.Middleware.Vhost
    Network.Wai.Parse Network.Wai.Request Network.Wai.Test
    Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
library-dirs:         /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.18-AFygdGMBury4EFoszcDuf4
depends:
    HUnit-1.6.2.0-E9thsnykSZzAJrramSPMCv
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    ansi-terminal-1.0.2-BPjCUZulbk02l8COiFLYJh base-4.18.2.1
    base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t bytestring-0.11.5.3
    call-stack-0.4.0-1lKHXCITPU8FW27H1kph6t
    case-insensitive-1.2.1.0-5HTh5m1rt1RHDEKgWxawKc containers-0.6.7
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5
    data-default-0.7.1.3-DC0AJbPUVLOH54ZbhVmf2Q directory-1.3.8.5
    fast-logger-3.2.4-ByTPELCQcLS3duiWRhOPm7
    http-types-0.12.4-47H2c8g9PRZ51oXX8MMJrI
    iproute-1.7.15-7wpMLPRH1VwFjHkZ7amvt5
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    resourcet-1.2.6-EtMPDqHsQrqoGIXSo7kAd
    streaming-commons-0.2.3.0-4zfd3TiPO7FHahh1vGkzdl text-2.0.2
    time-1.12.2 transformers-0.6.1.0 unix-2.8.4.0
    vault-0.3.1.5-3NT2ZmKxNtOCa9B8iilwVI
    wai-3.2.4-29lPZrUTVnS94Mmm983Wpw
    wai-logger-2.5.0-8nPdfjtPY3N2sb79OtjDWy
    warp-3.4.0-FMWkdBE2f7G7xiJ74SO0dX
    word8-0.1.3-7y8d2ts6b899pqfTpiB4ap

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

