#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 websockets
version:              0.12.7.3
visibility:           public
id:                   websockets-0.12.7.3-CgUQadaexo2Fecw35OV3EB
key:                  websockets-0.12.7.3-CgUQadaexo2Fecw35OV3EB
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  fe4a9cacdaf3c5be5e8170ab73cf1a1c
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/websockets-0.12.7.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/websockets-0.12.7.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/websockets-0.12.7.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-websockets
hs-libraries:         HSwebsockets-0.12.7.3-CgUQadaexo2Fecw35OV3EB
depends:
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    async-2.2.5-EyV9emCuOIPGUIakwGPKTd
    attoparsec-0.14.4-21g0xvIiXNtBpdLdrKPYdv base-4.17.2.1
    base64-bytestring-1.2.1.0-9rjbyifcAWs81fTufDCHjJ binary-0.8.9.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    clock-0.8.4-F8kQjGRulE8CGDgSTshiM containers-0.6.7
    entropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    random-1.2.1.2-IN7ymD0AKvltzeAmi6gkc
    streaming-commons-0.2.2.6-LPUPGkna0351Ib2Wvmo9tO text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

