#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 websockets
version:              0.12.7.3
visibility:           public
id:                   websockets-0.12.7.3-C5BaS4zTeVZKvEerI9uGUg
key:                  websockets-0.12.7.3-C5BaS4zTeVZKvEerI9uGUg
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  847630b1418ff2aa9f2ce0b7341a73c6
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.6.6/site-local/websockets-0.12.7.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/websockets-0.12.7.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/websockets-0.12.7.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-websockets
hs-libraries:         HSwebsockets-0.12.7.3-C5BaS4zTeVZKvEerI9uGUg
depends:
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    async-2.2.5-7rznh9Npau1HJJ6XeEC4Wn
    attoparsec-0.14.4-75nKbPMSPaLAG220BErtuR base-4.18.2.1
    base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t binary-0.8.9.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-5HTh5m1rt1RHDEKgWxawKc
    clock-0.8.4-IWGGiWVRGO6DvoMHIcmZzf containers-0.6.7
    entropy-0.4.1.11-1vtyWzOCursffXS6ZqzcH
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    random-1.2.1.3-C14Fl3rgvPx2fjwzAUclRk
    streaming-commons-0.2.3.0-4zfd3TiPO7FHahh1vGkzdl text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

