#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 what4
version:              1.5.1
visibility:           public
id:                   what4-1.5.1-97SbTV2XsgUK9pRIG1baMQ
key:                  what4-1.5.1-97SbTV2XsgUK9pRIG1baMQ
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  b663c94d89a5e546d89c7894f64f59e8
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.CVC5
    What4.Solver.DReal What4.Solver.ExternalABC What4.Solver.STP
    What4.Solver.Yices What4.Solver.Z3 What4.SpecialFunctions
    What4.Symbol What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.FloatHelpers
    What4.Utils.HandleReader What4.Utils.IncrHash What4.Utils.LeqMap
    What4.Utils.MonadST What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.4.8/site-local/what4-1.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/what4-1.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/what4-1.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.5.1-97SbTV2XsgUK9pRIG1baMQ
depends:
    BoundedChan-1.0.3.0-LpypBc0eid95svZdMy7DB6
    async-2.2.5-1OQdSrpaQikD5R3gghkNQo
    attoparsec-0.14.4-DGiM2cMH1LKFsy4siuUEV5 base-4.17.2.1
    bifunctors-5.6-48r3ezHFX5DJYoFMQ8yZxh
    bimap-0.5.0-FQnhfBhMP1OCcE0ZjtuJs6
    bv-sized-1.0.5-BszCdtS44gbLuB12b9mCHQ bytestring-0.11.5.3
    concurrent-extra-0.7.0.12-Ic3GP77fjVx1MDaoNwK9Eb
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    deepseq-1.4.8.0 deriving-compat-0.6.6-GJTBNtMwtuZKTL7syVIKgY
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    fingertree-0.1.5.0-96qcWEmQkXYY7OhfoyDuI ghc-prim-0.9.1
    hashable-1.4.4.0-3qP5TxmiOmVGP173jSDFZO
    hashtables-1.3.1-hn1nHWjpAD4mUAlCCnC95
    io-streams-1.5.2.2-LG4u21vAMKvFisDde9YIWA
    lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3 libBF-0.6.6-LOdOb8h68trZuWFa4Az0m
    megaparsec-9.6.1-iLYYaEwT1u7mxYx9b63Ap mtl-2.2.2
    ordered-containers-0.2.4-LnO56NkpGyGGIP4Bkk0JD2
    panic-0.4.0.1-43gjwtFDWNE3rZ0eFzNWpd
    parameterized-utils-2.1.9.0-1l1Rk7m1m2C9qYcwtDmdrp parsec-3.1.16.1
    prettyprinter-1.7.1-6jCWnP5jsaKCzg7tcQDjYG process-1.6.18.0
    s-cargot-0.1.6.0-DKTcvs2hgMJK6ftkDsziym
    scientific-0.3.7.0-D2shAS6j7tCClWMfBXaB6J stm-2.5.1.0
    template-haskell-2.19.0.0 temporary-1.3-5IaURyLNc9S6BSYwZuQHRq
    text-2.0.2 th-lift-0.8.4-3Jqcte1pbUvKHGfrg0advG
    th-lift-instances-0.1.20-8lUbqpJxHpLHYkXusYAiqn time-1.12.2
    transformers-0.5.6.2 unliftio-0.2.25.1-KoAUwIIyk4m4OHQUsvge0I
    unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP
    vector-0.13.1.0-3m7HMvWbOJNDnUiYgFdHrI
    versions-6.0.4-GsaW3T8O3nhJscXAC32eyS
    zenc-0.1.2-I6pxTZwPkWTEshV4yRsrz

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

