#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wide-word
version:              0.1.7.0
visibility:           public
id:                   wide-word-0.1.7.0-JH94sQ3OXf23VmgXq8K4VO
key:                  wide-word-0.1.7.0-JH94sQ3OXf23VmgXq8K4VO
license:              BSD-2-Clause
copyright:
    Copyright (c) 2017 Erik de Castro Lopo <erikd@mega-nerd.com>

maintainer:           erikd@mega-nerd.com
author:               Erik de Castro Lopo
stability:            provisional
homepage:             https://github.com/erikd/wide-word
synopsis:
    Data types for large but fixed width signed and unsigned integers

description:
    A library to provide data types for large (ie > 64 bits) but fixed width signed
    and unsigned integers with the usual typeclass instances to allow them to be used
    interchangeably with `Word64`.

    The types and operations are coded to be as fast as possible using strictness
    annotations, `INLINEABLE` pragmas and unboxed values and operations where
    appropriate.

category:             Data
abi:                  08765704e2728ea710a6711e67e62aef
exposed:              True
exposed-modules:
    Data.WideWord Data.WideWord.Int128 Data.WideWord.Word128
    Data.WideWord.Word256 Data.WideWord.Word64

hidden-modules:       Data.WideWord.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.7.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.7.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.7.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wide-word
hs-libraries:         HSwide-word-0.1.7.0-JH94sQ3OXf23VmgXq8K4VO
depends:
    base-4.17.2.1 binary-0.8.9.1 deepseq-1.4.8.0 ghc-prim-0.9.1
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    primitive-0.8.0.0-CgxKCR9ULfZ73CnNdOTvCD

haddock-interfaces:   /usr/share/doc/haskell-wide-word/html/wide-word.haddock
haddock-html:         /usr/share/doc/haskell-wide-word/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

