#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wreq
version:              0.5.4.3
visibility:           public
id:                   wreq-0.5.4.3-5a4RxbYuhH1AoTJrXrRMyo
key:                  wreq-0.5.4.3-5a4RxbYuhH1AoTJrXrRMyo
license:              BSD-3-Clause
copyright:            2014 Bryan O'\''Sullivan
maintainer:           bos@serpentine.com
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://www.serpentine.com/wreq
synopsis:             An easy-to-use HTTP client library.
description:
    .
    A web client library that is designed for ease of use.
    .
    Tutorial: <http://www.serpentine.com/wreq/tutorial.html>
    .
    Features include:
    .
    * Simple but powerful `lens`-based API
    .
    * A solid test suite, and built on reliable libraries like
      http-client and lens
    .
    * Session handling includes connection keep-alive and pooling, and
      cookie persistence
    .
    * Automatic response body decompression
    .
    * Powerful multipart form and file upload handling
    .
    * Support for JSON requests and responses, including navigation of
      schema-less responses
    .
    * Basic and OAuth2 bearer authentication
    .
    * Early TLS support via the tls package

category:             Web
abi:                  7d4e709f1af4d6ba5e8915f250d5c816
exposed:              True
exposed-modules:
    Network.Wreq Network.Wreq.Cache Network.Wreq.Cache.Store
    Network.Wreq.Lens Network.Wreq.Session Network.Wreq.Types

hidden-modules:
    Network.Wreq.Internal Network.Wreq.Internal.AWS
    Network.Wreq.Internal.Lens Network.Wreq.Internal.Link
    Network.Wreq.Internal.OAuth1 Network.Wreq.Internal.Types
    Network.Wreq.Lens.Machinery Network.Wreq.Lens.TH Paths_wreq

import-dirs:          /usr/lib/ghc-9.4.8/site-local/wreq-0.5.4.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/wreq-0.5.4.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/wreq-0.5.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wreq
hs-libraries:         HSwreq-0.5.4.3-5a4RxbYuhH1AoTJrXrRMyo
depends:
    aeson-2.1.2.1-LpT6Mf0v1IAHC9jBcKu3TC
    attoparsec-0.14.4-8RYxJQa7MEjKmC3I11Us4k
    authenticate-oauth-1.7-GrYLME4uhAyI1SOH3cZ62m base-4.17.2.1
    base16-bytestring-1.0.2.0-IEtpsrDkMVlLM4YsQhzHqm
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    containers-0.6.7 crypton-0.34-FBCi8YNA1Yo8PBEQxV02X0
    exceptions-0.10.5 ghc-prim-0.9.1
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    http-client-0.7.17-CKsA30YmMYALZuCSdtq8LI
    http-client-tls-0.3.6.4-8dz8Cr1EoJ9CU6gnshIr0Z
    http-types-0.12.4-1DZFzfvJVK9AHfgKU8FkY3
    lens-5.2.3-1xyXEUn2kF27mSgPIa0sOB
    lens-aeson-1.2.3-DkmcD9Ux9E52urdjwzmY4A
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    mime-types-0.1.2.0-3JrdaebXJwiILES3glDFuq
    psqueues-0.2.8.1-BmPfQ6Xl0r3FjxEaLQ3Wop template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX

haddock-interfaces:   /usr/share/doc/haskell-wreq/html/wreq.haddock
haddock-html:         /usr/share/doc/haskell-wreq/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

