#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-Kn37AdiwoPV6Mafq7cJHox
key:                  hledger-1.32.1-Kn37AdiwoPV6Mafq7cJHox
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  3fd5bf03b94b26d1f7780c3b29ac461f
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-Kn37AdiwoPV6Mafq7cJHox
depends:
    Decimal-0.5.2-55370Kh9SkrLNoT3WuKIz8
    Diff-0.4.1-76hxB7iu2dgLeu2Kxqhnk5
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    directory-1.3.7.1 extra-1.7.16-5U9Z4JlXvjsGJBQPJ1GjLc
    filepath-1.4.2.2 githash-0.1.6.3-3vcRf7hgbJ47LDacFT0SQm
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig haskeline-0.8.2
    hledger-lib-1.32.1-CRlOCK4TbXk2nSwabV1Zu5
    lucid-2.11.20230408-HeCn2t5PXY0G5NZE2WjqB1
    math-functions-0.3.4.4-JzCGznU2KPF7IipcqUlQul
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.2-Lx2wVcETmehVQz7NWfugc
    safe-0.3.21-4dOvXTUjyTXF7ZNQNu197N
    shakespeare-2.1.0.1-4q1tcSAy5ff4X8pM6ZhNUT
    split-0.2.5-1cvcRB3t1btB7X53ioPSfn
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-1VgnHOByr8AIto1CnZp8DF
    temporary-1.3-DSwRVjKLwjO89xYYcHNeSA terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.2.1.1-DW4IC0lnxZ04ChJYeMNrJz time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-5i9xsR3R6EHCeH9zT7IqbH
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

