#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-AL2nKUlpYnY7ZhUA6iCgZ6
key:                  hledger-1.32.1-AL2nKUlpYnY7ZhUA6iCgZ6
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  530f7aedeab32efc62ee352dbf2ef7bd
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-AL2nKUlpYnY7ZhUA6iCgZ6
depends:
    Decimal-0.5.2-FsEz2BONZe39SB6kyNtLtL
    Diff-0.4.1-BOxCLpHEbnv464iV7Wt9tY
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    directory-1.3.7.1 extra-1.7.16-Dogq4JQiVI0JTl9E7yM5k0
    filepath-1.4.2.2 githash-0.1.6.3-95uCDk2gkLh1hkiwmbGECF
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1 haskeline-0.8.2
    hledger-lib-1.32.1-KjVY589sjsNFEA23mn3N0o
    lucid-2.11.20230408-3x03UWC2tK0AASxsCveu1L
    math-functions-0.3.4.4-Kr33lelOH93FH8lvL6z89V
    megaparsec-9.6.1-K6n3nDiAbysFzcr1mYtRG7
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.2-LivcOdtZX8FLXw70uGvuNe
    safe-0.3.21-3UD7yhjS9NI84sQQ1YTdQf
    shakespeare-2.1.0.1-FMVhZjvBTmx9ZydVr29OOY
    split-0.2.5-3ghNiOjEzjd4I9aswWcGmY
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-1VgnHOByr8AIto1CnZp8DF
    temporary-1.3-AaHSdgwCXR5E2dPeV29Nhx terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.2.1.1-LSNZXu7AO2FBiZMSUtrhhk time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP
    utility-ht-0.0.17.2-63b13iRuL2w6eR4tAxymMX
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

