#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-Ckxoh5iO3BC409jb0Sedx
key:                  hledger-1.32.1-Ckxoh5iO3BC409jb0Sedx
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  990f9dbd1ef301f81dfc8922358f4aae
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-Ckxoh5iO3BC409jb0Sedx
depends:
    Decimal-0.5.2-8Pcz1CUTBp0KHJwkjuxCBB
    Diff-0.4.1-LH1ky1AbixJl32mO74dkD
    aeson-2.1.2.1-BogEXKsQPCa9ALgQQ034ff
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    directory-1.3.7.1 extra-1.7.16-EuapY98rdrN25pzQYLq3T2
    filepath-1.4.2.2 githash-0.1.6.3-ALQm9y6B8xv7q7eiZRNwFf
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw haskeline-0.8.2
    hledger-lib-1.32.1-AuWWmrJCB5JQkpFq0pTum
    lucid-2.11.20230408-341T5cOOZsE2aAmLOodfeH
    math-functions-0.3.4.4-37x3Q96nG17LhCXqDScpo0
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.2-I6io9mqXIhYC0c5uz00Sgn
    safe-0.3.21-2z6THsw90lt9vpsKu2dhGD
    shakespeare-2.1.0.1-45kM2rJPk9BFeOT30TJv4b
    split-0.2.5-zycrG25TwZLo8bmb9YFUF
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-1VgnHOByr8AIto1CnZp8DF
    temporary-1.3-5ukCxB0doMQ964otfCXv0z terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.2.1.1-AX938w52lKy3kOn5X5BgE time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-FzN23deFW3GkzXU7VwkDd
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-BZ87nbSTAkY8Gp4dS2pTTT
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

