#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.2
visibility:           public
id:                   hledger-1.43.2-35PtFI9IuM2AjdGZeVA8ff
key:                  hledger-1.43.2-35PtFI9IuM2AjdGZeVA8ff
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  ff2d989c46793526340bfd57e620d98b
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.2-35PtFI9IuM2AjdGZeVA8ff
depends:
    Decimal-0.5.2-Af3xAKquLOBAKF6i1Pzx60
    Diff-0.4.1-L8DOUuNGxiiH0X79lq9Zn6
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    ansi-terminal-1.0.2-KEBwSt8cOBhArBBqY461TL base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV
    directory-1.3.7.1 extra-1.7.16-GLSgophAXHdJnn9BzoNHrD
    filepath-1.4.2.2 githash-0.1.6.3-DSdK1ItJpfhHN9SGwhtKsL
    hashable-1.4.4.0-D3M5e9EeJxCJTqzfO7ugwa haskeline-0.8.2
    hledger-lib-1.43.2-Kgavk2y7EnsE1fiUDiupIL
    http-client-0.7.18-459exqS5txS1OoId3JMPZk
    http-types-0.12.4-GvCYNDYAmXh2LOy70F8sjw
    lucid-2.11.20230408-BcudTv2OHEdcS13X6DnrN
    math-functions-0.3.4.4-Dkon7u36GIY5AHdC58AYwk
    megaparsec-9.6.1-EGAiipKGhRa2zjyQ3XtPp3
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    modern-uri-0.3.6.1-Ar9xHkgq28Q4yWnFYRGhXC mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-2Uo4qPcx0CLKy09GMSjSu0
    req-3.13.2-65dQZFEgqT4KHcRtjVOHyM
    safe-0.3.21-GZFxfFIeXyQJFmn6rktbsO
    shakespeare-2.1.3-IO4xJ2YxjXHvynWE8goMP
    split-0.2.5-KlKHd5o1KWaBkefamTdKTk
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-9dAIvYL9PVBHOxSIGECWdI
    temporary-1.3-FQWpMYFFv2g2HCDcFkOPeW text-2.0.2
    text-ansi-0.3.0.1-KtATPWQYlioGH53SrK23Fz time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-LpnU5SHMhm91LgYhnMuHkR
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

