#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.20
visibility:           public
id:                   hledger-iadd-1.3.20-L34UzaU2RffCfNjm6ZZjXg
key:                  hledger-iadd-1.3.20-L34UzaU2RffCfNjm6ZZjXg
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  93eaf534d369458d5fc12fc138817977
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.20-L34UzaU2RffCfNjm6ZZjXg
depends:
    base-4.17.2.1 brick-1.8-7mexeqeaXci8TzXpF2TO5Q containers-0.6.7
    directory-1.3.7.1 free-5.2-HhWVdOgT53PDesI8jmlVQC
    hledger-lib-1.32.1-LUpCwYOKA509CIzI5k9Det
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z text-2.0.2
    text-zipper-0.13-8iNIVGlg4tKLdSuRJHjwxm time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD
    vty-5.39-D4IQ5SMIqe3J0MlIWbKalt
    xdg-basedir-0.2.2-GUgbFy73ZJ02w1NqlBIm8a

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

