#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-CzEQU81pBA92WmoVD72wSB
key:                  hledger-web-1.32.1-CzEQU81pBA92WmoVD72wSB
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  696a7e0de9e8c052bb00f83fd120a06c
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-CzEQU81pBA92WmoVD72wSB
depends:
    Decimal-0.5.2-HPJ5Y3mX55UKvAlplieLNe
    aeson-2.1.2.1-8pX4IwvbwpcwXiIiReOQk base-4.17.2.1
    base64-0.4.2.4-2TeuSOzKEmb3oGPx4hROSU
    blaze-html-0.9.2.0-FWprMpS5oXB3TQTejb8SVX
    blaze-markup-0.8.3.0-GVg3uwYX4EYA8tXwTbT8Im bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4CWBjbNVYtn1DyQhk43ZQ9
    clientsession-0.9.2.0-6hqyk6pZy60CXWsnZ9ZBz1
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-L447JUvNddBC7PkE6UyQyv
    conduit-extra-1.3.6-CzDgdjNDXBkKwoWdIabZpV containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-CT2Pr7M0vEzLXqrliS0eki filepath-1.4.2.2
    hjsmin-0.2.1-KmwYAWNI07K1PDOxToPQh1
    hledger-1.32.1-KYIkTKKJs7JkxNnMF6LBH
    hledger-lib-1.32.1-GtX5ercQtFjF8p0T7vuvLw
    hspec-2.10.9-D378BdOjvbWASx7n6OvAbM
    http-client-0.7.17-4LgBMBy5FNk53TDUVte9gy
    http-conduit-2.3.9.1-IKyimMDqmCkJiUCcbCCFZI
    http-types-0.12.4-7BozLfTXeEWGYT0EKpPSnr
    megaparsec-9.6.1-iLYYaEwT1u7mxYx9b63Ap mtl-2.2.2
    network-3.1.4.0-ExLckjbUqaB9dQ68XDq8jI
    safe-0.3.21-BBVCREVAhYi1ojPWc3Ddy2
    shakespeare-2.1.0.1-Dqr2XffI7EqB8mLQVHPFor
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-KqOYYD0XcO3Fn0qLI9KKk9
    unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP
    wai-3.2.4-KXaRlag2H8u14yPy2nJnqM
    wai-cors-0.2.7-2AhW9Dor6fq6yrXefuEkhJ
    wai-extra-3.1.15-Q65XhisThLHHUf6JXHACt
    wai-handler-launch-3.0.3.1-1fhNVTk0mQA3MhBqnnn5EO
    warp-3.3.30-Dl0dGRDWV133XOwu4MlsFM
    yaml-0.11.11.2-DsGNUCV0r394NdsLl47GEo
    yesod-1.6.2.1-EYO0IFmQkfS9o09zXBssVH
    yesod-core-1.6.26.0-EFJoaiVuE2A8PNJtHoCtBG
    yesod-form-1.7.6-1NNjfU9bGPDCmsyr3LQsBX
    yesod-static-1.6.1.0-9Jz2V3kuyR19QxCPdprB0C
    yesod-test-1.6.16-Jkk4CeNwh18HTZAl7lrXcx

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

