#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-5SOtGDCRwg3CI0SlQyyMNj
key:                  hledger-web-1.32.1-5SOtGDCRwg3CI0SlQyyMNj
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  f3d2f18f069d88618dca97839c226ef8
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-5SOtGDCRwg3CI0SlQyyMNj
depends:
    Decimal-0.5.2-55370Kh9SkrLNoT3WuKIz8
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3 base-4.17.2.1
    base64-0.4.2.4-GB4CXQf5FWa8J1P1Jwc3zm
    blaze-html-0.9.2.0-CBx6h5MV2lk7ZdDgEHs1DN
    blaze-markup-0.8.3.0-EZXFp4MJaJ3KYn4Ngmh6rA bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap
    clientsession-0.9.2.0-CPAzCSnISwOJF07CZKKGL2
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-KbvjUYjGZ6BDMEb3OqHdCI
    conduit-extra-1.3.6-6TZXJFN31N94RP34wbzUwl containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-5U9Z4JlXvjsGJBQPJ1GjLc filepath-1.4.2.2
    hjsmin-0.2.1-91XdAYdSgso7KMybwtsznw
    hledger-1.32.1-Kn37AdiwoPV6Mafq7cJHox
    hledger-lib-1.32.1-CRlOCK4TbXk2nSwabV1Zu5
    hspec-2.10.9-1qton6n7NPA9kQgObjl3cK
    http-client-0.7.17-2bmcHc0cHmODspv0lmZ3j1
    http-conduit-2.3.9.1-GvCihXb311B4a3J86QrNqb
    http-types-0.12.4-cGP4COhpCbDmQiO5iBXAE
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI mtl-2.2.2
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    safe-0.3.21-4dOvXTUjyTXF7ZNQNu197N
    shakespeare-2.1.0.1-4q1tcSAy5ff4X8pM6ZhNUT
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-I0I036G2mUMHO86izhUL6u
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-GUoXUoY24VCBryLqTBaLdB
    wai-cors-0.2.7-CGE1rSDkVeD2tcBkTjwb3r
    wai-extra-3.1.15-8tjZLPgxNd9L0t5wVWsdiH
    wai-handler-launch-3.0.3.1-7pPECXl80ktBno3wr9EJ6Z
    warp-3.3.30-BGR5Wbz9ZcR2jBwEhCRmIG
    yaml-0.11.11.2-4qRa9tGxPq4CL7IrSLcz39
    yesod-1.6.2.1-2zQ4z3V7BXvDKF2x6GaGYg
    yesod-core-1.6.26.0-JY57BWO7ii09hpiFZNbfok
    yesod-form-1.7.6-cCgBHa7LisI3GF7NOwyK
    yesod-static-1.6.1.0-DIFjDvZU8xSLEZzVsPaKX8
    yesod-test-1.6.16-6MG5L31is4VAVA6hQW9fCA

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

