#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-Fz2x2LSULlvLF1NU8XSe0D
key:                  hledger-web-1.32.1-Fz2x2LSULlvLF1NU8XSe0D
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  25a161a469422e27dcf8f49d10ffc7cd
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-Fz2x2LSULlvLF1NU8XSe0D
depends:
    Decimal-0.5.2-55370Kh9SkrLNoT3WuKIz8
    aeson-2.1.2.1-Kzzie09M6AYFH8VDx0mx86 base-4.17.2.1
    base64-0.4.2.4-GB4CXQf5FWa8J1P1Jwc3zm
    blaze-html-0.9.2.0-CBx6h5MV2lk7ZdDgEHs1DN
    blaze-markup-0.8.3.0-EZXFp4MJaJ3KYn4Ngmh6rA bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap
    clientsession-0.9.2.0-CPAzCSnISwOJF07CZKKGL2
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-82jMOxZzolypQFNqeliRy
    conduit-extra-1.3.6-8gBiaUXtjjDExv3ODVmIAR containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-Bey2vPU3D4iIpeD8oPKkuc filepath-1.4.2.2
    hjsmin-0.2.1-91XdAYdSgso7KMybwtsznw
    hledger-1.32.1-3coifDjqhEMAJnYzlZU1SV
    hledger-lib-1.32.1-LUpCwYOKA509CIzI5k9Det
    hspec-2.10.9-1qton6n7NPA9kQgObjl3cK
    http-client-0.7.17-23w6wIj9GbeK9arRJvAmDK
    http-conduit-2.3.9.1-JdRoao5PYtX9eJVaLJgLLe
    http-types-0.12.4-D2DAVTmHvcDBQ0h7IvaEn9
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI mtl-2.2.2
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    safe-0.3.21-4dOvXTUjyTXF7ZNQNu197N
    shakespeare-2.1.0.1-LKMHr8gbpSbK7lDtebvCIn
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-81MwAM6mqirBxfbMnCSo42
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-8wgjzYdHzERLEzwoQEllrh
    wai-cors-0.2.7-4PwDXcUSEuY2rseTWDWJoc
    wai-extra-3.1.15-7yoWhADQOc5GZynrbLZpws
    wai-handler-launch-3.0.3.1-I8E7TIrKmLU23mER4hdR8J
    warp-3.3.30-15r15uPEVSRCpfRnQ2XK8J
    yaml-0.11.11.2-FQGR7qmzYmVGeoVQVKTN0
    yesod-1.6.2.1-ErWOZutYw26C0aZ09bJvVF
    yesod-core-1.6.26.0-BKWwSFKlgi58D3SGNOrRFb
    yesod-form-1.7.6-JQkbPhTeI5uDjtrTuU0fBu
    yesod-static-1.6.1.0-1Ys6lFnqL0wSUk94wxagb
    yesod-test-1.6.16-AJ3Gp0N9xBqKMIAqsz47Rf

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

