#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-EdFJPf1Rvo45XIqj5HJsDY
key:                  hledger-web-1.32.1-EdFJPf1Rvo45XIqj5HJsDY
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  0b64305e421e78ea62565c1f136b991c
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-EdFJPf1Rvo45XIqj5HJsDY
depends:
    Decimal-0.5.2-FsEz2BONZe39SB6kyNtLtL
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A base-4.17.2.1
    base64-0.4.2.4-K1U5P8FQ6XVKOPMGpGAqc5
    blaze-html-0.9.2.0-D3qwGV9Roxc8l6EnhwxO2e
    blaze-markup-0.8.3.0-G85FQKlrkvzKFx9LnNhKzo bytestring-0.11.5.3
    case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    clientsession-0.9.2.0-HA1vR4JuIgKLs1jVtwVRfb
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-D4YiOfvDFG0FSohx4jmvQj
    conduit-extra-1.3.6-730UVkuRTVsDj6V9AWbsl9 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-Dogq4JQiVI0JTl9E7yM5k0 filepath-1.4.2.2
    hjsmin-0.2.1-KmwYAWNI07K1PDOxToPQh1
    hledger-1.32.1-AL2nKUlpYnY7ZhUA6iCgZ6
    hledger-lib-1.32.1-KjVY589sjsNFEA23mn3N0o
    hspec-2.10.9-714aiWNOjy4He4Lhd0bDJy
    http-client-0.7.17-AUuOyA54dq3IiMr8FLNnqs
    http-conduit-2.3.9.1-4YTerV4Zzbz95yHR1YEFSW
    http-types-0.12.4-GwcjbD6je3aL0GKpFarP8k
    megaparsec-9.6.1-K6n3nDiAbysFzcr1mYtRG7 mtl-2.2.2
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    safe-0.3.21-3UD7yhjS9NI84sQQ1YTdQf
    shakespeare-2.1.0.1-FMVhZjvBTmx9ZydVr29OOY
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-J07jpPIGxfa51gt4vnZWxP
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP
    wai-3.2.4-E2qRrDkmNMh7x5fpA0TmD6
    wai-cors-0.2.7-DCKPQ394PkzEZw49GK5ksm
    wai-extra-3.1.15-KsYJmZVSEkS29jNlMUexWP
    wai-handler-launch-3.0.3.1-7xHTDlo05swJjRCnBeHDKg
    warp-3.3.30-L1ctWyNaALU8oLcnPk9wEY
    yaml-0.11.11.2-JVC7JzNxnvLG8NF94fNnFV
    yesod-1.6.2.1-93o1ivXlKya9CCk0Wxv3eG
    yesod-core-1.6.26.0-6ydpacINdasH3RzAxiG569
    yesod-form-1.7.6-IsyY3QNuzqp4t6U47MZDVR
    yesod-static-1.6.1.0-HQuauoiAJtFK898ls1q8fj
    yesod-test-1.6.16-I02annfKzHuH34ZgRmIyNE

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

