#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-3Z8wPmeJNPk7hhm38eB93r
key:                  hledger-web-1.32.1-3Z8wPmeJNPk7hhm38eB93r
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  ab921d1c83da98c3bbd7c531628233f8
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-3Z8wPmeJNPk7hhm38eB93r
depends:
    Decimal-0.5.2-FsEz2BONZe39SB6kyNtLtL
    aeson-2.1.2.1-25ntyCXNIMdHgIjcbgcdOM base-4.17.2.1
    base64-0.4.2.4-K1U5P8FQ6XVKOPMGpGAqc5
    blaze-html-0.9.2.0-D3qwGV9Roxc8l6EnhwxO2e
    blaze-markup-0.8.3.0-G85FQKlrkvzKFx9LnNhKzo bytestring-0.11.5.3
    case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    clientsession-0.9.2.0-HA1vR4JuIgKLs1jVtwVRfb
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-I25roZFZ9rtE9pq7CzsSgq
    conduit-extra-1.3.6-7TbX0I2WNNG4Wr86Zc6tp0 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-9yFW5HMy3QJKMvZBMWGOPz filepath-1.4.2.2
    hjsmin-0.2.1-KmwYAWNI07K1PDOxToPQh1
    hledger-1.32.1-UC8aGZKtwf2OL220vWuCo
    hledger-lib-1.32.1-8yb9bH1LnCp37879HxD3DL
    hspec-2.10.9-714aiWNOjy4He4Lhd0bDJy
    http-client-0.7.17-DhDd3U2QPYs2m1aaZr4mcj
    http-conduit-2.3.9.1-9v4Wz52iBNDC5lowrR1HEx
    http-types-0.12.4-84PTldXFVlSHvwiFY4h2Wj
    megaparsec-9.6.1-K6n3nDiAbysFzcr1mYtRG7 mtl-2.2.2
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    safe-0.3.21-3UD7yhjS9NI84sQQ1YTdQf
    shakespeare-2.1.0.1-GgEgR9DLA8uF306iQoIyt8
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-KodBgNM0fPsEC9GAASBuc8
    unordered-containers-0.2.20-2oScjwZejU42oDENjBi2vG
    utf8-string-1.0.2-7x3IoasPx5wHP6oJo1JvJP
    wai-3.2.4-EQmFL7xABCGF5LTxYaF04l
    wai-cors-0.2.7-HXEkpb2dEYIA4CKCfMtOR2
    wai-extra-3.1.15-41dDaWlg83MTU2NmqfRAb
    wai-handler-launch-3.0.3.1-cgJsCwuXMd2zLvhhkSFUS
    warp-3.3.30-InrHVAHvwNM9xTnQ2Vn2RB
    yaml-0.11.11.2-J2A1A3XTHw25dXvqIuVCDt
    yesod-1.6.2.1-4OTICyzcJvU10c7tsh00FW
    yesod-core-1.6.26.0-8SPG4JXHQPQ2jOKNS3X122
    yesod-form-1.7.6-KgWqy3Emwed3Qhxpfxhm0N
    yesod-static-1.6.1.0-JuaCTgiTvwZEDbyBMgGfFk
    yesod-test-1.6.16-AuJ8Pj0sySvDbCnIdKmvnW

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

