#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-CrvUO4Db15V2utTQEDJufA
key:                  hledger-web-1.32.1-CrvUO4Db15V2utTQEDJufA
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  dce4893bfb6099b867c699f1391b1ad0
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-CrvUO4Db15V2utTQEDJufA
depends:
    Decimal-0.5.2-8Pcz1CUTBp0KHJwkjuxCBB
    aeson-2.1.2.1-BogEXKsQPCa9ALgQQ034ff base-4.17.2.1
    base64-0.4.2.4-ENr4QhMI1hGIjbWOphIKBr
    blaze-html-0.9.2.0-4j6jevlp0QUEusbPG23DSX
    blaze-markup-0.8.3.0-E3xIpXEfOxQ70jxLTxkTyw bytestring-0.11.5.3
    case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    clientsession-0.9.2.0-8FF7n7u1ysRVuzYlvJFvN
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-LOkHLh1PoPRERxCd5mJQIE
    conduit-extra-1.3.6-BzKgmnVk1FZLGurLLJ1Lls containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-EuapY98rdrN25pzQYLq3T2 filepath-1.4.2.2
    hjsmin-0.2.1-91XdAYdSgso7KMybwtsznw
    hledger-1.32.1-1cdwLa3cmxD6U6WbNICU4N
    hledger-lib-1.32.1-DDz5zM7UZW533auu6Vqesw
    hspec-2.10.9-6cXDJdoLErIA03da02F3Vw
    http-client-0.7.17-GjKLViTNtmdDUQUFfydSDc
    http-conduit-2.3.9.1-LqqkJRVY5WS52jjrYi3SRv
    http-types-0.12.4-ELP3cONQaOf7BJAjzf0skh
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O mtl-2.2.2
    network-3.1.4.0-7d91dIi13MzEkgRQe6YDcO
    safe-0.3.21-2z6THsw90lt9vpsKu2dhGD
    shakespeare-2.1.0.1-45kM2rJPk9BFeOT30TJv4b
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-KCtCGW1pdTzBASuB2czuNG
    unordered-containers-0.2.20-FzN23deFW3GkzXU7VwkDd
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-BLBvejczOfIKb34BHzgZzU
    wai-cors-0.2.7-EuYcgErZyX2ErfaL9gdlik
    wai-extra-3.1.16-9CiVJLOmXcO5pPbwmQGWN5
    wai-handler-launch-3.0.3.1-5yMjEJJqUWBHVpdZqBXpcV
    warp-3.3.30-K5LlLitRC0360U7rUe6fHv
    yaml-0.11.11.2-1WP1BusTKHD3yJ3WPimHTd
    yesod-1.6.2.1-KsmzHJXoeL7I4jhUaLBlLq
    yesod-core-1.6.26.0-6ck6rgxrRVdEj5MfhMW4UT
    yesod-form-1.7.6-I5ZP2v5uXBz3OoKTN0Rk6Z
    yesod-static-1.6.1.0-3uuibKAvZTMZUaLgriTKu
    yesod-test-1.6.16-1a0n923y5UJDRvS6ieaqa6

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

