#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-JCZN2PUikyK70agiGuu9LW
key:                  hledger-web-1.32.1-JCZN2PUikyK70agiGuu9LW
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  34d85cb97ddf89865b8ecb6b8e7711b2
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-JCZN2PUikyK70agiGuu9LW
depends:
    Decimal-0.5.2-8Pcz1CUTBp0KHJwkjuxCBB
    aeson-2.1.2.1-5ZyQo9G6Ms46oZtaJgJtcb base-4.17.2.1
    base64-0.4.2.4-ENr4QhMI1hGIjbWOphIKBr
    blaze-html-0.9.2.0-4j6jevlp0QUEusbPG23DSX
    blaze-markup-0.8.3.0-E3xIpXEfOxQ70jxLTxkTyw bytestring-0.11.5.3
    case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    clientsession-0.9.2.0-8FF7n7u1ysRVuzYlvJFvN
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-1X3lgFkZstP38EJ12EjQ5N
    conduit-extra-1.3.6-AeeRClUSKBVCbjSqxWkct0 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-3SBUeFH5sHLJDtonZSgAoM filepath-1.4.2.2
    hjsmin-0.2.1-91XdAYdSgso7KMybwtsznw
    hledger-1.32.1-49V3zjRaQab9m2PRyDuGbK
    hledger-lib-1.32.1-3GDBhIUrbtXBf4kWPkMGut
    hspec-2.10.9-6cXDJdoLErIA03da02F3Vw
    http-client-0.7.17-GO4dubzcf4ODgZYG2FtYuG
    http-conduit-2.3.9.1-ukOhtNH4Lo1onyfi7nf7n
    http-types-0.12.4-DgYrgAx3aYriPsC9m33YD
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O mtl-2.2.2
    network-3.1.4.0-7d91dIi13MzEkgRQe6YDcO
    safe-0.3.21-2z6THsw90lt9vpsKu2dhGD
    shakespeare-2.1.0.1-1zCRq79PM9evJyZdPUklT template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.3-9KJlYunG6iR1P9GL6FJB0c
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-KZvF1z34PbkAehPID9Mp8a
    wai-cors-0.2.7-j8EU02vnl31HhNlOLPUWi
    wai-extra-3.1.16-9lLnqDJsSN95PMeauaRWTD
    wai-handler-launch-3.0.3.1-B3B4by0sGM683eQzqtzmGl
    warp-3.3.30-69YkHHrULiD9mXfPjM6tDO
    yaml-0.11.11.2-FolOPp2Bh3wA2Qhjh1iM08
    yesod-1.6.2.1-HFMuxvRTw5WLey2wk59sg7
    yesod-core-1.6.26.0-5RE1u6bQj463FoBf0QiNvh
    yesod-form-1.7.6-532wmGXYHOgC9oKhMfL9WK
    yesod-static-1.6.1.0-9EZ2fHGnO3lCCt75dMnRiE
    yesod-test-1.6.16-EYTqeWXNbgsBuy4UwBnqjh

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

