#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-7kjst8UmEPW5gvhZ2zoMPS
key:                  hledger-web-1.32.1-7kjst8UmEPW5gvhZ2zoMPS
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  f7fa1d9e62ee3435efc3ac30d5dd0cd4
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-7kjst8UmEPW5gvhZ2zoMPS
depends:
    Decimal-0.5.2-8Pcz1CUTBp0KHJwkjuxCBB
    aeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj base-4.17.2.1
    base64-0.4.2.4-ENr4QhMI1hGIjbWOphIKBr
    blaze-html-0.9.2.0-4j6jevlp0QUEusbPG23DSX
    blaze-markup-0.8.3.0-E3xIpXEfOxQ70jxLTxkTyw bytestring-0.11.5.3
    case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    clientsession-0.9.2.0-8FF7n7u1ysRVuzYlvJFvN
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-86fl8mgs0PcICSp2A4xyva
    conduit-extra-1.3.6-E0orZ3VxcGP3f1095Bo2Ko containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-LRPaj0kKdYhA5DC3OzySjK filepath-1.4.2.2
    hjsmin-0.2.1-91XdAYdSgso7KMybwtsznw
    hledger-1.32.1-4oT2mnSOy2S7Yd8L7aVACu
    hledger-lib-1.32.1-6BAM4ZqsiN07N8ww9vhaei
    hspec-2.10.9-6cXDJdoLErIA03da02F3Vw
    http-client-0.7.17-CKsA30YmMYALZuCSdtq8LI
    http-conduit-2.3.9.1-DLMt6nUPUnuDOCcrFsdtcu
    http-types-0.12.4-1DZFzfvJVK9AHfgKU8FkY3
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O mtl-2.2.2
    network-3.1.4.0-7d91dIi13MzEkgRQe6YDcO
    safe-0.3.21-2z6THsw90lt9vpsKu2dhGD
    shakespeare-2.1.0.1-AD7UIKDnOIUxdqDNmAzti template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.3-9Tj09IRjFnyE6cgV0AVkT
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-LaZv3Kj0Ed9gV12y2mMCG
    wai-cors-0.2.7-LcnNruth6zoIh4WZcQMk94
    wai-extra-3.1.16-I7ARULvVS8bK906k5FQwhX
    wai-handler-launch-3.0.3.1-FCII2AeR7aLGczpQ2qqvT
    warp-3.3.30-7VYQ2rBma143qilyrShCXv
    yaml-0.11.11.2-JT20IpT71d6A5uGNbiwjEW
    yesod-1.6.2.1-8XIGPOXzymO9AyZEXZs1HP
    yesod-core-1.6.26.0-1gQhTetVhel7YKGUqnl4Yf
    yesod-form-1.7.6-DwO4mB6ne3DLb4l2NHk6Xe
    yesod-static-1.6.1.0-HyS6Kg3wu28HiZk9D4TJfm
    yesod-test-1.6.16-4s2pmyaIgSwEZdOVsR4mi2

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

