#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-1q8kTwbffQoHk5A9kDgyCa
key:                  hledger-web-1.43.1-1q8kTwbffQoHk5A9kDgyCa
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  9dc1a929ae12ac5326be143bfe18f2c8
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-1q8kTwbffQoHk5A9kDgyCa
depends:
    Decimal-0.5.2-8Xz4GSRjZx8Gd79OL6YTq6
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E base-4.18.2.1
    base64-1.0-3nPgjbrBUKsA4Tt4yU4qd9
    blaze-html-0.9.2.0-8CIOWujpLcd2fSwCqkXFhk
    blaze-markup-0.8.3.0-8CtErBAglJMDcY5YauRCvR bytestring-0.11.5.3
    case-insensitive-1.2.1.0-5HTh5m1rt1RHDEKgWxawKc
    clientsession-0.9.3.0-AkOBWY5smWLH8T5K1LH8ws
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-CdT4yEwurtEjnovKY3L8i
    conduit-extra-1.3.8-4TbGFCZoahxAJpG0SOledp containers-0.6.7
    data-default-0.7.1.3-DC0AJbPUVLOH54ZbhVmf2Q directory-1.3.8.5
    extra-1.7.16-LuLvmz502dy5ojSGuZdMLA
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-CUMSqrcgeJU6Asja0MFPer
    hjsmin-0.2.1-AAipCv7yaKMCaKKGgLmByq
    hledger-1.43.1-75Y0CKMSFcK30GLKFxOY8F
    hledger-lib-1.43.1-GqY3fEIZqs88qi3NJUsGDp
    hspec-2.11.4-DEFaYWQLD7J9ehh1RD63de
    http-client-0.7.19-4oci2LEK5YS94AFA5EFYnF
    http-conduit-2.3.9.1-5y2Zd6e4KUv3WKM5rmfeZ8
    http-types-0.12.4-47H2c8g9PRZ51oXX8MMJrI
    megaparsec-9.7.0-7dpjbIWxHj2jHxEtJpJqK mtl-2.3.1
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    safe-0.3.21-J8yTbFjKPpT3oBMPyWIsQW
    shakespeare-2.1.7-c5HWIXquKn1czU5ReSNOw template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-6OqqpjAelUgGQ8Q8qYmpdb
    unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA
    utf8-string-1.0.2-4PcjKdTUnsVIUZCxTUoFbK
    wai-3.2.4-29lPZrUTVnS94Mmm983Wpw
    wai-cors-0.2.7-3ssgbTolj8cJEaO2V2YfOK
    wai-extra-3.1.18-AFygdGMBury4EFoszcDuf4
    wai-handler-launch-3.0.3.1-6XBQNTb1DMh5vPUrtG6MQo
    warp-3.4.0-FMWkdBE2f7G7xiJ74SO0dX
    yaml-0.11.11.2-GQgEfEl8kfJ6VzrCECSBYT
    yesod-1.6.2.1-1nJYoZYXK4OADeUaTwgKQL
    yesod-core-1.6.27.1-HKh2i0b2D3VKmJomdTh3zU
    yesod-form-1.7.9-1yiPSKeqihw1SLK9vhJeK4
    yesod-static-1.6.1.0-ChyVQ8Viayt2M38rDabue9
    yesod-test-1.6.23-B2aEh1YaKJLKXvpnMPALT8

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

