#===============================================================================
# Copyright 2021 Intel Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#===============================================================================

get_filename_component(_dal_root "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_dal_root "${_dal_root}/../../.." ABSOLUTE)

if (FALSE STREQUAL "TRUE")
    set(PACKAGE_VERSION )
elseif (FALSE STREQUAL "FALSE")
    # version_info.h is set according to the relevant package structure 
    set(version_info.h ${_dal_root}/include/services/library_version_info.h)
    if (NOT EXISTS "${version_info.h}")
        set(version_info.h ${_dal_root}/include/dal/services/library_version_info.h)
    endif()
    file(READ ${version_info.h} DAL_VERSION_INFO)
    string(REGEX REPLACE ".*#define __INTEL_DAAL__ ([0-9]+).*" "\\1" _dal_ver_major "${DAL_VERSION_INFO}")
    string(REGEX REPLACE ".*#define __INTEL_DAAL_MINOR__ ([0-9]+).*" "\\1" _dal_ver_minor "${DAL_VERSION_INFO}")
    string(REGEX REPLACE ".*#define __INTEL_DAAL_UPDATE__ ([0-9]+).*" "\\1" _dal_ver_patch "${DAL_VERSION_INFO}")
    set(PACKAGE_VERSION "${_dal_ver_major}.${_dal_ver_minor}.${_dal_ver_patch}.0")
endif()

if ("${PACKAGE_VERSION}" VERSION_LESS "${PACKAGE_FIND_VERSION}")
    set(PACKAGE_VERSION_COMPATIBLE FALSE)
else()
    set(PACKAGE_VERSION_COMPATIBLE TRUE)
    if ("${PACKAGE_VERSION}" VERSION_EQUAL "${PACKAGE_FIND_VERSION}")
        set(PACKAGE_VERSION_EXACT TRUE)
    endif()
endif()
