#===============================================================================
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted  materials,  and
# your use of  them is  governed by the  express license  under which  they were
# provided to you (License).  Unless the License provides otherwise, you may not
# use, modify, copy, publish, distribute,  disclose or transmit this software or
# the related documents without Intel's prior written permission.
#
# This software and the related documents  are provided as  is,  with no express
# or implied  warranties,  other  than those  that are  expressly stated  in the
# License.
#===============================================================================

# Define list of examples to run

if(NOT DEFINED PROJECT_SOURCE_DIR)
  get_filename_component(SCRIPT_PATH "${CMAKE_CURRENT_SOURCE_DIR}" REALPATH)
  set(PROJECT_SOURCE_DIR ${SCRIPT_PATH})
  message(STATUS "PROJECT_SOURCE_DIR: ${PROJECT_SOURCE_DIR}")
endif()

#Build a complete list of examples for a domain
function(listfuncs funclist domain)
  set(tmp_funcList "")
  if(EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}.lst)
    file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}.lst tmp_funcList)
  endif()
  # Add examples list for _64 APIs
  if(EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_64.lst)
    file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_64.lst tmp_64_funcList)
    list(APPEND tmp_funcList ${tmp_64_funcList})
  endif()
  # Add examples lists for omp if applicable
  if(ENABLE_OMP_OFFLOAD)
    foreach(OFFLOAD_PRECISION IN LISTS TARGET_OFFLOAD_PRECISION)
      if(EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_${OFFLOAD_PRECISION}.lst)
        file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_${OFFLOAD_PRECISION}.lst temp_${OFFLOAD_PRECISION}_funcList)
        list(APPEND tmp_funcList "${temp_${OFFLOAD_PRECISION}_funcList}")
      endif()
    endforeach()
  endif()
  # Add examples lists for particular MKL_LINK if they exist
  if(EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_${MKL_LINK}.lst)
    file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_${MKL_LINK}.lst ${domain}_${MKL_LINK}_funcList)
    list(APPEND tmp_funcList "${${domain}_${MKL_LINK}_funcList}")
  endif()
  if(WIN32 AND EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_win.lst)
    file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_win.lst ${domain}_win_funcList)
    list(APPEND tmp_funcList "${${domain}_win_funcList}")
  endif()
  if(UNIX AND EXISTS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_lnx.lst)
    file(STRINGS ${PROJECT_SOURCE_DIR}/${domain}/${domain}_lnx.lst ${domain}_lnx_funcList)
    list(APPEND tmp_funcList "${${domain}_lnx_funcList}")
  endif()
  # reduce list to just function names
  if(tmp_funcList)
    string(REPLACE  "\\" "" tmp_funcList "${tmp_funcList}")
    list(FILTER tmp_funcList EXCLUDE REGEX "=")
    list(TRANSFORM tmp_funcList STRIP)
    set(${funclist} ${tmp_funcList})
    set(${funclist} ${tmp_funcList} PARENT_SCOPE)
  endif()
endfunction()

# Custom list of examples
if (TARGET_FUNCTIONS)
  string(REPLACE " " ";" TARGET_FUNCTIONS "${TARGET_FUNCTIONS}")
  foreach(domain_func IN LISTS TARGET_FUNCTIONS)
    if(NOT domain_func MATCHES "/")
      message(FATAL_ERROR "All functions in TARGET_FUNCTIONS should be defined as domain/function")
    endif()
    string(REPLACE "/" ";" domain_func ${domain_func})
    list(GET domain_func 0 domain)
    list(GET domain_func 1 func)
    list(APPEND domainList "${domain}")
    # Build a list of possible functions that can be tested
    set(temp_funcList "")
    listfuncs(temp_funcList ${domain})
	# compare each function against the desired regex function to determine final list
    foreach(f IN LISTS temp_funcList)
      string(REGEX MATCH "^${func}" matchedfunc "${f}")
      if(matchedfunc)
        list(APPEND ${domain}_funcList "${matchedfunc}")
      endif()
    endforeach()
  endforeach()
else()
# Define default list of examples for selected domains
  # Select all domains in the directory if they are not defined by user
  if (TARGET_DOMAINS)
    string(REPLACE " " ";" TARGET_DOMAINS "${TARGET_DOMAINS}")
  endif()
  if(NOT TARGET_DOMAINS)
    file(GLOB TARGET_DOMAINS RELATIVE ${PROJECT_SOURCE_DIR} ${PROJECT_SOURCE_DIR}/*)
    list(REMOVE_ITEM TARGET_DOMAINS build)
    foreach(dir IN LISTS TARGET_DOMAINS)
      # If folder contains domain_name.lst it will be included to domainList
      file(GLOB ${dir}_LISTS ${PROJECT_SOURCE_DIR}/${dir}/${dir}*.lst)
      if(${dir}_LISTS STREQUAL "")
        list(REMOVE_ITEM TARGET_DOMAINS ${dir})
      endif()
    endforeach()
  endif()
  set(domainList ${TARGET_DOMAINS})
  foreach(DOMAIN IN LISTS TARGET_DOMAINS)
    listfuncs(${DOMAIN}_funcList ${DOMAIN})
  endforeach()
endif()

# Cleanup duplications
if(domainList)
  list(REMOVE_DUPLICATES domainList)
  foreach(d IN LISTS domainList)
    if(${d}_funcList)
      list(REMOVE_DUPLICATES ${d}_funcList)
    else()
      message(WARNING "No functions to run for ${d}. Please check input options.")
    endif()
  endforeach()
else()
  message(WARNING "No domains to run. Please check input options or examples/ directory.")
endif()
