"use strict";angular.module("collectionpane",["ui-session","loading","services","recursiveDirectiveCompiler","widgets","crashHandling","ng-semantic-ui","ngRoute"],["$routeProvider",e=>{e.when("/collection/:identity",{template:'<div class="collection-pane" ng-show="mode !== modes.log" ng-if="workflow"><branded-header localize="localize" default-msg-catalog="collectionapi" caption="::localize(\'%ConfigureNewAnalysisTooltip\')" ng-if="config && !workflow.readOnly"><a ng-if="workflow.readOnly === false" class="icon question-mark-and-map active-pane-tour" start-tour="configurationPane" data-tour-item="startTourItem"></a></branded-header><div class="tiles-area" size-classifier ng-class="{ readonly: workflow.readOnly }"><tile headline="WHERE" is-active="!workflow.readOnly" class="where"><connection-types></connection-types><connection-type></connection-type></tile><tile headline="WHAT" is-active="!workflow.readOnly" class="what"><target-types></target-types><target-type read-only="workflow.readOnly"></target-type></tile><tile headline="HOW" is-active="!workflow.readOnly" class="how"><div class="analysis-waiting" ng-hide="workflow.connectionEstablished && workflow.analysisTypeGroups.length || workflow.readOnly" ng-bind-html="workflow.connectionTypeDetails.waitDescription"></div><div ng-show="workflow.connectionEstablished && workflow.analysisTypeGroups.length || workflow.readOnly"><analysis-types></analysis-types><analysis-type read-only="workflow.readOnly"></analysis-type></div></tile><side-panel mode="mode" workflow="workflow"></side-panel></div><loading show-when="loading.isInProgress()" class="connection"></loading></div><div class="collection-pane" ng-show="mode === modes.log" ng-if="workflow"><div class="collection-log-container"><section><collection-log id="collectionLog"></collection-log><splitter is-vertical="true" ng-attr-primary-div="collectionLog" ng-attr-secondary-div="applicationOutput" size="70%" add-sash="true" ng-if="showApplicationOutput && mode === modes.log"></splitter><application-output id="applicationOutput" ng-if="showApplicationOutput"></application-output></section><side-panel mode="mode" workflow="workflow"></side-panel></div></div><div ng-if="identity && workflow.readOnly === false"></div><crash-handling-dialog identity="identity" position="absolute" on-close="closeCollectionConfiguration()"></crash-handling-dialog><collection-pane-test-harness-dump init-mode="initMode" type="mode"></collection-pane-test-harness-dump>',controller:"CollectionpaneController"}).when("/import/:identity",{template:"<import-pane></import-pane>"}).when("/compare/:identity",{template:"<compare-pane></compare-pane>"})}]);
"use strict";angular.module("collectionpane").controller("CollectionpaneController",["$scope","$location","$timeout","$http","$q","workflow","uiSession","collectionConstants","localize","paneApi","requestIdentity","productManager","productConstants","configurationTour","resultApi",function(o,t,n,i,e,c,s,a,l,r,d,g,f,u,p){let m,w;if(o.initMode===a.initModes.CONFIGURE_MODE){const t={projectPath:g.state.currentProjectPath,sessionId:s.id,...o.config.params};p.openResult(t).then((t=>(t&&t.data&&(o.identity=t.data.identity,d.set(o,o.identity),m=r.get(o.identity),o.config.actions&&o.config.actions.setIdentity&&o.config.actions.setIdentity(o.identity)),C(),s.getPartitionSocket(o)))).then(h)}else m=r.get(d.get(o)),C(),s.getPartitionSocket(o).then(h);function C(){u.register(),o.mode=o.mode||t.search().mode,o.modes=a.modes,o.workflow=c.get(d.get(o)),o.config&&o.config.params&&(o.workflow.defaultAnalysisId=o.config.params.defaultAnalysisId),o.workflow.initMode=o.initMode,o.loading=o.workflow.loading,w=o.$watch("mode",(function(){o.mode!==o.modes.log&&n((()=>{o.$broadcast("resizeGrids")}),0,!1)}))}function h(t){o.workflow.initialLoad(),t.on("OpenCollectionLogEvent",(()=>{o.mode=a.modes.log})),t.on("collection:started",(t=>{o.config.actions&&o.config.actions.onCollectionStarted&&o.config.actions.onCollectionStarted(),o.workflow.setReadOnly(!0),g.processCollectionStart({analysisName:t.analysisName,isPaused:t.isPaused},d.get(o))})),l(["%arbitraryTargets"],"collectionapi").then((t=>{o.messages=t})),m.checkIfApplicationOutputShouldBeShown().then((t=>{o.showApplicationOutput=t.show})),o.initMode===a.initModes.CONFIGURE_MODE&&u.autostart()}o.closeCollectionConfiguration=()=>o.config.actions&&o.config.actions.onClose?o.config.actions.onClose():e.resolve(),o.$on("collectionLog:action:close",(t=>{o.config.actions&&o.config.actions.onClose&&o.config.actions.onClose(),t.stopPropagation()})),o.$on("collectionLog:action:discard",(t=>{o.config.actions&&o.config.actions.onDiscard&&o.config.actions.onDiscard(),t.stopPropagation()})),o.$on("$destroy",(function(){w&&w(),r.remove(d.get(o)),c.remove(d.get(o)),delete o.workflow,o.initMode===a.initModes.CONFIGURE_MODE&&u.unregister()})),o.$on("collectionLog:action:cancel",(t=>{o.config.actions&&o.config.actions.onClose&&o.config.actions.onClose(),t.stopPropagation()}))}]);
"use strict";angular.module("collectionpane").directive("collectionPane",(function(){return{restrict:"E",scope:{initMode:"<",mode:"=",config:"<"},template:'<div class="collection-pane" ng-show="mode !== modes.log" ng-if="workflow"><branded-header localize="localize" default-msg-catalog="collectionapi" caption="::localize(\'%ConfigureNewAnalysisTooltip\')" ng-if="config && !workflow.readOnly"><a ng-if="workflow.readOnly === false" class="icon question-mark-and-map active-pane-tour" start-tour="configurationPane" data-tour-item="startTourItem"></a></branded-header><div class="tiles-area" size-classifier ng-class="{ readonly: workflow.readOnly }"><tile headline="WHERE" is-active="!workflow.readOnly" class="where"><connection-types></connection-types><connection-type></connection-type></tile><tile headline="WHAT" is-active="!workflow.readOnly" class="what"><target-types></target-types><target-type read-only="workflow.readOnly"></target-type></tile><tile headline="HOW" is-active="!workflow.readOnly" class="how"><div class="analysis-waiting" ng-hide="workflow.connectionEstablished && workflow.analysisTypeGroups.length || workflow.readOnly" ng-bind-html="workflow.connectionTypeDetails.waitDescription"></div><div ng-show="workflow.connectionEstablished && workflow.analysisTypeGroups.length || workflow.readOnly"><analysis-types></analysis-types><analysis-type read-only="workflow.readOnly"></analysis-type></div></tile><side-panel mode="mode" workflow="workflow"></side-panel></div><loading show-when="loading.isInProgress()" class="connection"></loading></div><div class="collection-pane" ng-show="mode === modes.log" ng-if="workflow"><div class="collection-log-container"><section><collection-log id="collectionLog"></collection-log><splitter is-vertical="true" ng-attr-primary-div="collectionLog" ng-attr-secondary-div="applicationOutput" size="70%" add-sash="true" ng-if="showApplicationOutput && mode === modes.log"></splitter><application-output id="applicationOutput" ng-if="showApplicationOutput"></application-output></section><side-panel mode="mode" workflow="workflow"></side-panel></div></div><div ng-if="identity && workflow.readOnly === false"></div><crash-handling-dialog identity="identity" position="absolute" on-close="closeCollectionConfiguration()"></crash-handling-dialog><collection-pane-test-harness-dump init-mode="initMode" type="mode"></collection-pane-test-harness-dump>',controller:"CollectionpaneController"}}));
"use strict";angular.module("collectionpane").controller("ApplicationOutputController",["$scope","$http","uiSession","paneApi","localize","requestIdentity",function(e,t,a,s,n,i){const o=s.get(i.get(e));let l=0;const u=1e4;function p(t){t&&t.message&&t.message.length&&(t.outputTruncated&&(t.message=t.message+"\n"+e.localizedMessages["%applicationOutput.truncatedMessage"]+"\n"),function(t){e.message=e.message?e.message+t:t,e.message.length>u&&(e.message=e.message.slice(-1e4));e.onOutputUpdated()}(t.message)),t.lastIndex&&(l=t.lastIndex)}function c(e,t){return o.getApplicationOutputDelta(e,t).then(p)}a.getPartitionSocket(e).then((t=>{n(["%applicationOutput.header","%applicationOutput.truncatedMessage"],"collectionapi").then((t=>{e.localizedMessages=t})),t.on("applicationOutput:updated",(()=>c(l,1e3))),t.on("result:finalization:started",(()=>{e.message="",c(0,0)})),c(0,0)}))}]);
"use strict";angular.module("collectionpane").directive("applicationOutput",(function(){return{scope:{},template:'<div class="application-output"><div class="application-output-header">{{localizedMessages[\'%applicationOutput.header\']}}</div><div class="application-output-message">{{message}}</div><scroller to-bottom="onOutputUpdated" element-selector=".application-output-message"></scroller></div>',controller:"ApplicationOutputController"}}));
"use strict";angular.module("collectionpane").service("AgentConnection",["$http","$location","$rootScope","collectionConstants","error","localize","uiSession","findKnob",function(e,t,s,n,i,r,a,o){const{AGENT_CONNECTION:h,LOCALHOST_CONNECTION:c}=n.connectionTypeIds,d="Connected";const g="unknown",l="probingTarget",_="targetConnected",p="sshDeploymentAvailable",u="manualDeploymentNeeded";class T{constructor({agentUuid:e,hostnames:t=[],ipAddresses:s=[],fingerprint:n,connected:i,isAdmitted:r}={}){this._agentUuid=e,this._fingerprint=n,this._hostnames=t,this._ipAddresses=s,this._fingerprint=n,this._targetState=i?_:g,this._isAdmitted=r}get id(){return this._agentUuid}get agentUuid(){return this._agentUuid}get isAdmitted(){return this._isAdmitted}get fingerprint(){return this._fingerprint}get hostname(){return this._hostnames[0]}get ipAddress(){return this._ipAddresses[0]}get selectable(){return!0}async select(e,t=!1){const s=this._getConnectionType(e);s&&(this._decorateConnectionType(s),t||await this._onConnectionTypeSelected(e,s),await this._refreshTargetState(e))}get connected(){return this._targetState===_}get targetState(){return this._targetState}async _refreshTargetState(t){if(this._targetState=g,await T._saveConnectionKnob(t,"uuid",this.agentUuid,!1),await T._saveConnectionKnob(t,"hostname",this.ipAddress||this.hostname,!1),(s=this.hostname||this.ipAddress)&&RegExp("(^\\d+.\\d+.\\d+.(?!0)\\d+$|^(?!(\\d|\\s|$)))").test(s)){this._targetState=l,A();try{const s=await e.get("api/collection-agent/target/status",{params:{hostname:this.ipAddress||this.hostname}}).then(i.validateResponse);if(s.hostname!==this.hostname&&s.hostname!==this.ipAddress)return;s.agentUuid?(this._targetState=_,this._agentUuid=s.agentUuid,this._fingerprint=s.fingerprint,this._isAdmitted=s.isAdmitted,await T._saveConnectionKnob(t,"uuid",this.agentUuid,!0)):s.sshCapable?this._targetState=p:this._targetState=u}catch(e){this._targetState=u}}var s;t.reloadAnalysisType(),A()}_getConnectionType(e){return e.connectionTypes.find((e=>e.id===h))}_decorateConnectionType(e){e.name=this.hostname||this.ipAddress}async _onConnectionTypeSelected(e,t){await e.onConnectionTypeSelected(t,!1)}static async _saveConnectionKnob(e,t,s,n=!0){const[i]=e.connectionTypeDetails.knobs,r=o(i,t);if(r)return r.value=s,e.saveConnectionKnob(r,n)}}class m extends T{constructor(){super(),e.get("api/collection-agent/identify").then(i.validateResponse).then((e=>{this._hostnames=e.hostnames||[""],this._ipAddresses=[e.ipAddress||""]}))}}class f extends T{constructor({onTargetSet:e=()=>{}}){super(),this._onTargetSet=e,r("%agentConnection.newTarget","collectionpane").then((e=>{this._name=e}))}get id(){return"add_new_agent"}get name(){return this._name}async update(e,t){super._hostnames=[e],super._ipAddresses=[e],this._onTargetSet(),await this._refreshTargetState(t),A()}reset(){super._hostnames=[],super._ipAddresses=[]}_decorateConnectionType(e){e.name=this.name}}class y extends T{constructor(){super({hostnames:[t.host()]})}async _init(e){this._connectionType=e.connectionTypes.find((e=>e.id===c)),this._name=await r("%agentConnection.server","collectionpane")}get name(){return this._name}_decorateConnectionType(e){e.name=`${this.name} (${this.hostname||this.ipAddress})`}get selectable(){return!!this._connectionType}_getConnectionType(){return this._connectionType}async _onConnectionTypeSelected(e,t){await e.onConnectionTypeSelected(t,!0)}async _refreshTargetState(){}}function A(){s.$digest()}return class{constructor(){this._client=new m,this._newTarget=new f({onTargetSet:()=>this._refreshSelection()}),this._remoteTargets=[],this._server=new y,this._refreshTargets(),a.getPartitionSocket(s).then((e=>{e.on("agent-list:changed",(()=>this._refreshTargets()))}))}async init(e){this._workflow=e,await this.server._init(e),e.connectionType&&e.connectionType.id===c&&this.select(this.server,!0),A()}get client(){return this._client}get newTarget(){return this._newTarget}get remoteTargets(){return this._remoteTargets}get server(){return this._server}get selectedTarget(){return this._target}isSelected(e){return e===this.selectedTarget}async select(e,t=!1){this._target!==e&&(e?e.selectable&&(this._target=e,await this._target.select(this._workflow,t)):this._target=void 0)}async setInitialSelection(e){if(!this.selectedTarget)if(e&&this.client.hostname!==e&&this.client.ipAddress!==e){await this._refreshTargets();for(const t of this.remoteTargets)if(t.hostname===e||t.ipAddress===e)return void this.select(t);this.select(this.client),A()}else this.select(this.client)}onConnectionTypeSelected(e){e.id!==h&&e.id!==c&&this.select(null)}async _refreshTargets(){const t=await e.get("api/collection-agent/list").then(i.validateResponse);this._remoteTargets=[];const s=t.agents.filter((e=>"otherUser"!==e.ownerType));s.filter((e=>e.status===d)).forEach((e=>this._addRemoteTarget(e))),s.filter((e=>e.status!==d)).forEach((e=>this._addRemoteTarget(e)));let n=!0;if(this.selectedTarget){let[e]=s.filter((e=>e.uuid===this.selectedTarget.agentUuid));e&&(e=new T({connected:e.status===d}),e.targetState===this.selectedTarget.targetState&&(n=!1))}n&&await this._refreshSelection(),A()}async _refreshSelection(){if(this.selectedTarget!==this.server&&this.selectedTarget){this.selectedTarget===this.client&&(this._target=void 0,await this.select(this.client));for(const e of this.remoteTargets)if(this.selectedTarget.hostname&&this.selectedTarget.hostname.toLowerCase()===e.hostname.toLowerCase()||this.selectedTarget.ipAddress&&this.selectedTarget.ipAddress===e.ipAddress){this.selectedTarget===this.newTarget&&this.newTarget.reset(),await this.select(e);break}}}_addRemoteTarget(e){if(e.ipAddress===this._client.ipAddress)return;this._remoteTargets.find((t=>t.ipAddress===e.ipAddress))||this._remoteTargets.push(new T({agentUuid:e.uuid,hostnames:e.hostname,ipAddresses:[e.ipAddress],fingerprint:e.fingerprint,connected:e.status===d,isAdmitted:e.isAdmitted}))}}}]);
"use strict";angular.module("collectionpane").factory("paneApi",["$http","error","productConstants",function(e,t,i){const n=new Map;return{get:o=>(n.has(o)||n.set(o,function(n){const o=n;return{getMode:()=>a("api/collection/configuration/mode"),getCollectionLogDelta:e=>a("api/collection/log/delta",{clientId:e}),getConnectionTypes:()=>a("api/collection/connection"),getConnectionType:e=>a("api/collection/connectionType",{connectionType:e.id}),clearCollectionLog:()=>l("api/collection/log/clear",{}),executeLogAction:e=>l("/api/collection/log/action",{type:e}),initConnectionType:()=>l("api/collection/configuration/connection/init"),saveConnectionTypeKnob:(e,t)=>c("api/collection/connectionType",{knob:e,connectionType:t}),prepareConnection:(e=!1)=>l("api/collection/configuration/connection/prepare",{force:e}),establishConnection:()=>l("api/collection/configuration/connection/establish"),sshDeploy:()=>l("api/collection/configuration/connection/ssh/deploy"),validate:()=>l("api/collection/configuration/validate",{},{}),getTargetTypes:()=>a("api/collection/target"),getTargetType:e=>a("api/collection/targetType",{targetType:e.id}),saveTargetTypeKnob:(e,t,i)=>c("api/collection/targetType",{panelId:e.id,knob:t},{targetType:i.id}),getAnalysisTypes:()=>a("api/collection/analysis"),getAnalysisType:e=>a("api/collection/analysisType",{analysisType:e.id}),saveAnalysisTypeKnobs:(e,t)=>c("api/collection/analysisType",{knobs:t},{analysisType:e.id}),saveAnalysisTypeKnob:(e,t)=>c("api/collection/configuration/analysisType",{knob:{id:t.id,type:t.type,value:t.value}},{analysisType:e.id}),saveCustomAnalysisTypeMetadata:e=>c("api/collection/configuration/analysisType/description",{name:e.analysisTypeName,commandLineName:e.commandLineName,abbreviation:e.abbreviation,description:e.analysisTypeDescription},{analysisType:e.id}),copyAnalysisType:e=>l("api/collection/configuration/analysisType/copy",{analysisType:e.id}),deleteAnalysisType:e=>l("api/collection/configuration/analysisType/delete",{analysisType:e.id}),getCollectionState:e=>a("api/collection/state",{lastReportedState:e}),startCollection:()=>l("api/collection/start"),startCollectionPaused:()=>l("api/collection/start-paused"),pauseCollection:()=>l("api/collection/pause"),resumeCollection:()=>l("api/collection/resume"),cancelCollection:()=>l("api/collection/cancel"),stopCollection:()=>l("api/collection/stop"),markTimeline:()=>l("api/collection/mark-timeline"),showCommandLine:()=>l("api/collection/command-line/show"),checkIfFeatureIsEnabled:e=>a("api/features/state",{feature:e}),refinalize:(e=!0)=>l("api/result/refinalize",{force:e}),getResultState:()=>a("api/result/info"),getApplicationOutputDelta:(e,t)=>a("api/collection/application-output",{lastIndex:e,threshold:t}),checkIfApplicationOutputShouldBeShown:()=>a("api/collection/application-output/state"),getFeatureState:e=>a("api/features/state",{feature:e,identity:i.commonIdentity})};function a(i,n={}){return n.identity=n.identity||o,e.get(i,{params:n}).then(t.validateResponse)}function l(i,n,a){return n=n||{},(a=a||{}).identity=o,e.post(i,n,{params:a}).then(t.validateResponse)}function c(i,n,a){return n=n||{},(a=a||{}).identity=o,e.put(i,n,{params:a}).then(t.validateResponse)}}(o)),n.get(o)),remove(e){n.delete(e)}}}]);
"use strict";angular.module("collectionpane").service("collectionConstants",(function(){return{panels:{1:"AppToLaunch",2:"AttachToProcess",3:"ExperementDuration",4:"ResultDirectory",5:"EnvironmentVariable",6:"Directories",7:"InheritableKnobs",8:"NonInheritableKnobs",9:"ExperimentDurationWithResumeAuto",10:"AndroidRun",11:"AttachToProcessRemote",12:"ConnectionTypeKnob",13:"CategoryKnobs",14:"MpiRun"},modes:{connection:"connection",analysis:"analysis",log:"log"},validationStates:{unknown:"Unknown",invalidated:"Invalidated",invalid:"Invalid",valid:"Valid"},collectionStates:{unknown:"Unknown",notStarted:"NotStarted",starting:"Starting",running:"Running",paused:"Paused",stopping:"Stopping",detached:"Detached",complete:"Complete",frontend:{pausing:"Pausing",resuming:"Resuming",cancelling:"Cancelling"}},severity:{error:"error",warning:"warning",info:"info",verbose:"verbose"},collectionLogIcon:{error:"cross-circle",warning:"alert-triangle",info:"information-circle",done:"check-circle",progress:"circle-third spin"},errorTypes:{connection:"connectionType",targetSession:"targetSession",workload:"workload",analysis:"analysis",customAnalysisMetadata:"customAnalysisMetadata"},nullResultState:{resultsCount:0,hasParentProject:!1,areAllResultsValid:!1,isFinalizationInProgress:!0},initModes:{CONFIGURE_MODE:"configure",VIEWING_MODE:"viewing"},helpKeywords:{COLLECTION:"intel.phe.configs.configure_analysis",COMPARE:".client.compare_results_f1075",IMPORT:"intel.phe.client.import_f1078"},connectionTypeIds:{LOCALHOST_CONNECTION:"%LocalhostConnection",SSH_CONNECTION:"%SshConnection",TCPIP_CONNECTION:"%TcpIpConnection",ADB_CONNECTION:"%AdbConnection",GET_COMMANDLINE_LOCALHOST:"get-commandline-localhost",AGENT_CONNECTION:"%AgentConnection"},targetTypeIds:{PROCESS_TARGET:"attach",SYSTEM_TARGET:"system",APPLICATION_TARGET:"launch",ANDROID_TARGET:"android-run"}}}));
"use strict";angular.module("collectionpane").factory("compareConstants",(function(){return{types:{RESULT1:"result1",RESULT2:"result2"}}}));
"use strict";angular.module("collectionpane").factory("configurationTour",["helpTour",function(e){const t=[{id:"whereHeaderTourItem",description:"%HelpTour.whereHeader"},{id:"whatHeaderTourItem",description:"%HelpTour.whatHeader"},{id:"howHeaderTourItem",description:"%HelpTour.howHeader",checkOverlapDepth:5},{id:"copyButtonTourItem",description:"%HelpTour.copyButton",checkOverlapDepth:5},{id:"runButtonTourItem",description:"%HelpTour.runButton"},{id:"startPausedButtonTourItem",description:"%HelpTour.startPausedButton"},{id:"searchDirectoriesButtonTourItem",description:"%HelpTour.searchDirectoriesButton"},{id:"copyCommandlineButtonTourItem",description:"%HelpTour.copyCommandlineButton",checkOverlapDepth:5},{id:"startTourItem",description:"%HelpTour.start"}],r="configurationPane";return{register(){e.register(r,t)},unregister(){e.unregister(r)},autostart(){e.autostart(r)}}}]);
"use strict";angular.module("collectionpane").service("deviceTargetUtil",(function(){return{consts:{groupDelimiter:",",valueDelimiter:"|",tileDelimiter:":",GPU:"GPU",NPU:"NPU",XPU_MODE:"XPU",GPU_ADAPTERS_KNOB_ID:"gpuAdapterTileNames",NPU_ADAPTERS_KNOB_ID:"npuAdapterTileNames"},unpackKnobValueToMap:e=>e.split(",").reduce(((e,t)=>{const l=t.match(/^(\d+:\d+:\d+\.\d+)(:(\d+))*/);if(null===l||l.length<3)return e;const i=l.at(1);let r;return 4===l.length&&(r=l.at(3)),void 0!==r?void 0!==e.get(i)?e.get(i).tiles.push(r):e.set(i,{tiles:[r]}):e.set(i,{tiles:[]}),e}),new Map),unpackXpuTileAllValuesStr:e=>e.split(",").reduce(((e,t)=>{const[l,i,r]=t.split("|");return void 0!==e.get(l)?e.get(l).tiles.push(r):e.set(l,{name:i,tiles:[r]}),e}),new Map),createXpuCollectForAdapterAuxKnob:(e,t,l,i)=>{const r="XPU"===i,u=r?"xpuCollectForAdapter":"gpuCollectForAdapter",o=r?"xpuCollectForAdapterTile":"gpuCollectForAdapterTile",a=r?"xpuCollectForAdapter_tile":"gpuCollectForAdapter_tile",p={},d=r?"xpuId":"gpuId",n=void 0!==e.get(t),s=void 0===l||0===e.get(t).tiles.length||e.get(t).tiles.includes(l);return p.id=void 0===l?u+t:a+t+"_"+l,p[d]=t,p.name=void 0===l?u:o+l,p.value=n&&s,p.defaultValue=!0,p.disabled=!1,p}}}));
"use strict";angular.module("collectionpane").service("findKnob",(function(){return function(n,e){if(n&&n.knobs&&n.knobs.length)return n.knobs.find((n=>n.id===e))}}));
"use strict";angular.module("collectionpane").service("iconClassname",["collectionConstants",function(o){const n={[o.connectionTypeIds.LOCALHOST_CONNECTION]:"laptop solid",[o.connectionTypeIds.SSH_CONNECTION]:"laptops",[o.connectionTypeIds.TCPIP_CONNECTION]:"laptops",[o.connectionTypeIds.ADB_CONNECTION]:"connection-laptop-to-tablet",[o.connectionTypeIds.GET_COMMANDLINE_LOCALHOST]:"connection-laptop-custom",[o.connectionTypeIds.AGENT_CONNECTION]:"blade-server solid",[o.targetTypeIds.PROCESS_TARGET]:"gear solid",[o.targetTypeIds.SYSTEM_TARGET]:"gears solid",[o.targetTypeIds.APPLICATION_TARGET]:"application-window solid",[o.targetTypeIds.ANDROID_TARGET]:"application-android solid"};return{get:(o,e="gear")=>n[o]||e}}]);
"use strict";angular.module("collectionpane").factory("workflow",["AgentConnection","paneApi","error","collectionConstants","productMode","Tracker","statistics",function(e,n,t,a,s,i,o){const r=new Map;function y(r){const y=n.get(r),l=new i;l.start();const c={readOnly:!0,validationState:a.validationStates.unknown,connectionTypes:[],connectionType:void 0,agentConnection:s.isBrowserMode()?new e:void 0,connectionTypeDetails:void 0,connectionEstablished:!1,targetTypes:[],targetType:void 0,targetTypeDetails:void 0,analysisTypeGroups:[],analysisType:void 0,analysisTypeDetails:void 0,analysisTypeEditMode:!1,defaultAnalysisId:void 0,errors:[],initMode:a.initModes.VIEWING_MODE,initialLoad:function(){return y.getMode().then((e=>{c.readOnly=e.readOnly})).then(u).then(f).then(C).then(w).then(D).then(E).catch(t.handle).finally(l.stop)},saveConnectionKnob:function(e,n=!0){if(!c.connectionType)return;let a=l.start().then((()=>y.saveConnectionTypeKnob(e,c.connectionType.id)));!0===n&&(a=a.then((()=>w(!1))));return a.then(D).then(E).catch(t.handle).finally(l.stop)},onConnectionTypeSelected:function(e,n=!0){c.connectionType=e,c.agentConnection&&c.agentConnection.onConnectionTypeSelected(e);let a=l.start().then((()=>f())).then(C);!0===n?a=a.then((()=>w(!1))):c.connectionEstablished=!1;return a.then(D).then(E).catch(t.handle).finally(l.stop)},onTargetTypeSelected:p,saveTargetTypeKnob:function(e,n){if(!c.targetType)return;return l.start().then((()=>y.saveTargetTypeKnob(e,n,c.targetType))).then(E).catch(t.handle).finally(l.stop)},onAnalysisTypeSelected:d,saveAnalysisTypeKnobsAndReload:function(){if(!c.analysisType)return;if(!c.analysisTypeDetails)return;return l.start().then((()=>y.saveAnalysisTypeKnobs(c.analysisType,c.analysisTypeDetails.knobs))).then(h).catch(t.handle).finally(l.stop)},reloadAnalysisType:h,reloadAnalysisTarget:function(){return p(c.targetType)},saveAnalysisTypeKnob:function(e){return l.start().then((()=>y.saveAnalysisTypeKnob(c.analysisType,e))).then(E).catch(t.handle).finally(l.stop)},saveCustomAnalysisTypeMetadata:function(){if(c.analysisTypeDetails&&c.analysisTypeDetails.custom)return y.saveCustomAnalysisTypeMetadata(c.analysisTypeDetails).then(S).then((e=>{const n=e.errors&&e.errors.some((e=>e.type===a.errorTypes.customAnalysisMetadata));n?c.analysisTypeEditMode=!0:D()})).catch(t.handle)},copyCurrentAnalysisType:function(){return l.start().then((()=>y.copyAnalysisType(c.analysisType))).then(D).then(E).catch(t.handle).finally(l.stop)},setReadOnly:function(e){void 0===e&&(e=!0);c.readOnly=e},deleteCurrentAnalysisType:function(){if(c.analysisTypeEditMode=!1,!c.analysisTypeDetails||!c.analysisTypeDetails.custom)return;return l.start().then((()=>y.deleteAnalysisType(c.analysisType))).then(D).then(E).catch(t.handle).finally(l.stop)},reconnect:function(){return l.start().then((()=>w(!0))).then(D).then(E).catch(t.handle).finally(l.stop)},loading:l};return c;function p(e){return l.start().then((()=>A(e))).then(E).catch(t.handle).finally(l.stop)}function d(e,n=!0){return n&&(e.id.startsWith("%")?o.notifyFeatureUsage("select."+e.id):o.notifyFeatureUsage("select.Custom")),c.analysisType=e,c.analysisTypeEditMode=!1,l.start().then((()=>M(e,n))).then(E).catch(t.handle).finally(l.stop)}function u(){let e;return y.getConnectionTypes().then((n=>(e=n.selection,n.groups.flatMap((e=>e.types))))).then(T).then((e=>{c.connectionTypes=e})).then((()=>function(e){c.connectionType=c.connectionTypes.find((n=>n.id===e))||c.connectionTypes[0]}(e))).then((()=>{c.agentConnection&&c.agentConnection.init(c)}))}async function T(e){return e.filter(await async function(){if(s.isBrowserMode()){if(await async function(){return(await y.getFeatureState("server-profiling")).enabled}()||c.readOnly)return()=>!0;{const e=["%AgentConnection"];return n=>e.includes(n.id)}}{const e=["%AgentConnection"];return n=>!e.includes(n.id)}}())}function h(){return d(c.analysisType,!1)}function f(){return y.getConnectionType(c.connectionType).then(g).then(v).then(S)}function g(e){return e.isLongInitRequired&&!e.hasErrors?y.initConnectionType():e}function v(e){return c.connectionTypeDetails=e,e}function C(){let e;return y.getTargetTypes().then((n=>{c.targetTypes=n.types||[],e=n.selection})).then((()=>function(e){c.selectedTargetType=void 0;for(const n of c.targetTypes)if(n.id===e)return void(c.selectedTargetType=n);c.selectedTargetType=c.targetTypes[0]}(e))).then((()=>{if(c.selectedTargetType)return A(c.selectedTargetType)}))}function A(e){return c.targetType=e,y.getTargetType(e).then(b)}function b(e){c.targetTypeDetails=e}function D(){if(c.connectionEstablished){let e;return y.getAnalysisTypes().then((n=>{c.analysisTypeGroups=n.groups||[],e=n.selection})).then((()=>function(e){if(c.analysisType=n(e),void 0!==c.analysisType)return;if(c.defaultAnalysisId&&(c.analysisType=n(c.defaultAnalysisId),void 0!==c.analysisType))return;c.readOnly?c.analysisType={id:e}:c.analysisTypeGroups.length&&(c.analysisType=c.analysisTypeGroups[0].types[0]);function n(e){for(const n of c.analysisTypeGroups)for(const t of n.types||[])if(t.id===e)return t}}(e))).then((()=>{if(c.analysisType)return M(c.analysisType)}))}c.analysisTypeGroups=[],c.analysisType=void 0}function M(e,n=!0){if(e)return y.getAnalysisType(e).then((t=>{c.analysisType=e,n?c.analysisTypeDetails=t:c.analysisTypeDetails.lowLevelKnobs=t.lowLevelKnobs}));c.analysisTypeDetails=void 0}function w(e=!1){return y.prepareConnection(e).then(S).then((e=>(c.connectionEstablished=e.isConnected&&!e.isReconnectNeeded,e.isReconnectNeeded?y.establishConnection().then((e=>(c.connectionEstablished=e.isConnected,e))):e))).then(S)}function E(){if(!c.readOnly)return c.validationState=a.validationStates.invalidated,y.validate().then(S)}function S(e){return e.errors&&(c.validationState=e.errors.some((e=>e.severity===a.severity.error))?a.validationStates.invalid:a.validationStates.valid),c.errors=e.errors,e}}return{get:e=>(r.has(e)||r.set(e,y(e)),r.get(e)),remove(e){r.delete(e)}}}]);
"use strict";angular.module("collectionpane").controller("ComparePaneController",["$scope","$q","$http","uiSession","localize","compareConstants","requestIdentity","productManager","productConstants","productMode","fileDialog",function(e,t,r,s,a,o,n,l,u,i,c){const p=u.commonIdentity;n.set(e,p),e.types=o.types,e.isInProgress=!1,e.isBrowserMode=i.isBrowserMode(),e.config&&e.config.actions&&(e.config.actions.onOpen=R);let d,f=!1;function m(t){if(e.results)return e.results.some((e=>e.name===t))?t:void 0}function h(t){if(!e.results)return;const r=e.results.find((e=>e.path===t));return r?r.name:void 0}function g(t){return t===e.types.RESULT1?y(e.result1Value)||e.result1Value:y(e.result2Value)||e.result2Value}function y(t){if(!e.results)return;const r=e.results.find((e=>e.name===t));return r?r.path:void 0}function P(){return{params:{identity:p}}}function R(){e.config&&e.config.result1Path&&E(e.config.result1Path,e.types.RESULT1)}function E(t,r){r===e.types.RESULT1?e.result1Value=h(t)||t:e.result2Value=h(t)||t}function S(){return r.post("api/compare/validate/",{result1Path:g(e.types.RESULT1),result2Path:g(e.types.RESULT2)},P()).then((t=>(e.result1Error=f||e.result1Value?t.data.result1Error:"",e.result2Error=f||e.result2Value?t.data.result2Error:"",e.commonError=t.data.commonError,t.data.isValid)))}s.getPartitionSocket(e).then((()=>{r.post("api/compare/get-file-filter",{},P()).then((e=>{e&&e.data&&e.data.fileFilter&&(d=e.data.fileFilter)}));const s=l.state.currentProjectPath;if(s)return t.all([r.get("api/project/directory",{projectPath:s},P()).then((t=>{t&&t.data&&(e.defaultDirectory=t.data.directory)})),r.post("api/project/results",{projectPath:s},P()).then((t=>{t&&t.data&&(e.results=t.data.results)}))]).then(R)})),e.compare=()=>(e.isInProgress=!0,f=!0,S().then((t=>{if(t)return e.config.actions&&e.config.actions.onCompareStarted&&e.config.actions.onCompareStarted(),l.compareResults({result1Path:g(e.types.RESULT1),result2Path:g(e.types.RESULT2)});e.isInProgress=!1}))),e.onBrowse=t=>{(function(t){return function(t){return a(["%comparePane.selectResult1","%comparePane.selectResult2"],"collectionapi").then((r=>{const s={dialogType:"open",dialogTitle:t===e.types.RESULT1?r["%comparePane.selectResult1"]:r["%comparePane.selectResult2"],fileFilter:d},a=g(t);return a&&a.length?s.defaultFileName=a:s.defaultPath=e.defaultDirectory,s}))}(t).then((e=>c.showOpenDialog(e)))})(t).then((e=>(function(e,t){e&&E(e,t)}(e,t),S())))},e.onProjectResultSelected=t=>(t===e.types.RESULT1&&(e.result1Value=e.result1Name),t===e.types.RESULT2&&(e.result2Value=e.result2Name),S()),e.onResultPathChange=t=>(t===e.types.RESULT1&&(e.result1Name=m(e.result1Value)),t===e.types.RESULT2&&(e.result2Name=m(e.result2Value)),S()),e.swapResults=()=>([e.result1Value,e.result2Value]=[e.result2Value,e.result1Value],S())}]);
"use strict";angular.module("collectionpane").directive("comparePane",(function(){return{restrict:"E",scope:{config:"<"},template:'<div class="compare-pane" localize="localize" default-msg-catalog="collectionapi"><branded-header caption="::localize(\'%comparePane.title\')"></branded-header><div class="compare-configuration"><div class="ui stackable grid container main-area"><div class="row result-layer"><div class="result1-section seven wide column"><label class="title">{{::localize(\'%comparePane.result1\')}}</label><div class="ui field location"><div class="ui action input fluid"><input type="text" ng-model="result1Value" ng-change="onResultPathChange(types.RESULT1)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 250, \'blur\': 0 } }" tooltip="{{result1Value}}" tooltip-escape-html="true"><div class="ui icon left scrolling dropdown button" ng-change="onProjectResultSelected(types.RESULT1)" ng-model="result1Name"><i class="ui dropdown icon"></i><div class="left menu"><div class="item" ng-repeat="result in ::results" ng-attr-data-value="{{::result.name}}">{{::result.name}}</div></div></div><button class="ui icon button" ng-click="onBrowse(types.RESULT1)" ng-if="::!isBrowserMode"><i class="icon folder"></i></button></div></div><errors ng-if="result1Error" errors="[{\'severity\': \'error\', \'description\': result1Error}]"></errors></div><div class="center aligned two wide column"><button class="ui icon button swapButton" ng-click="swapResults()" tooltip="{{::localize(\'%comparePane.swapResults\')}}"><i class="icon arrows-left-right"></i></button></div><div class="result2-section seven wide column"><label class="title">{{::localize(\'%comparePane.result2\')}}</label><div class="ui field location"><div class="ui action input fluid"><input type="text" ng-model="result2Value" ng-change="onResultPathChange(types.RESULT2)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 250, \'blur\': 0 } }" tooltip="{{result2Value}}" tooltip-escape-html="true"><div class="ui icon left scrolling dropdown button" ng-change="onProjectResultSelected(types.RESULT2)" ng-model="result2Name"><i class="ui dropdown icon"></i><div class="left menu"><div class="item" ng-repeat="result in ::results" ng-attr-data-value="{{::result.name}}">{{::result.name}}</div></div></div><button class="ui icon button" ng-click="onBrowse(types.RESULT2)" ng-if="::!isBrowserMode"><i class="icon folder"></i></button></div></div><errors ng-if="result2Error" errors="[{\'severity\': \'error\', \'description\': result2Error}]"></errors></div></div><div class="centered row"><button ng-click="compare()" class="ui button primary huge compareButton" ng-disabled="isInProgress"><i class="icon circle-halved"></i>{{::localize(\'%sidePanel.compare\')}}</button></div><div class="centered row"><errors ng-if="commonError" errors="[{\'severity\': \'error\', \'description\': commonError}]"></errors></div></div></div></div><compare-pane-test-harness-dump></compare-pane-test-harness-dump>',controller:"ComparePaneController"}}));
"use strict";angular.module("collectionpane").controller("CollectionLogController",["$scope","uiSession","paneApi","collectionConstants","localize","stateMachine","requestIdentity",function(e,t,o,n,s,g,i){const l=o.get(i.get(e)),c=`log${Date.now()}`;function a(){return l.getCollectionLogDelta(c).then(r)}function r(t){t&&t.logStages&&t.logStages.length>0&&(e.logStages&&e.logStages.length?t.logStages.forEach((t=>{const o=e.logStages[e.logStages.length-1],n=o.id===t.id?o:e.logStages.find((e=>e.id===t.id));n?(t.messages=[...n.messages,...t.messages],Object.assign(n,t)):e.logStages.push(t)})):e.logStages=t.logStages,e.emptyLog=!1,e.onLogUpdated())}e.stateMachine=g.get(i.get(e)),t.getPartitionSocket(e).then((t=>{s(["%clearlog.delete.tooltip","%clearlog.delete.confirmation.caption","%clearlog.delete.confirmation.button"],"collectionapi").then((t=>{e.messages=t})),t.on("log:updated",a),a()})),e.excludeInfoMessages=e=>e.messages.filter((e=>e.severity!==n.severity.info)),e.getLastInfoMessage=e=>e.messages.filter((e=>e.severity===n.severity.info)).reverse()[0],e.isInProgress=e=>e.progress&&e.progress>0&&e.progress<100,e.getLogStageDescriptionMsg=function(e,t){const o=new Date(e);return`${`<i>${o.toDateString().substring(4)} ${o.toTimeString().substr(0,8)}</i>`} ${t}`},e.getLogStageIcon=function(t){const o=t.status||"none";return"progress"===o&&e.stateMachine.collectionInProgress()?"playing":n.collectionLogIcon[o]},e.execute=function(t){return e.$emit(`collectionLog:action:${t.type}`),l.executeLogAction(t.type)},e.clear=function(){return l.clearCollectionLog().then((()=>{e.logStages=void 0,e.emptyLog=!0}))},e.getMessageIcon=e=>e===n.severity.verbose?n.collectionLogIcon[n.severity.info]:n.collectionLogIcon[e]}]);
"use strict";angular.module("collectionpane").directive("collectionLog",(function(){return{scope:{logOpened:"="},template:'<div class="collection-log"><div class="header-with-buttons"><confirmation-button ng-show="!emptyLog" on-confirm="clear()" icon="trash" confirmation="messages[\'%clearlog.delete.confirmation.caption\']" confirmation-tooltip="messages[\'%clearlog.delete.tooltip\']" class="confirmation-button" disabled="stateMachine.isClearLogDisabled()"></confirmation-button></div><div class="log-stages-container" scroll-position-maintainer><div ng-repeat="logStage in logStages track by logStage.id"><div class="log-stage"><div class="log-stage-icon icon" ng-class="getLogStageIcon(logStage)"></div><div class="log-stage-body"><p class="log-stage-caption">{{logStage.caption}}</p><div class="log-stage-description"><p class="log-stage-description-msg" ng-bind-html="getLogStageDescriptionMsg(logStage.timeStamp, logStage.description)"></p></div><div ng-repeat="message in excludeInfoMessages(logStage) track by $index" class="log-stage-item"><i class="icon" ng-class="getMessageIcon(message.severity)"></i> <span class="log-stage-message" html-content="{{message.text}}"></span></div><div class="log-stage-item" ng-show="isInProgress(logStage)"><i class="icon information-circle"></i> <span class="log-stage-message">{{getLastInfoMessage(logStage).text}}</span></div><div class="log-stage-controls-container"><div class="progress-bar-container" ng-show="isInProgress(logStage)"><div class="ui indicating progress" bar-progress="{{logStage.progress}}"><div class="bar"><div class="progress"></div></div></div></div><button ng-repeat="action in logStage.actions track by action.type" class="mini ui button" ng-click="execute(action)">{{action.name}}</button></div></div></div></div><scroller to-bottom="onLogUpdated" element-selector=".log-stages-container"></scroller></div></div>',controller:"CollectionLogController"}}));
"use strict";angular.module("collectionpane").controller("SidePanelController",["$http","$scope","paneApi","collectionConstants","error","uiSession","stateMachine","$q","localize","requestIdentity","fileDialog","productMode",function(e,t,n,o,i,l,s,a,c,r,d,u){const m=n.get(r.get(t));t.state=s.get(r.get(t)),t.isBrowserMode=u.isBrowserMode();let p,f=o.collectionStates.unknown;function h(){const e=Date.now();return m.getCollectionState(f).then((function(n){if(n.state){if(f=n.state,n.collectionElapsedTime){const o=(Date.now()-e)/2;t.collectionStartTime=Date.now()-n.collectionElapsedTime-o}t.state.setCollectionState(f)}})).catch((e=>(t.state.setCollectionState(o.collectionStates.unknown),i.handle()(e),a.reject(e))))}function g(){return m.getResultState().then(S).catch((e=>(t.state.setResultState(o.nullResultState),i.handle()(e),a.reject(e))))}function S(e){e.resultInfo&&t.state.setResultState(e.resultInfo)}l.getPartitionSocket(t).then((e=>{p=e,c(["%sidePanel.start","%sidePanel.stop","%sidePanel.pause","%sidePanel.resume","%sidePanel.start_paused","%sidePanel.cancel","%sidePanel.mark_timeline","%sidePanel.search_binaries","%sidePanel.search_sources","%sidePanel.search_sources_and_binaries","%sidePanel.command_line","%sidePanel.refinalize","%sidePanel.importCsv"],"collectionapi").then((e=>{t.messages=e})),e.on("collection:status:updated",h),e.on("result:finalization:started",g),e.on("result:finalization:stopped",g),e.on("result:ready",g),e.on("result:error",g),h(),g()})),t.start=()=>{t.state.setCollectionState(o.collectionStates.starting),m.startCollection(),t.mode=o.modes.log},t.startPaused=()=>{t.state.setCollectionState(o.collectionStates.starting),m.startCollectionPaused(),t.mode=o.modes.log},t.pause=()=>{t.state.setCollectionState(o.collectionStates.frontend.pausing),m.pauseCollection().then(h)},t.resume=()=>{t.state.setCollectionState(o.collectionStates.frontend.resuming),m.resumeCollection().then(h)},t.cancel=()=>{t.state.setCollectionState(o.collectionStates.frontend.cancelling),m.cancelCollection().then(h)},t.stop=()=>{t.state.setCollectionState(o.collectionStates.stopping),m.stopCollection().then(h)},t.markTimeline=()=>{m.markTimeline()},t.showSearchSourcesAndBinaries=()=>{t.$emit("search-source-binary-dialog:show",{identity:r.get(t)})},t.refinalize=()=>{p&&p.emit("switchToCollectionLog"),t.mode=o.modes.log,t.state.setResultState(o.nullResultState),m.refinalize(),t.$emit("result:finalization:started")},t.showCommandLine=()=>{t.$emit("commandline-dlg:show",{identity:r.get(t)}),m.showCommandLine()},t.importCsv=()=>{c(["%importCsv.fileDialog.title","%importCsv.fileDialog.fileFilter"],"collectionpane").then((function(e){return d.showOpenDialog({dialogType:"open",multiSelect:!0,dialogTitle:e["%importCsv.fileDialog.title"],fileFilter:e["%importCsv.fileDialog.fileFilter"]})})).then((function(n){if(n&&n.length)return e.post("api/import/csv",{paths:n},{params:{identity:r.get(t)}})})).then(i.validateResponse).then((()=>m.refinalize(!1)))};const C=t.$watch("mode",(function(e){t.state.setDisplayMode(e)})),w=t.$watch((function(){return t.workflow.validationState}),(function(e){t.state.setValidationState(e)})),P=t.$watch((function(){return t.workflow.connectionEstablished}),(function(e){const n=t.workflow.connectionTypeDetails||{};t.state.setConnectionState(e,n.isEmulator)}));t.$on("$destroy",(function(){C&&C(),w&&w(),P&&P(),s.remove(r.get(t))}))}]);
"use strict";angular.module("collectionpane").directive("sidePanel",(function(){return{restrict:"E",template:'<div class="side-panel-container"><button ng-click="start()" id="start" class="ui button inverted primary massive circular icon" ng-show="state.isStartVisible()" ng-class="{ disabled: !state.isStartEnabled() }" tooltip="{{ messages[\'%sidePanel.start\'] }}" data-tour-item="runButtonTourItem"><i class="play icon"></i></button> <button ng-click="startPaused()" id="startPaused" class="ui button inverted primary massive circular icon" ng-show="state.isStartPausedVisible()" ng-class="{ disabled: !state.isStartPausedEnabled() }" tooltip="{{ messages[\'%sidePanel.start_paused\'] }}" data-tour-item="startPausedButtonTourItem"><i class="play-pause icon"></i></button> <button ng-click="resume()" id="resume" class="ui button inverted primary massive circular icon" ng-show="state.isResumeVisible()" ng-class="{ disabled: !state.isResumeEnabled() }" tooltip="{{ messages[\'%sidePanel.resume\'] }}"><i class="play icon"></i></button> <button ng-click="pause()" id="pause" class="ui button inverted primary big circular icon" ng-show="state.isPauseVisible()" ng-class="{ disabled: !state.isPauseEnabled() }" tooltip="{{ messages[\'%sidePanel.pause\'] }}"><i class="pause icon"></i></button> <button ng-click="stop()" id="stop" class="ui button inverted primary big circular icon" ng-show="state.isStopVisible()" ng-class="{ disabled: !state.isStopEnabled() }" tooltip="{{ messages[\'%sidePanel.stop\'] }}"><i class="stop icon"></i></button> <button ng-click="cancel()" id="cancel" class="ui button inverted primary big circular icon" ng-show="state.isCancelVisible()" ng-class="{ disabled: !state.isCancelEnabled() }" tooltip="{{ messages[\'%sidePanel.cancel\'] }}"><i class="cross icon"></i></button> <button ng-click="markTimeline()" id="markTimeline" class="ui button inverted primary big circular icon" ng-show="state.isMarkTimelineVisible()" ng-class="{ disabled: !state.isMarkTimelineEnabled() }" tooltip="{{ messages[\'%sidePanel.mark_timeline\'] }}"><i class="marker icon"></i></button> <button ng-click="showSearchSourcesAndBinaries()" id="searchSourcesAndBinaries" class="ui button inverted big circular icon" ng-show="state.areSearchSourceAndBinariesVisible()" ng-class="{ disabled: !state.areSearchSourceAndBinariesEnabled() }" tooltip="{{ messages[\'%sidePanel.search_sources_and_binaries\'] }}" data-tour-item="searchDirectoriesButtonTourItem"><i class="folder-open-magnifier icon"></i></button> <button ng-click="refinalize()" id="refinalize" class="ui button inverted big circular icon" ng-show="state.isRefinalizeVisible()" ng-class="{ disabled: !state.isRefinalizeEnabled() }" tooltip="{{ messages[\'%sidePanel.refinalize\'] }}"><i class="refinalize icon"></i></button> <button ng-click="importCsv()" id="importCsv" class="ui button inverted big circular icon" ng-show="state.isImportCsvVisible()" ng-if="::!isBrowserMode" ng-class="{ disabled: !state.isImportCsvEnabled() }" tooltip="{{ messages[\'%sidePanel.importCsv\'] }}"><i class="layer-apply icon"></i></button><timer ng-if="state.isTimerVisible()" start="::collectionStartTime"></timer><button ng-click="showCommandLine()" id="commandLine" class="ui button inverted big circular icon" ng-show="state.isShowCommandLineVisible()" ng-class="{ disabled: !state.isShowCommandLineEnabled() }" tooltip="{{ messages[\'%sidePanel.command_line\'] }}" data-tour-item="copyCommandlineButtonTourItem"><i class="command-line icon"></i></button></div>',scope:{mode:"=",workflow:"="},controller:"SidePanelController"}}));
"use strict";angular.module("collectionpane").factory("stateMachine",["collectionConstants","productMode",function(t,e){const n=new Map;return{get:o=>(n.has(o)||n.set(o,function(){const n={displayMode:void 0,validation:t.validationStates.unknown,connectionEstablished:void 0,connectionEmulated:void 0,collection:t.collectionStates.unknown,startPaused:void 0,result:t.nullResultState};function o(){return n.collection===t.collectionStates.starting||n.collection===t.collectionStates.running||n.collection===t.collectionStates.paused||n.collection===t.collectionStates.detached||n.collection===t.collectionStates.frontend.pausing||n.collection===t.collectionStates.frontend.resuming||n.collection===t.collectionStates.stopping||n.collection===t.collectionStates.frontend.cancelling}function i(){return n.collection===t.collectionStates.notStarted}function l(){return n.validation===t.validationStates.valid&&n.connectionEstablished&&!n.connectionEmulated}function c(){return n.collection===t.collectionStates.running||n.collection===t.collectionStates.paused||n.collection===t.collectionStates.detached}function s(){return n.result.areAllResultsValid&&!n.result.isFinalizationInProgress}return{setDisplayMode:function(t){n.displayMode=t},setValidationState:function(t){n.validation=t},setConnectionState:function(t,e){n.connectionEstablished=t,n.connectionEmulated=e},setStartPausedMode:function(t){n.startPaused=t},setCollectionState:function(t){n.collection=t},setResultState:function(t){n.result=t},collectionInProgress:o,isChooseTargetVisible:function(){return!1},isChooseAnalysisVisible:function(){return!1},isStartVisible:i,isStartEnabled:function(){return l()&&!n.startPaused},isStartPausedVisible:i,isStartPausedEnabled:function(){return l()},isResumeVisible:o,isResumeEnabled:function(){return n.collection===t.collectionStates.paused},isPauseVisible:o,isPauseEnabled:function(){return n.collection===t.collectionStates.running},isStopVisible:o,isStopEnabled:c,isCancelVisible:o,isCancelEnabled:c,isMarkTimelineVisible:function(){return o()},isMarkTimelineEnabled:function(){return n.collection===t.collectionStates.running},areSearchSourceAndBinariesVisible:function(){return!0!==e.isSaaSMode()&&(n.collection===t.collectionStates.notStarted||n.collection===t.collectionStates.complete)},areSearchSourceAndBinariesEnabled:function(){return n.collection===t.collectionStates.notStarted||n.collection===t.collectionStates.complete&&n.result.areAllResultsValid&&!n.result.isFinalizationInProgress},isShowCommandLineVisible:function(){return n.connectionEstablished&&n.collection===t.collectionStates.notStarted||n.collection===t.collectionStates.complete&&1===n.result.resultsCount&&n.result.areAllResultsValid},isShowCommandLineEnabled:function(){return n.collection===t.collectionStates.notStarted||1===n.result.resultsCount&&!n.result.isFinalizationInProgress},isRefinalizeVisible:function(){return n.collection===t.collectionStates.complete},isRefinalizeEnabled:s,isImportCsvVisible:function(){return n.collection===t.collectionStates.complete&&1===n.result.resultsCount},isImportCsvEnabled:s,isClearLogDisabled:function(){return o()||n.result.isFinalizationInProgress},isTimerVisible:function(){return n.collection===t.collectionStates.running||n.collection===t.collectionStates.paused||n.collection===t.collectionStates.frontend.pausing||n.collection===t.collectionStates.frontend.resuming}}}()),n.get(o)),remove(t){n.delete(t)}}}]);
"use strict";angular.module("collectionpane").controller("ImportPaneController",["$http","$q","$scope","error","localize","requestIdentity","uiSession","productManager","productConstants","fileDialog","resultApi",function(t,e,o,i,n,a,l,r,c,s,p){let d,u;function I(){this.isValid=!1,this.enabled=!0}function f(){return o.locationId===o.resultLocationId?o.resultInput:(h(),o.rawDataInput)}function g(t){t&&(o.locationId===o.resultLocationId?o.resultInput=t:(o.rawDataInput=t,h()))}function m(){return{params:{identity:o.identity}}}function h(){o.importMultipleFile?o.directoryInput=o.rawDataInput:o.fileInput=o.rawDataInput}o.configMode="configMode",o.logMode="logMode",o.mode=o.configMode,o.rawDataLocationId="raw-data-location",o.resultLocationId="result-location",o.locationId=o.rawDataLocationId,o.importMultipleFile=!1,o.createLink=!1,o.rawDataInput="",o.sidePanel=new I,p.openResult({projectPath:r.state.currentProjectPath,isImport:!0}).then((t=>(t&&t.data&&(o.identity=t.data.identity,a.set(o,o.identity),o.config.actions&&o.config.actions.setIdentity&&o.config.actions.setIdentity(o.identity)),l.getPartitionSocket(o)))).then((()=>e.all([t.post("api/import/get-file-filter",{},m()).then((t=>{t&&t.data&&({fileFilter:d,resultFilter:u}=t.data)})),n(["%importPane.selectResultToImport","%importPane.selectFolderToImport"],"collectionapi").then((t=>{o.messages=t}))]))),o.onBrowse=()=>{s.showOpenDialog(function(){const t=o.locationId===o.rawDataLocationId&&!o.importMultipleFile||o.locationId===o.resultLocationId?{dialogType:"open",dialogTitle:o.messages["%importPane.selectResultToImport"]}:{dialogType:"folder",dialogTitle:o.messages["%importPane.selectFolderToImport"]};o.locationId===o.rawDataLocationId?(d&&!o.importMultipleFile&&(t.fileFilter=d),o.fileInput&&(t.defaultFileName=o.fileInput)):o.locationId===o.resultLocationId&&(u&&(t.fileFilter=u),o.resultInput&&(t.defaultFileName=o.resultInput));const e=o.directoryInput;e&&e.length&&(t.defaultPath=e);return t}()).then(g).then(o.validate)},o.validate=()=>{let e;e=o.locationId===o.resultLocationId?"resultFile":o.importMultipleFile?"directory":"file",t.post("api/import/validate/",{path:f(),option:e},m()).then((t=>{o.sidePanel.isValid=t.data.isValid}))},o.onChangeRawDataMode=()=>{o.rawDataInput=o.importMultipleFile?o.directoryInput:o.fileInput,o.validate()},o.$on("collectionLog:action:cancel",(t=>{o.config.actions&&o.config.actions.onClose&&o.config.actions.onClose(),t.stopPropagation()})),I.prototype.import=function(){return o.mode=o.logMode,this.enabled=!1,t.post("api/import/",{path:f(),createLink:o.createLink},m()).then(i.validateResponse).then((t=>(o.config.actions&&o.config.actions.onImportStarted&&o.config.actions.onImportStarted(),p.setPath({path:t.resultPath,identity:o.identity}).then((()=>r.processResultImport({identity:o.identity,result1Path:t.resultPath}))))))},I.prototype.cancel=function(){t.post("api/import/cancel",{},m()),o.config.actions&&o.config.actions.onClose&&o.config.actions.onClose()},I.prototype.showSearchSourcesAndBinaries=function(){o.$emit("search-source-binary-dialog:show",{identity:o.identity})}}]);
"use strict";angular.module("collectionpane").directive("importPane",(function(){return{restrict:"E",scope:{config:"<"},template:'<div class="import-pane" localize="localize" default-msg-catalog="collectionapi"><branded-header caption="::localize(\'%importPane.title\')"></branded-header><div class="import-configuration" ng-show="identity"><div ng-show="mode === configMode" class="main-area"><div class="ui form"><div class="grouped fields"><div class="field option raw-data-section"><div class="ui radio checkbox"><input type="radio" name="location" ng-model="locationId" ng-attr-value="{{::rawDataLocationId}}" ng-change="validate()"> <label tooltip="{{::localize(\'%importPane.importRawDataToolTip\')}}">{{::localize(\'%importPane.importRawData\')}} <span class="icon help-circle"></span></label></div><div class="ui field location" ng-class="{disabled: locationId === resultLocationId}"><div class="ui action input size-watch" tooltip="{{importMultipleFile ? localize(\'%importPane.importMultipleFileToolTip\')\n                                                               : localize(\'%importPane.importRawDataToolTip\')}}"><input type="text" ng-model="rawDataInput" ng-change="validate()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 250, \'blur\': 0 } }"> <button class="ui icon button" ng-click="onBrowse()"><i class="icon folder"></i></button></div><div class="ui checkbox checkbox-area" ng-model="importMultipleFile" ng-change="validate()"><input type="checkbox" ng-model="importMultipleFile" ng-change="onChangeRawDataMode()" id="importMultipleFileId" ng-disabled="locationId === resultLocationId"> <label for="importMultipleFileId" tooltip="{{::localize(\'%importPane.importMultipleFileToolTip\')}}">{{::localize(\'%importPane.importMultipleFile\')}} <span class="icon help-circle"></span></label></div></div></div><div class="field option result-file-section"><div class="ui radio checkbox"><input type="radio" name="location" ng-model="locationId" ng-attr-value="{{::resultLocationId}}" ng-change="validate()"> <label tooltip="{{::localize(\'%importPane.importResultToolTip\')}}">{{::localize(\'%importPane.importResult\')}} <span class="icon help-circle"></span></label></div><div class="ui field location" ng-class="{disabled: locationId !== resultLocationId}"><div class="ui action input size-watch" tooltip="{{::localize(\'%importPane.importResultToolTip\')}}"><input type="text" ng-model="resultInput" ng-change="validate()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 250, \'blur\': 0 } }"> <button class="ui icon button" ng-click="onBrowse()"><i class="icon folder"></i></button></div><div class="ui checkbox checkbox-area" ng-model="createLink"><input type="checkbox" ng-model="createLink" id="createLinkId" ng-disabled="locationId !== resultLocationId"> <label for="createLinkId" tooltip="{{::localize(\'%importPane.importCreateLinkToolTip\')}}">{{::localize(\'%importPane.importCreateLink\')}} <span class="icon help-circle"></span></label></div></div></div></div></div></div><collection-log ng-if="mode === logMode"></collection-log><import-side-panel side-panel="::sidePanel"></import-side-panel></div></div><import-pane-test-harness-dump></import-pane-test-harness-dump>',controller:"ImportPaneController"}}));
"use strict";angular.module("collectionpane").directive("collectionPaneTestHarnessDump",["$timeout","$q","$interval","dumpHelper","dumpDispatcher",function(e,t,n,i,a){return{restrict:"E",scope:{initMode:"<",type:"="},link:function(s){const r="collection",o=".test-connection-types-list .test-connection-type, .agent-connection-configuration .selectable";function c(t,n){return e((()=>{t.mousedown(),t.mouseup(),t.click(),n.$apply()}))}function l(t,n){return e((()=>{t.val(n).change(),t.click(),t.trigger("blur");const e=angular.element(t).scope();e&&e.$apply()}))}function p(){const i=t.defer(),a=n((()=>{!$(".collection-pane .connection.loading").is(":visible")&&d().length&&(i.resolve(),n.cancel(a))}),100);return e((function(){n.cancel(a),i.reject("Timeout on waiting for loading to complete.")}),6e4),i.promise}function u(){const i=t.defer(),a=n((()=>{$(".analysis-waiting .message.warning").is(":visible")||$(".analysis-configuration .loading").is(":visible")||(i.resolve(),n.cancel(a))}),100);return e((function(){n.cancel(a),i.reject("Timeout on waiting for warning message is hidden.")}),6e4),i.promise}function d(){return $(".test-target-types").find("badge").map(((e,t)=>{const n=i.generateActionURL("selectTargetType","collection");return{name:$(t).text().trim(),selected:$(t).find(".badge").hasClass("active"),action:{href:`${n}&typeIndex=${e}`}}})).get()}function y(e,t){return $(t).find("badge").map(((e,t)=>{const n=i.generateActionURL("selectAnalysisType","collection"),a=$(t).attr("id");return{name:$(t).text().trim(),id:a,selected:$(t).hasClass("active"),action:{href:`${n}&analysisTypeId=${a}`}}})).get()}function g(){const e=$(".connection-configuration");return{name:$(e).find(".knob label").text(),knobs:b(e),buttons:(t=e,$(t).find(".button[id]:visible").toArray().reduce(((e,t)=>(e[$(t).attr("id")]=v(t),e)),{})),messages:f(e)};var t}function f(e){return $("div.errors div",e).toArray().map(m)}function m(e){return{description:e.innerText,severity:e.getAttribute("class").split(" ").filter((e=>"message"!==e&&"icon"!==e&&!e.startsWith("ng-")))[0]}}function b(e){return $(e).find(".knob").map(((e,t)=>({name:$(t).find("label").text(),id:$(t).attr("id"),value:$(t).find('input[type="radio"]:checked').val()||$(t).find("input").val(),action:{href:h(t)}}))).get()}function v(e){const t=$(e).attr("id");return`${i.generateActionURL("click","collection")}&id=${t}`}function h(e){const t=$(e).attr("id");let n;return $(e).hasClass("boolean")?(n=i.generateActionURL("check","collection"),`${n}&id=${t}`):(n=i.generateActionURL("input","collection"),`${n}&id=${t}&val=`)}function A(){const e=(e,t)=>{const n=function(e){const t=$(e).find("input");switch(t.attr("type")){case"radio":return t.filter(":checked").val();case"checkbox":return t.prop("checked");default:return t.val()}}(t);return{name:$(t).find("label").text(),id:$(t).attr("id"),value:n,action:{href:h(t)}}};return[...$(".analysis-knobs").find(".knob").map(e).get(),...$(".analysis-low-level-knobs").find(".knob").map(e).get()]}a.addDumpListener({paneId:r,$scope:s},(async function(){try{return await Promise.all([p(),u()]),{paneId:r,type:s.type,dump:{type:s.type,connection:{types:$(o).map(((e,t)=>{const n=i.generateActionURL("selectConnectionType","collection");return{name:$(t).text(),id:$(t).attr("id"),selected:$(t).hasClass("active"),action:{href:`${n}&typeIndex=${e}`}}})).get(),selectedType:g()},targets:{types:d(),selectedType:{name:$(".test-target-types").find("tile-header-current").text(),panels:$(".target-type-configuration-exp .panel").map(((e,t)=>({name:$(t).find(".knob-panel").attr("id"),knobs:b(t)}))).get()}},analysis:{message:$(".analysis-type .message pre, .analysis-waiting .message.error pre").text(),groups:$(".test-analysis-types-list .group").map(((e,t)=>({name:$(t).find(".group-title").text(),types:y(e,t)}))).get(),selectedType:{name:$(".test-analysis-type-selected .header").text(),description:$(".analysis-type .description").text(),knobs:A()},actions:{copy:{href:i.generateActionURL("copyCurrentAnalysisType","collection")},edit:{href:i.generateActionURL("editCurrentAnalysisType","collection")},save:{href:i.generateActionURL("saveCurrentAnalysisType","collection")},editName:{href:i.generateActionURL("editCurrentAnalysisTypeName","collection")},editCLIName:{href:i.generateActionURL("editCurrentAnalysisTypeCLIName","collection")},editAbbreviation:{href:i.generateActionURL("editCurrentAnalysisTypeAbbreviation","collection")}}},sidePanel:{buttons:$("side-panel .button").map(((e,t)=>({button:$(t).attr("id"),action:v(t)}))).get()},collectionLog:{logStages:$(".log-stage").map(((e,t)=>{const n=$(t).find(".log-stage-body"),i=$(t).find(".log-stage-icon"),a=n.find(".log-stage-caption").text();let s="";i.hasClass("check-circle")?s="Done":i.hasClass("alert-triangle")?s="Warning":i.hasClass("cross-circle")&&(s="Error");let r="";return a.toLowerCase().indexOf("collection")>-1||a.toLowerCase().indexOf("collecting")>-1?r="Collection":(a.toLowerCase().indexOf("finalization")>-1||a.toLowerCase().indexOf("finalize")>-1)&&(r="Finalization"),{index:e,caption:a,description:n.find(".log-stage-description").text(),status:s,type:r}})).get()}}}}catch(e){return{paneId:r,dump:{message:e.message||e,stack:e.stack}}}})),a.addActionListener({paneId:r,$scope:s},(async function(t){if(-1!==t.type.indexOf("select")){let n;if("selectAnalysisType"===t.type){const{analysisTypeId:e}=t;n=$(".test-analysis-types-list").find(".group").map(((t,n)=>$(n).find("badge").map(((t,n)=>{if(n.id===e)return n})).get()))}else if("selectTargetType"===t.type){const e=Number(t.typeIndex);n=$(".test-target-types").find("badge").eq(e)}else if("selectConnectionType"===t.type){const e=Number(t.typeIndex);n=$(o).eq(e)}return e((()=>(n.click(),e((()=>{const e=angular.element(n).scope();e&&e.$apply()}),100))),100)}if("input"===t.type){const n=t.id,i=t.val,a=$(".knob").map(((e,t)=>{if(t.id===n)return t})).get(),s=$(a).find("input");return e((()=>{let e;var t;$(a).hasClass("group-enum")?(t=i,$(a).find(":radio").each((function(){$(this).val()===t&&this.click()})),e=angular.element(a).scope()):(s.val(i).change(),s.click(),s.trigger("blur"),e=angular.element(s).scope()),e&&e.$apply()}),100)}if("check"===t.type){const n=t.id,i=$(".knob").map(((e,t)=>{if(t.id===n)return t})).get(),a=$(i).find("input");return e((()=>(a.click(),e((()=>{const e=angular.element(a).scope();e&&e.$apply()}),100))),100)}if("click"===t.type){const e=t.id,n=angular.element(document.getElementById(e));return n.attr("disabled")?{paneId:r,error:"Action isn't available"}:c(n,n.scope())}if("copyCurrentAnalysisType"===t.type){const e=$("#copyCurrentAnalysisType");return c(e,angular.element(e).scope())}if("editCurrentAnalysisType"===t.type){const e=$("#editCurrentAnalysisType");return c(e,angular.element(e).scope())}if("saveCurrentAnalysisType"===t.type){const e=$("#saveCurrentAnalysisType");return c(e,angular.element(e).scope())}if("editCurrentAnalysisTypeName"===t.type){return l(angular.element('input[ng-model="workflow.analysisTypeDetails.analysisTypeName"]'),t.value)}if("editCurrentAnalysisTypeCLIName"===t.type){return l(angular.element('input[ng-model="workflow.analysisTypeDetails.commandLineName"]'),t.value)}if("editCurrentAnalysisTypeAbbreviation"===t.type){return l(angular.element('input[ng-model="workflow.analysisTypeDetails.abbreviation"]'),t.value)}}))}}}]);
"use strict";angular.module("collectionpane").directive("comparePaneTestHarnessDump",["$timeout","$q","$interval","dumpHelper","dumpDispatcher",function(e,t,n,o,c){return{restrict:"E",link:function(i){const r="compare";function u(e,t){return o.generateActionURL(e,"compare")+"&section="+t}function a(e,t){return`${u("click",t)}&id=${e}`}function s(e){const t="."+e+"-section";return{actions:{setPath:u("setPath",e)+"&val=",openFileDialog:u("openFileDialog",e)},caption:$(t).find(".title").text(),value:$(t).find("input").val()}}function l(){return["compareButton","swapButton"].map((e=>function(e){return{button:e,action:a(e,"common-section")}}(e)))}function p(t,n){return e((()=>{t.mousedown(),t.mouseup(),t.click(),n.$apply()}))}c.addDumpListener({paneId:r,$scope:i},(async function(){try{return await function(){const o=t.defer(),c=n((()=>{$(".result1-section").is(":visible")&&(o.resolve(),n.cancel(c))}),100);return e((function(){n.cancel(c),o.reject("Timeout on waiting for loading to complete.")}),6e4),o.promise}(),{paneId:r,dump:{result1:s("result1"),result2:s("result2"),buttons:l()}}}catch(e){return{paneId:r,dump:{message:e.message||e,stack:e.stack}}}})),c.addActionListener({paneId:r,$scope:i},(async function(t){if("click"===t.type){const e=t.id,n=angular.element(document.getElementsByClassName(e));return p(n,n.scope())}if("setPath"===t.type){const n=t.val,o="."+t.section+"-section",c=$(o).find("input[type=text]");return e((()=>{c.val(n).change(),c.click(),c.trigger("blur")}),100)}if("openFileDialog"===t.type){const e="."+t.type+"-section",n=angular.element($(e).find("button .folder"));return p(n,n.scope())}}))}}}]);
"use strict";angular.module("collectionpane").directive("importPaneTestHarnessDump",["$timeout","$q","$interval","dumpHelper","dumpDispatcher",function(e,t,n,i,o){return{restrict:"E",link:function(c){const a="import";function r(e,t){return i.generateActionURL(e,"import")+"&section="+t}function s(e,t){const n=$(e).attr("id");return`${r("click",t)}&id=${n}`}function u(t,n){return e((()=>{t.mousedown(),t.mouseup(),t.click(),n.$apply()}))}function p(e){const[t]=$(e).find("input[type=radio]");return i.dispatchElementMouseEvent("click",t)}o.addDumpListener({paneId:a,$scope:c},(async function(){try{return await function(){const i=t.defer(),o=n((()=>{$(".result-file-section").is(":visible")&&(i.resolve(),n.cancel(o))}),100);return e((function(){n.cancel(o),i.reject("Timeout on waiting for loading to complete.")}),6e4),i.promise}(),{paneId:a,dump:{sections:["result-file-section","raw-data-section"].map((e=>function(e){const t="."+e;return{actions:{setPath:r("setPath",e)+"&val=",openFileDialog:r("openFileDialog",e)},selected:$(t).find("input").prop("checked"),name:$(t).find(".radio").find("label").text(),value:$(t).find(".input").find("input").val(),mode:$(t).find(".checkbox-area").find("input").prop("checked")}}(e))),sidePanel:{buttons:$("import-side-panel .button").map(((e,t)=>({button:$(t).attr("id"),action:s(t,"import-side-panel")}))).get()}}}}catch(e){return{paneId:a,dump:{message:e.message||e,stack:e.stack}}}})),o.addActionListener({paneId:a,$scope:c},(async function(t){if("click"===t.type){const e=t.id,n=angular.element(document.getElementById(e));return u(n,n.scope())}if("setPath"===t.type){const n=t.val,i="."+t.section;await p(i);const o=$(i).find("input[type=text]");return e((()=>{o.val(n).change(),o.click(),o.trigger("blur")}),100)}if("openFileDialog"===t.type){const e="."+t.section;await p(e);const n=angular.element($(e).find("button .folder"));return u(n,n.scope())}}))}}}]);
"use strict";angular.module("collectionpane").controller("AnalysisTypeController",["workflow","$scope","$http","error","uiSession","localize","collectionConstants","requestIdentity",function(o,e,t,a,s,n,i,l){e.workflow=o.get(l.get(e)),s.getPartitionSocket(e).then((()=>{n(["%custom.analysis.edit.tooltip","%custom.analysis.save.tooltip","%custom.analysis.copy.tooltip","%custom.analysis.delete.tooltip","%custom.analysis.delete.confirmation.caption","%custom.analysis.delete.confirmation.button","%analysisType.name.tooltip","%analysisType.commandLineName","%analysisType.commandLineName.tooltip","%analysisType.abbreviation","%analysisType.abbreviation.tooltip","%analysisType.description.tooltip","%details"],"collectionapi").then((o=>{e.messages=o}))})),e.onOpen=()=>{e.$broadcast("resizeGrids")},e.saveKnobAndReloadAnalysisType=e.workflow.saveAnalysisTypeKnobsAndReload,e.onLowLevelKnobChange=function(){},e.applicableError=o=>o.type===i.errorTypes.analysis||o.type===i.errorTypes.customAnalysisMetadata}]);
"use strict";angular.module("collectionpane").directive("analysisType",(function(){return{scope:{readOnly:"="},template:'<div class="analysis-type" ng-show="workflow.analysisTypeDetails"><section><div class="description" ng-hide="workflow.analysisTypeEditMode" html-content="{{workflow.analysisTypeDetails.analysisTypeDescription}}"></div><div ng-show="workflow.analysisTypeEditMode" class="ui form description"><div class="field ui" tooltip="{{ messages[\'%analysisType.description.tooltip\'] }}"><div class="ui input"><input ng-model="workflow.analysisTypeDetails.analysisTypeDescription" ng-change="workflow.saveCustomAnalysisTypeMetadata()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }"></div></div></div><errors ng-hide="workflow.readOnly" errors="workflow.errors" filter="applicableError" allow-retry="true"></errors></section><section><knobs knobs="workflow.analysisTypeDetails.knobs" class="ui form analysis-knobs" on-knob-change="saveKnobAndReloadAnalysisType" read-only="workflow.readOnly"></knobs><knobs ng-if="workflow.analysisTypeDetails.custom" knobs="workflow.analysisTypeDetails.lowLevelKnobs" class="ui form analysis-low-level-knobs" on-knob-change="workflow.saveAnalysisTypeKnob" read-only="workflow.readOnly"></knobs><div ng-if="!workflow.analysisTypeDetails.custom && workflow.analysisTypeDetails.lowLevelKnobs" class="ui styled fluid accordion advanced" on-open="onOpen"><div class="title"><i class="chevron-right icon"></i> {{ messages[\'%details\'] }}</div><div class="content"><knobs knobs="workflow.analysisTypeDetails.lowLevelKnobs" class="ui form analysis-low-level-knobs" on-knob-change="onLowLevelKnobChange" read-only="true"></knobs></div></div></section></div>',controller:"AnalysisTypeController"}}));
"use strict";angular.module("collectionpane").controller("AnalysisTypesController",["workflow","uiSession","$scope","localize","requestIdentity",function(s,e,t,a,n){function o(s,e){return"<p>"+s+'</p><img src="'+e+'">'}function i(s){const e=s.description?s.description:"";switch(s.id){case"%HotspotsAtypeName":return o(e,"assets/analysis_types/GSP_Hotspots.png");case"%ThreadingAtypeName":return o(e,"assets/analysis_types/GSP_Threading.png");case"%CommonGeneralExplorationAtypeName":return o(e,"assets/analysis_types/GSP_Ge.png");case"%MicroarchitectureExplorationAtypeName":return o(e,"assets/analysis_types/GSP_UA.png");case"%HPCPerfCharAtypeName":return o(e,"assets/analysis_types/GSP_HPC.png");case"%MemoryAccessAtypeName":return o(e,"assets/analysis_types/GSP_Mem.png");case"%GpuOffloadAtypeName":return o(e,"assets/analysis_types/GSP_GO.png");case"%IOAtypeName":return o(e,"assets/analysis_types/GSP_IO.svg");default:return e}}t.workflow=s.get(n.get(t)),t.getCurrentAnalysisTypeIconClassname=()=>{if(t.workflow.analysisTypeDetails)return t.workflow.analysisTypeDetails.iconClassname||"gear10"},e.getPartitionSocket(t).then((()=>{a(["%analysisType.name.tooltip","%analysisType.commandLineName.tooltip","%analysisType.commandLineName","%analysisType.abbreviation.tooltip","%analysisType.abbreviation","%custom.analysis.edit.tooltip","%custom.analysis.save.tooltip","%custom.analysis.copy.tooltip","%custom.analysis.delete.confirmation.caption","%custom.analysis.delete.tooltip"],"collectionpane").then((s=>{t.messages=s}))})),t.dataForATree=()=>{const{analysisTypeGroups:s}=t.workflow;for(const e in s)for(const t in s[e].types){const a=s[e].types[t];s[e].types[t].tooltip=i(a)}return s},t.$on("configuration:analysis:type:set",((s,e)=>{const a=(s=>{const{analysisTypeGroups:e}=t.workflow;for(const t in e)for(const a in e[t].types){const n=e[t].types[a];if(n.name===s||n.id===s)return n}})(e);a&&t.workflow.onAnalysisTypeSelected(a)}))}]);
"use strict";angular.module("collectionpane").directive("analysisTypes",(function(){return{restrict:"E",template:'<tile-header data-tour-item="howHeaderTourItem" current-header="workflow.analysisTypeEditMode ? null : workflow.analysisTypeDetails.analysisTypeName" current-icon-class="getCurrentAnalysisTypeIconClassname()" is-active="!workflow.readOnly"><tile-header-extra class="test-analysis-type-selected"><div class="edit-panel ui form" ng-show="workflow.analysisTypeEditMode" ng-click="$event.stopPropagation()"><div class="sixteen wide field ui" tooltip="{{ messages[\'%analysisType.name.tooltip\'] }}"><div class="ui massive input analysis-type-name"><input ng-model="workflow.analysisTypeDetails.analysisTypeName" ng-change="workflow.saveCustomAnalysisTypeMetadata()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }"></div></div><div class="equal width fields"><div class="field ui" tooltip="{{ messages[\'%analysisType.commandLineName.tooltip\'] }}"><label>{{ messages[\'%analysisType.commandLineName\'] }}</label> <input ng-model="workflow.analysisTypeDetails.commandLineName" ng-change="workflow.saveCustomAnalysisTypeMetadata()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }"></div><div class="field ui" tooltip="{{ messages[\'%analysisType.abbreviation.tooltip\'] }}"><label>{{ messages[\'%analysisType.abbreviation\'] }}</label> <input ng-model="workflow.analysisTypeDetails.abbreviation" ng-change="workflow.saveCustomAnalysisTypeMetadata()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }"></div></div></div><button ng-click="workflow.analysisTypeEditMode = true; $event.stopPropagation()" ng-hide="workflow.analysisTypeEditMode || !workflow.analysisTypeDetails.custom" class="big circular borderless ui icon button enter-edit-mode" tooltip="{{ messages[\'%custom.analysis.edit.tooltip\'] }}" id="editCurrentAnalysisType"><i class="icon pencil"></i></button> <button ng-click="workflow.analysisTypeEditMode = false; $event.stopPropagation()" ng-show="workflow.analysisTypeEditMode" class="big circular borderless ui icon button active exit-edit-mode" tooltip="{{ messages[\'%custom.analysis.save.tooltip\'] }}" id="saveCurrentAnalysisType"><i class="icon pencil"></i></button> <button ng-click="workflow.copyCurrentAnalysisType(); $event.stopPropagation()" class="big circular borderless ui icon button" tooltip="{{ messages[\'%custom.analysis.copy.tooltip\'] }}" id="copyCurrentAnalysisType" data-tour-item="copyButtonTourItem"><i class="icon plus"></i></button><confirmation-button ng-show="workflow.analysisTypeDetails.custom" ng-click="$event.stopPropagation()" on-confirm="workflow.deleteCurrentAnalysisType()" icon="trash" confirmation="messages[\'%custom.analysis.delete.confirmation.caption\']" class="confirmation-button" confirmation-tooltip="messages[\'%custom.analysis.delete.tooltip\']"></confirmation-button></tile-header-extra><tile-header-options class="test-analysis-types-list"><analysis-tree data="dataForATree()" selected-id="workflow.analysisType.id" on-click-handler="workflow.onAnalysisTypeSelected"></analysis-tree></tile-header-options></tile-header>',controller:"AnalysisTypesController"}}));
"use strict";angular.module("collectionpane").controller("ConnectionTypesController",["workflow","$scope","uiSession","$timeout","collectionConstants","localize","productMode","iconClassname","requestIdentity",function(e,o,n,t,c,i,s,l,r){o.workflow=e.get(r.get(o));const{LOCALHOST_CONNECTION:C,AGENT_CONNECTION:a}=c.connectionTypeIds;n.getPartitionSocket(o).then((()=>{i(["%connectionType.select"],"collectionapi").then((e=>{o.messages=e}))})),o.getIconClass=e=>{if(e)return l.get(e.id)};const d=s.isBrowserMode()?[C,a]:[];o.getConnectionTypes=()=>o.workflow.connectionTypes.filter((e=>d.indexOf(e.id)<0)),o.getAgentConnection=()=>o.workflow.connectionTypes.find((e=>e.id===a))}]);
"use strict";angular.module("collectionpane").directive("connectionTypes",(function(){return{scope:{},template:'<tile-header data-tour-item="whereHeaderTourItem" current-header="workflow.connectionType.name" current-icon-class="getIconClass(workflow.connectionType)" is-active="!workflow.readOnly"><tile-header-options class="test-connection-types-list"><agent-connection-configuration connection-type="::getAgentConnection()" ng-if="::getAgentConnection()"></agent-connection-configuration><badge class="test-connection-type" ng-repeat="type in getConnectionTypes() track by type.id" ng-click="workflow.onConnectionTypeSelected(type)" name="::type.name" is-selected="type.id == workflow.connectionType.id" icon-class="getIconClass(type)" id="{{ type.id }}"></badge></tile-header-options></tile-header>',controller:"ConnectionTypesController"}}));
"use strict";angular.module("collectionpane").controller("ConnectionTypeController",["workflow","$scope","$http","error","collectionConstants","requestIdentity",function(o,e,n,r,t,l){e.workflow=o.get(l.get(e)),e.onKnobChange=e.workflow.saveConnectionKnob,e.applicableError=o=>o.type===t.errorTypes.connection||o.type===t.errorTypes.targetSession}]);
"use strict";angular.module("collectionpane").directive("connectionType",(function(){return{scope:{},restrict:"E",template:'<section class="connection-configuration" ng-show="workflow.connectionTypeDetails.knobs"><errors ng-hide="readOnly" errors="workflow.errors" filter="applicableError" allow-retry="true"></errors><knobs knobs="workflow.connectionTypeDetails.knobs" class="ui form panel-knobs connection-knobs" on-knob-change="onKnobChange" read-only="workflow.readOnly"></knobs><table ng-show="readOnly" class="connection-knobs"><tr ng-repeat="knob in workflow.connectionTypeDetails.knobs track by $id(knob)"><td>{{ knob.name }}:</td><td>{{ getKnobDisplayValue(knob) }}</td></tr></table></section>',controller:"ConnectionTypeController"}}));
"use strict";angular.module("collectionpane").controller("TargetTypeController",["workflow","$scope","$http","uiSession","collectionConstants","error","localize","requestIdentity","productMode",function(e,o,n,t,r,a,l,i,s){o.workflow=e.get(i.get(o)),o.isBrowserMode=s.isBrowserMode(),t.getPartitionSocket(o).then((()=>{l(["%advancedPanel"],"collectionapi").then((e=>{o.messages=e}))})),o.onPanelKnobChange=e=>(e.onKnobChange||(e.onKnobChange=(n,t)=>o.workflow.saveTargetTypeKnob(e,n,t)),e.onKnobChange),o.getPanelName=function(e){return r.panels[e.id]},o.applicableError=e=>e.type===r.errorTypes.workload,o.getKnobDisplayValue=e=>{if(e.items){const o=e.items.find((o=>o.value===e.value));if(o)return o.display_value}return e.value}}]);
"use strict";angular.module("collectionpane").directive("targetType",(function(){return{scope:{readOnly:"="},template:'<div class="target-type-configuration-exp" ng-show="workflow.targetTypeDetails"><section><div class="description" ng-hide="readOnly" html-content="{{workflow.targetTypeDetails.description}}"></div><errors ng-hide="readOnly" errors="workflow.errors" filter="applicableError" allow-retry="true"></errors></section><section><div class="panel" ng-repeat="panel in workflow.targetTypeDetails.panels track by panel.id" ng-switch="getPanelName(panel)"><application-panel id="AppToLaunch" class="knob-panel" read-only="readOnly" ng-switch-when="AppToLaunch" panel="panel" on-knob-change="onPanelKnobChange(panel)"></application-panel><android-run-panel id="AndroidRun" class="knob-panel" read-only="readOnly" ng-switch-when="AndroidRun" panel="panel" on-knob-change="onPanelKnobChange(panel)"></android-run-panel><process-panel id="AttachToProcess" class="knob-panel" read-only="readOnly" ng-switch-when="AttachToProcess" panel="panel" on-knob-change="onPanelKnobChange(panel)"></process-panel><attach-process-remote-panel id="AttachToProcessRemote" class="knob-panel" read-only="readOnly" ng-switch-when="AttachToProcessRemote" panel="panel" on-knob-change="onPanelKnobChange(panel)"></attach-process-remote-panel><mpi-run-panel id="MpiRun" class="knob-panel" read-only="readOnly" ng-switch-when="MpiRun" panel="panel" on-knob-change="onPanelKnobChange(panel)"></mpi-run-panel></div><div class="ui styled fluid accordion advanced"><div class="title"><i class="chevron-right icon"></i> {{ messages[\'%advancedPanel\'] }}</div><div class="content"><div class="advanced-panel panel" ng-repeat="panel in workflow.targetTypeDetails.advancedPanels track by panel.id" ng-switch="getPanelName(panel)"><environment-panel id="EnvironmentVariable" class="knob-panel" read-only="readOnly" ng-switch-when="EnvironmentVariable" panel="panel" on-knob-change="onPanelKnobChange(panel)"></environment-panel><inheritable-knobs-panel id="InheritableKnobs" class="knob-panel" read-only="readOnly" ng-switch-when="InheritableKnobs" panel="panel" on-knob-change="onPanelKnobChange(panel)"></inheritable-knobs-panel><resume-after-panel id="ExperementDurationWithResumeAuto" class="knob-panel" read-only="readOnly" ng-switch-when="ExperimentDurationWithResumeAuto" panel="panel" on-knob-change="onPanelKnobChange(panel)"></resume-after-panel><connection-type-knobs-panel id="ConnectionTypeKnob" class="knob-panel" read-only="readOnly" ng-switch-when="ConnectionTypeKnob" panel="panel" on-knob-change="onPanelKnobChange(panel)"></connection-type-knobs-panel><non-inheritable-knobs-panel id="NonInheritableKnobs" class="knob-panel" read-only="readOnly" ng-switch-when="NonInheritableKnobs" panel="panel" on-knob-change="onPanelKnobChange(panel)"></non-inheritable-knobs-panel><result-dir-panel id="ResultDirectory" class="knob-panel" read-only="readOnly" ng-switch-when="ResultDirectory" ng-if="::!isBrowserMode" panel="panel" on-knob-change="onPanelKnobChange(panel)"></result-dir-panel></div></div></div></section></div>',controller:"TargetTypeController"}}));
"use strict";angular.module("collectionpane").directive("importSidePanel",(function(){return{restrict:"E",template:'<div class="import-side-panel-container" localize="localize"><button ng-click="sidePanel.import()" id="importButton" class="ui button inverted primary huge" ng-disabled="!sidePanel.isValid || !sidePanel.enabled"><i class="icon download"></i>{{::localize(\'%sidePanel.import\')}}</button> <button ng-click="sidePanel.showSearchSourcesAndBinaries()" id="searchSourcesAndBinariesButton" class="ui button inverted minor" ng-disabled="!sidePanel.enabled"><i class="icon folder-open-magnifier"></i>{{::localize(\'%sidePanel.search_sources_and_binaries\')}}</button> <button ng-click="sidePanel.cancel()" id="cancelButton" class="ui button inverted minor" ng-show="sidePanel.enabled"><i class="icon cross"></i>{{::localize(\'%sidePanel.cancel\')}}</button></div>',scope:{sidePanel:"="}}}));
"use strict";angular.module("collectionpane").controller("TargetTypesController",["workflow","uiSession","$scope","localize","iconClassname","requestIdentity",function(e,t,o,l,n,s){o.workflow=e.get(s.get(o)),t.getPartitionSocket(o).then((()=>{l(["%targetType.select"],"collectionapi").then((e=>{o.messages=e}))})),o.getIconClass=e=>{if(e)return n.get(e.id)}}]);
"use strict";angular.module("collectionpane").directive("targetTypes",(function(){return{restrict:"E",template:'<tile-header data-tour-item="whatHeaderTourItem" current-header="workflow.targetTypeDetails.name" current-icon-class="getIconClass(workflow.targetType)" is-active="!workflow.readOnly" class="test-target-types"><tile-header-options><badge class="target-type" ng-repeat="target in workflow.targetTypes track by target.id" ng-click="workflow.onTargetTypeSelected(target)" name="::target.name" is-selected="target.id == workflow.targetType.id" icon-class="getIconClass(target)"></badge></tile-header-options></tile-header>',controller:"TargetTypesController"}}));
"use strict";angular.module("collectionpane").controller("ErrorsController",["uiSession","$scope","localize","workflow","collectionConstants","requestIdentity",function(r,e,o,t,n,l){e.workflow=t.get(l.get(e)),r.getPartitionSocket(e).then((()=>{o(["%retry"],"collectionapi").then((r=>{e.messages=r}))})),e.getErrors=()=>{const r=e.errors||[],o=e.filter||(()=>!0);return r.filter(o)},e.getIcon=r=>({error:"cross-circle solid",warning:"alert-triangle solid",info:"information-circle"}[r]||""),e.showRetry=()=>{const r=e.getErrors();return e.allowRetry&&r.length>0&&r.some((r=>r.severity===n.severity.error))}}]);
"use strict";angular.module("collectionpane").directive("errors",(function(){return{restrict:"E",scope:{errors:"=",allowRetry:"=?",filter:"=?"},template:'<div class="errors"><div ng-repeat="error in getErrors()" class="message" ng-class="error.severity"><i class="icon" ng-class="getIcon(error.severity)"></i> <span html-content="{{error.description}}"></span></div><button class="ui compact mini button retry" ng-show="showRetry()" ng-click="workflow.reconnect()">{{ messages[\'%retry\'] }}</button></div>',controller:"ErrorsController"}}));
"use strict";angular.module("collectionpane").directive("scroller",(function(){return{restrict:"E",scope:{toBottom:"=?",elementSelector:"@"},template:'<div style="display: none;"></div>',link:function(e){let t;e.toBottom=()=>{setTimeout((()=>{t||(t=$(e.elementSelector)[0]),t&&t.scrollHeight>t.clientHeight&&(t.scrollTop=t.scrollHeight)}))}}}}));
"use strict";angular.module("collectionpane").directive("horizontalBox",(function(){return{restrict:"E",replace:!0,transclude:!0,template:'<div class="horizontal-box" ng-transclude></div>'}}));
"use strict";angular.module("collectionpane").controller("SimpleGridController",["$scope","$q","uiSession","localize",function(e,t,n,o){let l;n.getPartitionSocket(e).then((()=>{o(["%search_placeholder","%selectable_only_label","%explain_button_label"],"collectionapi").then((t=>{e.messages=t}))})),e.externalInitializationComplete=t.defer(),this.createGrid=function(){},this.refreshDataModel=function(){},this.getCurrentSelectedRow=function(){},e.showSelectableOnly=!0,e.explainButtonDisabled=!0,e.onSearchChange=()=>{this.refreshDataModel(e.getRows(),e.getColumns())},e.onShowSelectableChange=()=>{this.refreshDataModel(e.getRows(),e.getColumns())};const s=t((t=>{l=e.$watch("columns",(function(){e.columns&&!e.columns.find((e=>void 0===e.caption))&&t()}))})),i=e.$watch("rows",function(){e.externalInitializationComplete.promise.then((()=>s)).then((()=>{e.rows&&(e.simpleGrid?this.refreshDataModel(e.getRows(),e.getColumns()):this.createGrid(e.getRows(),e.getColumns()))}))}.bind(this));e.getRows=function(){const t=e.showSelectableOnly&&e.canBeSelected?e.rows.filter((t=>e.canBeSelected(t))):e.rows,n=e.searchTerm?new RegExp(e.searchTerm,"i"):void 0;return n?t.filter((t=>e.columns.some((e=>{const o=t[e.id];return o&&n.test(String(o))})))):t},e.getColumns=function(){if(e.columns)return e.processedColumns=[...e.columns],e.readOnly||e.rows.find((e=>void 0===e.checked))||e.processedColumns.unshift({id:"checked",caption:"",type:"boolean",sortable:!0}),e.processedColumns},e.onExplain=()=>{const t=this.getCurrentSelectedRow();t&&e.onExplainRow&&e.onExplainRow(t)},this.setExplainButtonState=t=>{e.explain&&e.explainButtonDisabled!==t&&(e.explainButtonDisabled=t,e.$apply())},e.$on("$destroy",(function(){l&&l(),i&&i(),e.simpleGrid&&e.simpleGrid.destroy()}))}]);
"use strict";angular.module("collectionpane").factory("datamodel",(function(){function t(t,e,i,o,s,n){this._editMode=!n,this._columns=o,this._rows=s,this._columnCount=o.length,this._rowCount=s.length,this._dataUtils=e,this._utils=i,this._sortBy=void 0,this._sortAscending=void 0,this._additionalSortingColumn=this._columns.find((t=>t.additionalSorting)),this._selectedRow=void 0,this._cellInputChangeTimeout=void 0,this._cellChecboxChangeTimeout=void 0,this._checkboxCellWidth=void 0,this._lastClickedColumnIndex=void 0,this._lastClickedColumnChanged=!0,this._onInputChangeRequestTimeout=200,this._onCheckboxChangeRequestTimeout=350,this.changed=t.create(),this.processMouseDown=t=>{if(!this.grid)return;t=t||window.event;const e=this.grid.hitTest(t),{columnObj:i}=e;if(!i)return;if(this._lastClickedColumnChanged=this._lastClickedColumnIndex!==i.dataIndex,this._lastClickedColumnIndex=i.dataIndex,!this._editMode||!this._checkboxHitInterval)return;const o=e.row;if(o>=0&&"boolean"===this._columns[this._lastClickedColumnIndex].type){const e=t.target,i=t.pageX-this._utils.getElementPos(e).x;this._checkboxHitInterval[0]<=i&&i<=this._checkboxHitInterval[1]&&this.canBeChecked(o,this._lastClickedColumnIndex)&&(e.classList.toggle("checked"),this.onCellCheckboxChange(o,this._lastClickedColumnIndex),t.stopPropagation(),t.preventDefault())}},this.processKeyDown=t=>{if(this.grid&&this._editMode)if(32===(t=t||window.event).keyCode){const e=this.grid.getCurrentRow();this.onCellCheckboxChange(e,0),this.changed.raise([{row:e,col:0}]),t.stopPropagation(),t.preventDefault()}else 38===t.keyCode||40===t.keyCode?t.preventDefault():t.ctrlKey&&65===t.keyCode&&$(t.target).is("input")&&(t.target.setSelectionRange(0,t.target.value.length),t.stopPropagation())},this.processScroll=t=>{this.grid&&"hidden"!==this.grid.scrolling.scrollBody.style.visibility&&(t.preventDefault(),t.stopPropagation())},this.onSortColumn(0)}return t.prototype.getColumnCount=function(){return this._columnCount},t.prototype.getRowCount=function(){return this._rowCount},t.prototype.getColumnWidth=function(t,e){const i=this._columns[t];return this.grid&&this._editMode&&0===t&&"boolean"===i.type?this._checkboxCellWidth:i.width?i.width:Math.round(e*(t===this._columnCount-1?5:i.widthPercentage)/100)},t.prototype.getColumnCaption=function(t,e){return this._columns[t].id===this._sortBy&&(e.sortingForward=!this._sortAscending),this._dataUtils.decorateCaption(this._columns[t].caption,e)},t.prototype.getCell=function(t,e){const i=this._columns[e],o=this._rows[t][i.id],s="boolean"===i.type,n=o&&!s?o.toString():"";if(this._editMode&&void 0!==o&&this._selectedRow===t&&i.editable&&!s&&e===this._lastClickedColumnIndex){const i=document.createElement("input");return i.className="simple_grid td_input",i.type="text",i.value=n,i.dataset.rowId=t,i.dataset.colId=e,i.addEventListener("input",this.onCellInputChange.bind(this)),setTimeout((()=>{i.setSelectionRange(0,i.value.length),i.focus()}),0),i}return n},t.prototype.getCellLayout=function(t){if(-1!==t.indexOf('class="simple_grid td_input"'))return{text:"",margin:0}},t.prototype.getCellStyle=function(t,e,i,o,s){let n=t&&this._editMode?e:i;if("boolean"===this._columns[s].type){const t=this._rows[o][this._columns[s].id];void 0!==t&&(n+=" cell_checkbox",t&&(n+=" checked"))}return this.isEnabled&&!this.isEnabled(this._rows[o])&&(n+=" disabled_row"),n},t.prototype.onSortColumn=function(t,e){this._selectedRow=void 0,this.onRowSelectionClear&&this.onRowSelectionClear();const i=this._columns[t];if(!i.sortable)return!1;const o=i.id;return o===this._sortBy?(this._sortAscending=!this._sortAscending,"checked"===o||this._additionalSortingColumn?(this.sortRowsByColumnId(o),this._sortAscending||(this._rows=this._rows.reverse())):this._rows=this._rows.reverse()):(this._sortBy=o,this._sortAscending=!(this._editMode&&0===t&&"boolean"===i.type),this.sortRowsByColumnId(o),this._sortAscending||(this._rows=this._rows.reverse())),this.changed.raise(e),this.setColumnWidth&&this.setColumnWidth(),!0},t.prototype.sortRowsByColumnId=function(t){if(!this.getRowCount())return;const e=this._columns.find((e=>e.id===t)),i=function(e){const i=h(e),o=this._additionalSortingColumn&&this._additionalSortingColumn.id!==e.id?h(this._additionalSortingColumn):void 0;return function(e,s){const n=i(e,s,t);return 0===n&&o?(this._sortAscending||([e,s]=[s,e]),o(e,s,this._additionalSortingColumn.id)):n}.bind(this)}.call(this,e);function o(t,e,i){const o=t[i].toString().toUpperCase(),s=e[i].toString().toUpperCase();return o<s?-1:o>s?1:0}function s(t,e,i){return r(t[i])-r(e[i])}function n(t,e,i){return t[i]-e[i]}function r(t){return void 0===t||""===t?0:"string"==typeof t?Number.parseInt(t)||0:t}function h(t){return"number"===t.type?s:"boolean"===t.type?n:o}this._rows=this._rows.sort(i)},t.prototype.setCurrentRow=function(t,e){if(!this._editMode)return;if(t===this._selectedRow&&!this._lastClickedColumnChanged)return;const i=[{row:t}];return void 0!==this._selectedRow&&i.push({row:this._selectedRow}),this._selectedRow=t,e.isMouse?setTimeout((()=>{this.changed.raise(i)}),0):this.changed.raise(i),this.onRowSelection&&(this.isEnabled&&!this.isEnabled(this._rows[t])||this.onRowSelection(this._rows[t])),!0},t.prototype.getCurrentRow=function(){return this._selectedRow},t.prototype.getCurrentRowValue=function(){if(void 0!==this._selectedRow)return this._rows[this._selectedRow]},t.prototype.isColumnMovable=function(){return!1},t.prototype.isColumnResizable=function(t){return!this._editMode||!(0===t&&"boolean"===this._columns[t].type)},t.prototype.beforeColumnAutoSize=function(){return!1},t.prototype.onSetColumnWidth=function(t,e){this._columns[t].width=e},t.prototype.onCellInputChange=function(t){this._cellInputChangeTimeout&&clearTimeout(this._cellInputChangeTimeout);const e=t.target,i=e.value,o=this._columns[e.dataset.colId];if("number"===o.type){if(!/^\d+$/.test(i))return void this._utils.addClass(e,"invalid");this._utils.removeClass(e,"invalid")}const s=this._rows[e.dataset.rowId];s[o.id]!==i&&(s[o.id]=i,this._cellInputChangeTimeout=setTimeout((()=>{this.onGridDataChange&&this.onGridDataChange()}),this._onInputChangeRequestTimeout))},t.prototype.onCellCheckboxChange=function(t,e){this._cellChecboxChangeTimeout&&clearTimeout(this._cellChecboxChangeTimeout);const i=this._rows[t],o=this._columns[e].id;i[o]=!i[o],this._cellChecboxChangeTimeout=setTimeout((()=>{this.onGridDataChange&&this.onGridDataChange()}),this._onCheckboxChangeRequestTimeout)},t.prototype.canBeChecked=function(t,e){const i=this._columns[e];return"boolean"===i.type&&void 0!==this._rows[t][i.id]},t.prototype.setElement=function(t){if(!(t&&this.grid||this.grid===t)&&(this.grid&&(this.grid.area.removeEventListener("mousedown",this.processMouseDown,!0),this.grid.area.removeEventListener("keydown",this.processKeyDown,!0),this.grid.area.removeEventListener("mousewheel",this.processScroll,!1),this.grid.area.removeEventListener("DOMMouseScroll",this.processScroll,!1)),this.grid=t,this.grid&&(this.grid.area.addEventListener("mousedown",this.processMouseDown,!0),this.grid.area.addEventListener("keydown",this.processKeyDown,!0),this.grid.area.addEventListener("mousewheel",this.processScroll,!1),this.grid.area.addEventListener("DOMMouseScroll",this.processScroll,!1),!this._checkboxCellWidth||!this._checkboxHitInterval))){const e=this._utils.em2px(.8,t.area);this._checkboxCellWidth=Math.round(this._utils.em2px(2,t.area));const i=(this._checkboxCellWidth-e)/2;this._checkboxHitInterval=[i,i+e]}},{create:(e,i,o,s,n,r)=>new t(e,i,o,s,n,r)}}));
"use strict";angular.module("collectionpane").directive("simpleGrid",["datamodel",function(e){return{restrict:"E",scope:{columns:"=",rows:"=",onSelect:"=?",canBeSelected:"=?",showSelectableOnlyLabel:"=?",hideSearch:"=?",readOnly:"=?",onDataChange:"=?",onExplainRow:"=?",explain:"=?"},template:'<div class="simple-grid" ng-class="{disabled: readOnly}"><div class="search ui left icon input" ng-hide="readOnly"><input type="text" placeholder="{{ messages[\'%search_placeholder\'] }}" ng-model="searchTerm" ng-change="onSearchChange()"> <i class="icon magnifier-o"></i></div><div class="explain field"><button ng-click="onExplain()" class="ui button explain_button" ng-show="!readOnly && explain" ng-disabled="explainButtonDisabled">{{messages[\'%explain_button_label\']}}</button></div><div class="ui checkbox" ng-show="showSelectableOnlyLabel.length"><input type="checkbox" ng-model="showSelectableOnly" ng-change="onShowSelectableChange()" id="input-show-selectable-only"> <label for="input-show-selectable-only">{{messages[\'%selectable_only_label\']}}</label></div><div class="simple_grid_area"><div class="simple_grid_container"></div></div></div>',controller:"SimpleGridController",link:function(t,n,i,l){require(["grid","signal","data_utils","utils"],((i,a,o,s)=>{t.parent=n.find(".simple_grid_container")[0];let r=!1;n[0].style.fontSize=`${Math.round(Number.parseFloat(getComputedStyle(n[0]).fontSize))}px`;function d(n,i){const l=e.create(a,o,s,i,n,t.readOnly);l.onRowSelection=c,l.onRowSelectionClear=p,l.isEnabled=t.canBeSelected,l.onGridDataChange=t.onDataChange,l.setColumnWidth=m,t.plainData=l}function c(e){t.onSelect&&t.onSelect(e),l.setExplainButtonState(!1)}function p(){l.setExplainButtonState(!0)}function u(){let e=3;t.rows.length>0&&(e=t.rows.length>=11?20:1.8*t.rows.length+1.5);const n=Number.parseInt(t.parent.parentNode.style.height);n&&n===e||(t.parent.parentNode.style.height=`${e}em`)}function h(){t.simpleGrid=i.create(t.parent,"0"),t.simpleGrid.gridBody.onSetColumnWidth=function(e,n){t.plainData&&t.plainData.onSetColumnWidth&&t.plainData.onSetColumnWidth(e,n)},u(),g()}function g(){t.simpleGrid&&t.plainData&&setTimeout((()=>{t.simpleGrid.setDataModel(t.plainData),m()}))}function m(){if(t.simpleGrid){const e=t.plainData.getColumnCount(),{gridBody:n}=t.simpleGrid,i=n.area.offsetWidth;for(let l=0;l<e;l++)n.setColumnWidth(l,t.plainData.getColumnWidth(l,i));n.refreshLayout({height:!0})}}t.$on("resizeGrids",(()=>{t.rows&&t.simpleGrid&&$(t.simpleGrid.gridBody.area).is(":visible")?l.refreshDataModel(t.getRows(),t.getColumns()):r&&(r=!1,h())})),l.createGrid=(e,n)=>{t.parent.innerHTML="",t.simpleGrid=void 0,n&&n.length&&(d(e,n),setTimeout((()=>{t.parent.offsetParent?h():r=!0}),0))},l.getCurrentSelectedRow=function(){if(t.simpleGrid&&t.plainData)return t.plainData.getCurrentRowValue()},l.refreshDataModel=(e,n)=>{u(),t.simpleGrid&&(d(e,n),g(),l.setExplainButtonState(!0))},l.setGridColumnsWidth=m(),t.externalInitializationComplete&&t.externalInitializationComplete.resolve()}))}}}]);
"use strict";angular.module("collectionpane").directive("tile",(function(){return{restrict:"E",transclude:!0,scope:{headline:"@",isActive:"="},template:'<div class="headline" ng-show="isActive">{{::headline}}</div><div class="body" ng-transclude></div>'}}));
"use strict";angular.module("collectionpane").directive("tileHeader",["$timeout",function(e){return{restrict:"E",transclude:{"extra-elements":"?tileHeaderExtra",options:"?tileHeaderOptions"},scope:{currentHeader:"=",currentIconClass:"=",isActive:"="},template:'<div class="tile-header" ng-class="{ opened: isOpen, inactive: !isActive }" ng-mouseenter="onEnter()"><div class="current-header" ng-click="isOpen ? onClose() : onOpen()"><div class="dropdown-trigger"><span class="icon badge-icon" ng-class="currentIconClass"></span><header ng-show="currentHeader">{{ currentHeader }}</header><span class="icon caret-down open-icon" ng-show="isActive && currentHeader"></span></div><span class="extra-elements" ng-transclude="extra-elements" ng-show="isActive"></span></div><div class="list-of-options" ng-click="onClose()" ng-transclude="options"></div></div>',link:function(n,s){const t=s.find(".list-of-options");let i;n.isOpen=!1,t.hide(),s.closest("tile").on("mouseleave",(e=>{0===$(e.relatedTarget).closest(".popup").length&&n.onLeave()})).on("mouseenter",(()=>{n.onEnter()})),n.onOpen=()=>{n.isActive&&!n.isOpen&&(e.cancel(i),t.slideDown(),n.isOpen=!0)},n.onClose=()=>{n.isOpen&&(n.isOpen=!1,t.slideUp())},n.onLeave=()=>{i=e(n.onClose,800)},n.onEnter=()=>{e.cancel(i)}}}}]);
"use strict";angular.module("collectionpane").controller("TimerController",["$scope","localize",function(e,l){l(["%ElapsedTime"],"collectionapi").then((l=>{e.messages=l}))}]);
"use strict";angular.module("collectionpane").directive("timer",(function(){return{restrict:"E",scope:{start:"="},template:'<span class="label">{{::messages[\'%ElapsedTime\']}}:</span> <span class="time">00:00:00</span>',controller:"TimerController",link:function(e,t){const n=setInterval((()=>{if(!e.start)return;const n=new Date(Date.now()-e.start);t.find(".time").text(n.toLocaleTimeString("en-GB",{timeZone:"UTC"}))}),1e3);e.$on("$destroy",(()=>{clearInterval(n)}))}}}));
"use strict";angular.module("collectionpane").controller("KnobsController",["$scope","findKnob",function(e,n){let o={};const t=e.$watch("knobs",(function(){e.knobs&&(o={},e.knobs.forEach((e=>{o[e.id]=e})))}));e.notActivated=function(e){if(e.activationRule){const{activationRule:n}=e;let t=!1;if(n.knobId&&o[n.knobId]){t=o[n.knobId].value!==n.value}else t=!n.value;return t}return!1},e.isNpuSelectedKnob=()=>n(e,"isNpuSelected"),e.isGpuSelectedKnob=()=>n(e,"isGpuSelected"),e.onOpen=()=>{e.$broadcast("resizeGrids")},e.$on("$destroy",(function(){t&&t()}))}]);
"use strict";angular.module("collectionpane").directive("knobs",["RecursiveDirectiveCompiler",function(n){return{restrict:"E",scope:{knobs:"=",readOnly:"=",onKnobChange:"="},replace:!0,controller:"KnobsController",template:'<div><div ng-repeat="knob in knobs track by $id(knob)" ng-hide="knob.visibility === false || (knob.applicableUI && knob.applicableUI !== \'gui\')" ng-switch="knob.type"><boolean-knob ng-switch-when="boolean" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></boolean-knob><int-knob ng-switch-when="int" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></int-knob><int-knob ng-switch-when="double" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></int-knob><mru-knob ng-switch-when="mru" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></mru-knob><div class="group knob" ng-switch-when="group" ng-switch="knob.knob_control_id"><div ng-switch-when="RadioButtonGroup" ng-repeat="childKnob in knob.knobs track by childKnob.id" ng-show="childKnob.visibility" ng-switch="childKnob.type"><div class="group-enum knob" ng-switch-when="enum" id="{{ childKnob.id }}"><div class="field label-only"><label class="ui" tooltip="{{childKnob.description}}">{{childKnob.name}}</label></div><div class="grouped fields"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in childKnob.items track by item.value"><div class="ui radio checkbox"><input type="radio" class="ui" tooltip="{{item.description}}" name="{{childKnob.id}}" ng-model="$parent.childKnob.value" ng-value="item.value" ng-change="onKnobChange(knob)" ng-disabled="readOnly" id="{{childKnob.id + \'-\' + $index}}"> <label for="{{childKnob.id + \'-\' + $index}}">{{item.display_value}}</label></div></div></div></div></div><advanced-hotspots-levels ng-switch-when="advancedHotspotsLevelsGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></advanced-hotspots-levels><hotspots-group ng-switch-when="hotspotsGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></hotspots-group><gpu-profiling-group ng-switch-when="gpuProfilingGroup" ng-show="::knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></gpu-profiling-group><gpu-multiadapter-group ng-switch-when="gpuMultiadapterGroup" ng-show="::knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></gpu-multiadapter-group><gpu-target-knob ng-switch-when="GpuTarget" ng-show="::knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></gpu-target-knob><xpu-target-knob ng-switch-when="XpuTarget" ng-show="::knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" is-npu-selected="isNpuSelectedKnob()" is-gpu-selected="isGpuSelectedKnob()" on-change="onKnobChange"></xpu-target-knob><collect-stacks-with-size-group ng-switch-when="collectStacksWithSizeGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></collect-stacks-with-size-group><threading-group ng-switch-when="threadingGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></threading-group><system-overview-group ng-switch-when="systemOverviewGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></system-overview-group><hotspots-advanced ng-switch-when="hotspotsAdvancedGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></hotspots-advanced><follow-child ng-switch-when="followChildGroup" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></follow-child><tracing-mode ng-switch-when="TracingMode" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></tracing-mode><analyze-kvm-guest-os ng-switch-when="KvmProfileGuest" ng-show="knob.visibility" read-only="readOnly || notActivated(knob)" knob="knob" on-change="onKnobChange"></analyze-kvm-guest-os><sniper-roi-selector ng-switch-when="SniperROISelector" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></sniper-roi-selector><div ng-switch-when="expandCollapse" class="ui styled fluid accordion advanced" on-open="onOpen"><div class="title"><i class="ui dropdown icon"></i> {{knob.description}}</div><div class="content"><knobs knobs="knob.knobs" class="ui form analysis-low-level-knobs" on-knob-change="onKnobChange" read-only="readOnly || notActivated(knob)"></knobs></div></div><agent-connection ng-switch-when="agentConnection" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></agent-connection><ssh-deploy ng-switch-when="sshDeploy"></ssh-deploy><div ng-switch-default><div class="field label-only"><label class="ui">{{knob.description}}</label></div><div class="group-knobs-indent"><knobs knobs="knob.knobs" on-knob-change="onKnobChange" read-only="readOnly"></knobs></div></div></div><div ng-switch-when="enum" ng-switch="knob.knob_control_id"><radio-group-knob ng-switch-when="radio-group" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></radio-group-knob><div ng-switch-default ng-switch="knob.id"><pmu-mode-knob ng-switch-when="pmuSamplingCountSwitch" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></pmu-mode-knob><enum-knob ng-switch-default knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></enum-knob></div></div><div ng-switch-default ng-switch="knob.knob_control_id"><div ng-switch-when="GpuMemAnalysis"><gpu-memory-analysis-knob knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></gpu-memory-analysis-knob></div><div ng-switch-when="KernelGrid"><kernel-grid-knob knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></kernel-grid-knob></div><div ng-switch-when="SWEventConfig"><software-event-knob knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></software-event-knob></div><div ng-switch-when="HWEventConfig"><hardware-event-knob knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></hardware-event-knob></div><div ng-switch-when="GpuEventConfig"><gpu-event-knob knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></gpu-event-knob></div><ssh-connection ng-switch-when="ssh-connection" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></ssh-connection><file-content-knob ng-switch-when="file-content" knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></file-content-knob><string-knob ng-switch-default knob="knob" on-change="onKnobChange" read-only="readOnly || notActivated(knob)"></string-knob></div></div></div>',compile:function(o){return n.compile(o)}}}]);
"use strict";angular.module("collectionpane").directive("agentConnectionConfiguration",(function(){return{scope:{connectionType:"<"},replace:!0,template:'<div class="agent-connection-configuration" localize="localize" default-msg-catalog="collectionpane" ng-show="::connectionType"><div class="client-server"><div class="client node selectable" ng-class="{ active: model.isSelected(model.client) }" ng-click="model.select(model.client)" id="local_agent"><i class="icon user solid"></i><div class="caption">{{::localize(\'%agentConnection.client\')}}</div><div class="details">{{::model.client.hostname}}</div><div class="details">{{::model.client.ipAddress}}</div></div><div class="server node" ng-class="{ active: model.isSelected(model.server), selectable: model.server.selectable }" ng-click="model.select(model.server)" id="{{::localHostConnectionTypeId}}"><i class="icon blade-server solid"></i><div class="caption">{{::localize(\'%agentConnection.server\')}}</div><div class="details">{{::model.server.hostname}}</div><div class="details">{{::model.server.ipAddress}}</div></div><div class="client link"></div><div class="targets horizontal link"></div><div class="targets vertical link"></div></div><div class="targets"><div class="caption">{{::localize(\'%agentConnection.targets\')}}</div><div class="link"></div><div class="list"><div ng-repeat="target in getRemoteTargets()" ng-click="model.select(target)" class="target selectable" ng-class="{ active: model.isSelected(target), connected: target.connected }" id="{{::target.id}}"><div class="server-link"></div><div class="target-link"></div><i class="icon blade-server solid"></i><div class="caption">{{target.name || target.hostname || target.ipAddress}}</div><div class="details">{{target.ipAddress}}</div></div></div></div></div>',controller:"AgentConnectionConfigurationController"}}));
"use strict";angular.module("collectionpane").controller("AgentConnectionConfigurationController",["$scope","collectionConstants","requestIdentity","workflow",function(e,o,n,t){const{LOCALHOST_CONNECTION:l}=o.connectionTypeIds;t=t.get(n.get(e)),e.model=t.agentConnection,e.getRemoteTargets=()=>[e.model.newTarget,...e.model.remoteTargets],e.localHostConnectionTypeId=l}]);
"use strict";angular.module("collectionpane").controller("AdvancedHotspotsLevelsController",["$scope","findKnob",function(l,o){const e={"hotspots-sampling":1,"stack-sampling":2,"stack-and-callcount":3,"stack-call-and-tripcount":4};function n(){l.collectionDetailLevel&&(l.overhead=e[l.collectionDetailLevel.value]||1)}l.collectionDetailLevel=o(l.knob,"collectionDetailLevel"),n(),l.onChildKnobChanged=()=>{n(),l.onChange(l.knob)}}]);
"use strict";angular.module("collectionpane").directive("advancedHotspotsLevels",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<div ng-repeat="childKnob in knob.knobs track by childKnob.id" ng-show="childKnob.visibility" ng-switch="::childKnob.type"><div class="group-enum knob" ng-switch-when="enum" id="{{ ::childKnob.id }}"><div class="field label-only"><label class="ui" tooltip="{{::childKnob.description}}">{{::childKnob.name}}</label></div><horizontal-box><div class="grouped fields"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in childKnob.items track by item.value"><div class="ui radio checkbox"><input type="radio" class="ui" tooltip="{{::item.description}}" name="{{::childKnob.id}}" ng-model="childKnob.value" ng-value="item.value" ng-change="onChildKnobChanged(knob)" ng-disabled="readOnly" id="{{::childKnob.id + \'-\' + $index}}"> <label for="{{::childKnob.id + \'-\' + $index}}">{{::item.display_value}}</label></div></div></div><div class="chart-area"><div class="chart-label">Overhead</div><overhead-bar-chart max-value="9" value="overhead * 2" tooltip="Collection overhead, trace size and finalization time."></overhead-bar-chart></div></horizontal-box></div></div>',controller:"AdvancedHotspotsLevelsController"}}));
"use strict";angular.module("collectionpane").controller("AgentConnectionController",["$scope","findKnob","requestIdentity","uiSession","workflow",function(e,n,t,o,a){const s=(a=a.get(t.get(e))).agentConnection;e.model=s,e.hostname=n(e.knob,"hostname"),e.agentUuid=n(e.knob,"uuid"),e.onNewTargetHostnameChanged=()=>{s.newTarget.update(e.hostname.value,a),e.onChange(e.hostname)},s.selectedTarget?(e.hostname.value=s.selectedTarget.ipAddress,e.agentUuid.value=s.selectedTarget.agentUuid):s.setInitialSelection(e.hostname.value)}]);
"use strict";angular.module("collectionpane").directive("agentConnection",(function(){return{scope:{knob:"<",onChange:"<",readOnly:"<?"},replace:!0,template:'<div class="agent-connection" localize="localize" default-msg-catalog="collectionpane" ng-show="::!readOnly"><string-knob knob="::hostname" on-change="::onNewTargetHostnameChanged" ng-if="model.isSelected(model.newTarget)"></string-knob><div ng-switch="model.selectedTarget.targetState"><div ng-switch-when="probingTarget"><probing-target></probing-target></div><div ng-switch-when="targetConnected"><agent-control-panel agent="model.selectedTarget" on-change="onChange"></div><div ng-switch-when="sshDeploymentAvailable"><ssh-deployment knob="knob" on-change="onChange"></div><div ng-switch-when="manualDeploymentNeeded"><manual-deployment></div></div></div>',controller:"AgentConnectionController"}}));
"use strict";angular.module("collectionpane").controller("AnalyzeKvmGuestOsKnobController",["$scope","findKnob",function(n,o){const e=n.$watch((function(){return n.knob}),t);function t(){n.analyzeKvmGuest=o(n.knob,"analyzeKvmGuest"),n.kvmGuestKallsyms=o(n.knob,"kvmGuestKallsyms"),n.kvmGuestModules=o(n.knob,"kvmGuestModules")}t(),n.$on("$destroy",(function(){e&&e()}))}]);
"use strict";angular.module("collectionpane").directive("analyzeKvmGuestOs",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="analyze-kvm-guest-os knob" id="{{ knob.id }}"><div boolean-knob knob="analyzeKvmGuest" on-change="onChange" read-only="readOnly"></div><div file-knob knob="kvmGuestKallsyms" on-change="onChange" read-only="readOnly || !analyzeKvmGuest.value"></div><div file-knob knob="kvmGuestModules" on-change="onChange" read-only="readOnly || !analyzeKvmGuest.value"></div></div>',controller:"AnalyzeKvmGuestOsKnobController"}}));
"use strict";angular.module("collectionpane").controller("CollectStacksWithSizeGroupController",["$scope","findKnob",function(e,l){e.enableStackCollect=l(e.knob,"enableStackCollect"),e.stackSizeCollect=l(e.knob,"stackSizeCollect"),e.onChildKnobChanged=l=>{e.onChange(l)}}]);
"use strict";angular.module("collectionpane").directive("collectStacksWithSizeGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<div class="collect-stacks-with-size-group"><boolean-knob knob="enableStackCollect" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><enum-knob ng-if="enableStackCollect.value" knob="stackSizeCollect" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob></div>',controller:"CollectStacksWithSizeGroupController"}}));
"use strict";angular.module("collectionpane").directive("enumKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="enum knob field ui" ng-hide="knob.visibility === false" ng-class="{disabled: readOnly}" id="{{knob.id}}" tooltip="{{knob.description}}"><label>{{knob.name}}</label><div class="ui selection dropdown" ng-model="knob.value" ng-change="onChange(knob)"><input type="hidden"> <i class="ui dropdown icon"></i><div class="default text"></div><div class="menu"><div class="item" ng-repeat="item in knob.items track by item.value" data-value="{{item.value}}">{{item.display_value}}</div></div></div></div>'}}));
"use strict";angular.module("collectionpane").directive("booleanKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="boolean knob field ui" tooltip="{{knob.description}}" ng-class="{disabled: readOnly}" id="{{knob.id}}"><div class="ui checkbox" ng-model="knob.value"><input type="{{radio ? \'radio\' : \'checkbox\'}}" ng-model="knob.value" name="{{name}}" ng-change="onChange(knob)" id="input-{{knob.id}}" ng-disabled="readOnly"> <label for="input-{{knob.id}}">{{knob.name}}</label></div></div>'}}));
"use strict";angular.module("collectionpane").controller("FileKnobController",["$scope","fileDialog",function(e,l){e.messages={mruTooltip:"Recently used values"},e.filterOutEmptyValues=e=>!!e.value,e.browse=()=>{l.showOpenDialog({dialogType:"folder"===e.type?"folder":"open",dialogTitle:e.dialogTitle,defaultFileName:e.knob.value,fileFilter:e.fileFilter,defaultPath:e.knob.value}).then((function(l){l&&l&&(e.knob.value=l,e.onChange(e.knob))}))}}]);
"use strict";angular.module("collectionpane").directive("fileKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",hideLabel:"=?",type:"@?",dialogTitle:"=?",fileFilter:"=?",localFileSystem:"=?"},replace:!0,template:'<div class="string file knob field ui" ng-class="{disabled: readOnly}" id="{{knob.id}}" tooltip="{{knob.description}}"><label ng-hide="hideLabel">{{knob.name}}</label><div class="ui action input size-watch"><input type="text" ng-model="knob.value" ng-disabled="readOnly" ng-change="onChange(knob)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }"> <button ng-click="browse()" class="ui icon button" ng-disabled="readOnly" ng-show="localFileSystem"><i class="icon folder"></i></button><div class="ui icon top right pointing dropdown button" ng-model="knob.value" ng-change="onChange(knob)" ng-if="knob.items" ng-class="{disabled: readOnly || !knob.items.length}"><i class="icon history-o"></i><div class="menu"><div class="item" ng-repeat="item in knob.items track by item.value" data-value="{{item.value}}">{{item.value}}</div></div></div></div></div>',controller:"FileKnobController"}}));
"use strict";angular.module("collectionpane").directive("fileContentKnob",(function(){return{scope:{knob:"<",onChange:"<",readOnly:"<?"},replace:!0,template:'<div class="file-content knob field ui" ng-class="{disabled: readOnly}" id="{{knob.id}}" tooltip="{{knob.description}}" localize="localize" default-msg-catalog="collectionpane"><label ng-hide="hideLabel">{{knob.name}}</label> <input ng-hide="canShowContent()" type="file"> <textarea ng-show="canShowContent()" ng-model="knob.value" ng-change="onChange(knob)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" rows="5"></textarea> <button ng-show="canShowContent()" ng-click="clear()">{{::localize(\'%clear\')}}</button></div>',link:function(n,e){n.canShowContent=()=>n.knob.value&&!n.knob.sensitive,n.clear=()=>{n.knob.value="",n.onChange(n.knob),e.children("input").val("")},e.children("input").change((function(){const[e]=this.files;n.filename=e.name,n.error=!1;const o=new FileReader;o.readAsText(e),o.onload=e=>{n.knob.value=e.target.result,n.knob.sensitive||n.onChange(n.knob)},o.onerror=()=>{n.error=!0}}))}}}));
"use strict";angular.module("collectionpane").controller("FollowChildKnobController",["$scope","findKnob","uiSession","localize",function(e,l,o,n){const a=e.$watch((function(){return e.knob}),s);let t;function s(){var o;e.followChild=l(e.knob,"followChild"),e.followChildStrategy=l(e.knob,"followChildStrategy"),e.processes=(o=e.followChildStrategy.value)?o.split(",").map((e=>{const l=e.split(":");return{name:l[0],analyzeSelf:"trace"===l[1],analyzeChildren:"trace"===l[2]}})):[],0===e.processes.length?e.processes.push({name:"",default:!0,analyzeSelf:!0,analyzeChildren:!0}):(e.processes[0].name="",e.processes[0].default=!0),t=r()}function c(){return e.processes.filter((e=>e!==t)).map((e=>e.name+":"+(e.analyzeSelf?"trace":"notrace")+":"+(e.analyzeChildren?"trace":"notrace"))).join(",")}function r(){const l={name:"",analyzeSelf:!0,analyzeChildren:!0};return e.processes.push(l),l}s(),o.getPartitionSocket(e).then((()=>{n(["%follow_child.process_name_column","%follow_child.process_config_column","%follow_child.default_process","%follow_child.process_name_placeholder","%follow_child.analyze_self","%follow_child.analyze_children"],"collectionapi").then((l=>{e.messages=l}))})),e.remove=function(l){l!==t&&(e.processes.splice(e.processes.indexOf(l),1),e.followChildStrategy.value=c(),e.onChange(e.followChildStrategy))},e.save=function(){!t.name&&t.analyzeSelf&&t.analyzeChildren||(t=r()),e.followChildStrategy.value=c(),e.onChange(e.followChildStrategy)},e.$on("$destroy",(function(){a&&a()}))}]);
"use strict";angular.module("collectionpane").directive("followChild",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="follow-child knob" id="{{ knob.id }}"><div class="ui form"><div boolean-knob knob="followChild" on-change="onChange" read-only="readOnly"></div><div class="table-knob-container"><table class="processes ui celled very compact unstackable table" ng-disabled="readOnly || !followChild.value"><thead><tr><th><div class="field"><label class="caption">{{ messages[\'%follow_child.process_name_column\'] }}</label></div></th><th><div class="field"><label class="caption">{{ messages[\'%follow_child.process_config_column\'] }}</label></div></th></tr></thead><tr></tr><tr ng-repeat="process in processes"><td class="process-name"><div class="ui fluid transparent icon input" ng-if="!process.default"><input ng-model="process.name" checked="" ng-change="save()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-disabled="readOnly  || !followChild.value" type="text" placeholder="{{messages[\'%follow_child.process_name_placeholder\']}}"> <i class="icon trash link" ng-click="remove(process)" ng-hide="process.default || $last || readOnly || !followChild.value"></i></div><div ng-if="process.default">{{ messages[\'%follow_child.default_process\'] }}</div></td><td class="analysis-configuration"><div class="ui checkbox" ng-hide="$last"><input type="checkbox" ng-model="process.analyzeSelf" ng-change="save()" ng-disabled="readOnly  || !followChild.value"> <label>{{ messages[\'%follow_child.analyze_self\'] }}</label></div><div class="ui checkbox" ng-hide="$last"><input type="checkbox" ng-model="process.analyzeChildren" ng-change="save()" ng-disabled="readOnly  || !followChild.value"> <label>{{ messages[\'%follow_child.analyze_children\'] }}</label></div></td></tr></table></div></div></div>',controller:"FollowChildKnobController"}}));
"use strict";angular.module("collectionpane").controller("GpuEventConfigKnobController",["$q","$scope","GpuEvent","$http","workflow","error","uiSession","localize","requestIdentity","collectionConstants",function(e,n,t,o,i,a,r,c,d,l){n.workflow=i.get(d.get(n)),r.getPartitionSocket(n).then((()=>{c(["%event_grid.bdf","%event_grid.event_name","%event_grid.description"],"collectionapi").then((e=>{n.messages=e,n.columns=[{id:"bdf",caption:e["%event_grid.bdf"],sortable:!0,additionalSorting:!0,widthPercentage:35},{id:"event_name",caption:e["%event_grid.event_name"],sortable:!0,additionalSorting:!0,widthPercentage:35},{id:"event_description",caption:e["%event_grid.description"]}]}))})),n.onGpuEventDataChange=function(){n.knob.value=function(e){const n=[];return e.forEach((e=>{e.checked&&n.push(e.encode())})),n.join()}(n.rows),n.onChange(n.knob)};const s=n.$watch((function(){return n.knob}));(n.workflow.initMode===l.initModes.VIEWING_MODE?e.resolve([]):o.get("api/collection/configuration/traceEventTableList",{params:{knobId:n.knob.id,identity:d.get(n),analysisType:n.workflow.analysisType.id}}).then(a.validateResponse).then((e=>e.events)).catch(a.handle)).then((e=>{n.rows=function(e,o){const i=e?e.split(",").map((e=>t.create({eventToEncode:e,allEvents:o}))):[];return!n.readOnly&&o&&o.length&&o.forEach((e=>{e.checked||i.push(t.create({eventToEncode:e}))})),i}(n.knob.value,e)})),n.$on("$destroy",(function(){s&&s()}))}]);
"use strict";angular.module("collectionpane").directive("gpuEventKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="gpu-event-config-knob knob"><div class="field" ng-class="{disabled: readOnly}"><label>{{knob.name}}</label></div><simple-grid columns="columns" rows="rows" read-only="readOnly" on-data-change="onGpuEventDataChange"></simple-grid></div>',controller:"GpuEventConfigKnobController"}}));
"use strict";angular.module("collectionpane").factory("GpuEvent",(function(){const t=":bdf=";function e(t={}){this._name=void 0,this._bdf=void 0,this._alias=void 0,this.decode(t.eventToEncode,t.allEvents)}return Object.defineProperty(e.prototype,"bdf",{get:function(){return this._bdf}}),Object.defineProperty(e.prototype,"event_name",{get:function(){return`${this._alias}${this._name?` (${this._name})`:""}`}}),Object.defineProperty(e.prototype,"event_description",{get:function(){return this._description}}),e.prototype.decode=function(e,i){if("string"==typeof e){let n=e.indexOf(t),s=5;if(-1===n&&(n=e.indexOf(":"),s=1,-1===n))return!1;this._name=e.substring(0,n),this._bdf=e.substring(n+s);const o=(i||[]).find((t=>t.name===this._name&&t.bdf===this._bdf&&(t.checked=!0,!0)));o&&(this._description=o.description,this._alias=o.alias),this.checked=!0}else this._bdf=e.bdf,this._name=e.name,this._description=e.description,this._alias=e.alias,this.checked=!1},e.prototype.encode=function(){return this._name+t+this._bdf},{create:t=>new e(t)}}));
"use strict";angular.module("collectionpane").controller("GpuMemoryAnalysisKnobController",["$scope","$http","error","requestIdentity","statistics","workflow",function(e,t,s,a,n,o){e.filtering="0.1",e.kernels="",e.enqueues="",e.reportDir="",e.analysisActive=!1,e.statusError=!1,e.analysisStatus=0,e.reportFile="",e.statusMessage=[],e.consoleCommand="";let l=null,r=0;function i(){window.clearInterval(l)}e.launch=()=>{e.error=!1,e.workflow=o.get(a.get(e)),e.statusError=!1,e.analysisStatus=1,e.statusMessage=[],e.reportFile="",function(){const n=e.workflow.targetTypeDetails.panels[0].knobs,o={application:n[1].value,appParameters:n[2].value,filtering:e.filtering};if(n[3].value){const e=Math.max(n[1].value.lastIndexOf("/"),n[1].value.lastIndexOf("\\"))+1;o.workDir=n[1].value.substr(0,e)}else o.workDir=n[4].value;""!==e.enqueues&&(o.enqueues=e.enqueues.split(","));""!==e.kernels&&(o.kernels=e.kernels.split(","));const u=e.workflow.targetTypeDetails.advancedPanels[0].knobs[0].value;""!==u&&(o.envVars=u.split("\n"));""!==e.reportDir&&(o.reportDir=e.reportDir);return t.post("/api/gma/prepare",o,{params:{identity:a.get(e)}}).catch(s.logAndIgnore).finally(),function(){l=window.setInterval((()=>{t.post("/api/gma/status",{},{params:{identity:a.get(e)}}).then((t=>{const{data:s}=t;if(e.analysisStatus=s.status,s.message&&s.message.length){e.statusMessage=[];const t=s.message.slice(1,s.message.length);for(let s=0;s<t.length;s++)e.statusMessage.push({id:s,message:t[s]})}"5"===s.status&&(e.reportFile=s.message[s.message.length-1],i()),"-1"===s.status?(e.statusError=!0,r++):r=0,r>30&&(e.statusMessage.push({id:"e",message:"Error during status check"}),i())}),(()=>{}))}),1e3)}(),t.post("/api/gma/launch",o)}().then((()=>{}),(t=>{!0===t.data.gmaError&&(i(),e.statusError=!0,e.analysisStatus=-1)})).then((()=>n.notifyFeatureUsage("run.%%GpuMemAnalysisPreviewAtypeName"))).catch(s.logAndIgnore).finally()},e.getConsoleCommand=()=>{e.workflow=o.get(a.get(e));const t=e.workflow.targetTypeDetails.panels[0].knobs;e.consoleCommand="$VTUNE_PROFILER_2021_DIR/bin64/gma/MAAT/MAAT",t[3].value||(e.consoleCommand+=" -w "+t[4].value),""!==e.reportDir&&(e.consoleCommand+=" -f "+e.reportDir);const s=e.workflow.targetTypeDetails.advancedPanels[0].knobs[0].value;if(""!==s){const t=s.split("\n");for(let s=0;s<t.length;s++)e.consoleCommand+=" -E "+t[s]}if("0.1"!==e.filtering&&(e.consoleCommand+=" -l "+e.filtering),""!==e.kernels){const t=e.kernels.split(",");for(let s=0;s<t.length;s++)e.consoleCommand+=" -k "+t[s]}if(""!==e.enqueues){const t=e.enqueues.split(",");for(let s=0;s<t.length;s++)e.consoleCommand+=" -e "+t[s]}return e.consoleCommand+=" -- ",e.consoleCommand+=t[1].value+" ",e.consoleCommand+=t[2].value,e.consoleCommand},e.download=()=>{t.get("api/gma/download").then((e=>{const t=new Blob([e.data],{type:"application/pdf"}),s=window.URL||window.webkikURL,a=s.createObjectURL(t),n=document.createElement("a");n.href=a,n.download="memory_access_analysis_report.html",n.target="_self",n.click(),n.remove(),s.revokeObjectURL(a)}))},e.fixFilteringAndSave=()=>{e.filtering=Number(e.filtering)||0,e.filtering<0&&(e.filtering=0),e.filtering>100&&(e.filtering=100)}}]);
"use strict";angular.module("collectionpane").directive("gpuMemoryAnalysisKnob",(function(){return{scope:{knob:"="},replace:!0,template:'<div class="gpu-memory-analysis-knob knob" id="{{ knob.id }}" localize="localize" default-msg-catalog="collectionapi"><div class="ui"><label>{{::localize(\'%gma.label.compile\')}}</label><br><br></div><div class="ui field"><label>{{::localize(\'%gma.configure.kernel\')}}</label> <input type="text" ng-model="kernels"></div><div class="ui field"><label>{{::localize(\'%gma.configure.enqueue\')}}</label> <input type="text" ng-model="enqueues"></div><div class="ui field"><label>{{::localize(\'%gma.configure.filtering\')}}</label> <input type="text" ng-model-options="{}" ng-model="filtering" ng-blur="fixFilteringAndSave()"></div><div class="ui field"><label>{{::localize(\'%gma.configure.workdir\')}}</label> <input type="text" ng-model="reportDir"></div><div class="ui field"><label><i class="command-line icon"></i> {{::localize(\'%gma.label.commandLine\')}}</label> <input type="text" ng-readonly="true" ng-value="getConsoleCommand()"></div><div class="ui"><label>{{::localize(\'%gma.label.click\')}}</label><br><br><button ng-disabled="analysisStatus > 0 && analysisStatus < 5 " class="ui button primary" ng-click="launch()"><i class="icon play"></i> {{::localize(\'%gma.button.launch\')}}</button><br><br><label>{{::localize(\'%gma.label.tworun\')}}</label><br><br></div><div ng-if="statusError">{{::localize(\'%gma.label.analysiserror\')}}</div><div class="ui field" ng-if="statusMessage.length > 0"><br><label>{{::localize(\'%gma.label.console\')}}</label><table><tr ng-repeat="msg in statusMessage"><td><pre style="margin: 0em 0px;">{{msg.message}}</pre></td></tr></table></div><div class="ui field" ng-if="analysisStatus == 5"><br><br><label>{{::localize(\'%gma.label.resultsready\')}}</label> <input type="text" ng-readonly="true" ng-model="reportFile"> <a class="ui button" href="#" ng-click="download()">{{::localize(\'%gma.label.download\')}}</a></div></div>',controller:"GpuMemoryAnalysisKnobController"}}));
"use strict";angular.module("collectionpane").controller("GpuMultiadapterGroupController",["$scope","findKnob","localize",function(e,a,o){e.groupKnob=a(e.knob,"groupForGPUCustomCollection");const t={gpuAdapterNames:a(e.knob,"gpuAdapterNames"),collectGpuOpenCl:a(e.knob,"collectGpuOpenCl"),gpuHWProfiling:a(e.knob,"gpuHWProfiling"),gpuProfilingMode:a(e.knob,"gpuProfilingMode"),gpuCounters:a(e.knob,"gpuCounters"),gpuSamplingInterval:a(e.knob,"gpuSamplingInterval")},u=",";let l,n=[];const p=e=>e.split(u).reduce(((e,a)=>{const[o,t]=a.split("|");return void 0!==t&&e.set(o,t),e}),new Map),r=e=>e.split(u).reduce(((e,a)=>{const[o,t]=a.split("|");return void 0!==t&&(e.push({value:o,display_value:t}),n.push(t)),e}),[]),i={bool:e=>({values:p(e.value),defaultValues:p(e.defaultValue)}),int:e=>({values:p(e.value),defaultValues:p(e.defaultValue),aux:{min:e.min,max:e.max}}),enum:e=>{const a=p(e.value),o=p(e.defaultValue);let t,l;return e.items?t=r(e.items):(t={},c.forEach(((a,o)=>{const u=e["items_"+o];u&&(t[o]=r(u))}))),e.description?l=e.description:(l={},c.forEach(((a,o)=>{const t=e["description_"+o];t&&(l[o]=t.split(u)),n=n.concat(l[o])}))),{values:a,defaultValues:o,aux:t,description:l}}},s=e=>{const a={id:"gpuCollectForAdapter"+e,gpuId:e,name:"gpuCollectForAdapter",value:!1,defaultValue:!1,description:"%GpuCollectForAdapterDescription"};return n.push(a.description),a},d=(e,a,o)=>{const t=i[o](a),u=void 0===t.values.get(e),l={id:a.id+e,gpuId:e,propertyName:a.id,name:a.name,changedToDefaultOnInit:u,value:u?t.defaultValues.get(e):t.values.get(e),defaultValue:t.defaultValues.get(e),description:a.description};for(const e in t.aux)l[e]=t.aux[e];switch(o){case"enum":Array.isArray(t.aux)?l.items=t.aux:l.items=t.aux[e],t.description&&(l.description=t.description[e]?t.description[e]:t.description);break;case"bool":l.value="true"===l.value,l.defaultValue="true"===l.defaultValue;break;case"int":l.value=parseFloat(l.value),l.defaultValue=parseFloat(l.defaultValue),l.min&&(l.min=parseFloat(l.min)),l.max&&(l.max=parseFloat(l.max))}return l},c=t.gpuAdapterNames.notPersistedValue?p(t.gpuAdapterNames.notPersistedValue):p(t.gpuAdapterNames.value);e.gpuAdapters=[];const g=e=>e.value!==e.defaultValue,f=e=>e.propertyName,m=a=>{const o=[];e.gpuAdapters.forEach((e=>{e[a].value!==e[a].defaultValue&&o.push([e.gpuId,e[a].value].join("|"))})),t[a].value=o.join(u)};e.onChildKnobChanged=a=>{var o,u;"gpuCollectForAdapter"===a.name&&!1===a.value?(o=a.gpuId,u=a.propertyName,e.gpuAdapters.forEach((e=>{if(e.gpuId===o)for(const a in e)a!==u&&f(e[a])&&(e[a].value=e[a].defaultValue)})),e.gpuAdapters.forEach((a=>{for(const o in a)f(a[o])&&(m(o),e.onChange(t[a[o].propertyName]))}))):f(a)&&(m(a.propertyName),e.onChange(t[a.propertyName]))},c.forEach(((a,o)=>{const u={gpuId:o,name:a,gpuCollectForAdapter:s(o),collectGpuOpenCl:d(o,t.collectGpuOpenCl,"bool"),gpuProfilingMode:d(o,t.gpuProfilingMode,"enum"),gpuCounters:d(o,t.gpuCounters,"enum"),gpuSamplingInterval:d(o,t.gpuSamplingInterval,"int")};t.gpuHWProfiling&&(u.gpuHWProfiling=d(o,t.gpuHWProfiling,"bool")),(g(u.collectGpuOpenCl)||u.gpuHWProfiling&&g(u.gpuHWProfiling)||g(u.gpuProfilingMode)||g(u.gpuCounters))&&(u.gpuCollectForAdapter.value=!0),e.gpuAdapters.push(u)})),o(n,"collectionpane").then((a=>{l=a,e.gpuAdapters.forEach((e=>{for(const a in e){const o=e[a];o&&o.items&&o.items.forEach((e=>{e.display_value in l&&(e.display_value=l[e.display_value])})),"gpuCollectForAdapter"===o.name&&o.description in l&&(o.description=l[o.description]),Array.isArray(o.description)&&(o.description.forEach(((e,a)=>{e in l&&(o.description[a]=l[e])})),o.description=o.description.join(" "))}})),e.gpuAdapters.forEach((a=>{for(const o in a){const t=a[o];f(t)&&t.changedToDefaultOnInit&&e.onChildKnobChanged(t)}}))}))}]);
"use strict";angular.module("collectionpane").directive("gpuMultiadapterGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<horizontal-box localize="localize" default-msg-catalog="collectionpane"><div class="gpu-multiadapter group-enum knob" ng-attr-id="{{ ::groupKnob.id }}"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in gpuAdapters track by item.gpuCollectForAdapter.id" ng-attr-id="{{ ::gpuAdapters.id }}"><div class="ui checkbox"><input type="checkbox" class="ui" name="::item.gpuCollectForAdapter.name" ng-model="gpuAdapters[$index].gpuCollectForAdapter.value" ng-value="item.gpuCollectForAdapter.value" ng-change="onChildKnobChanged(gpuAdapters[$index].gpuCollectForAdapter)" ng-disabled="readOnly" ng-attr-id="{{::groupKnob.id + \'-\' + $index}}"> <label for="{{::groupKnob.id + \'-\' + $index}}" tooltip="{{::localize(gpuAdapters[$index].gpuCollectForAdapter.description)}}">{{::gpuAdapters[$index].gpuId}} {{::gpuAdapters[$index].name}}</label></div><div class="details"><enum-knob knob="gpuAdapters[$index].gpuCounters" ng-if="item.gpuCollectForAdapter.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob><int-knob knob="gpuAdapters[$index].gpuSamplingInterval" ng-if="item.gpuCollectForAdapter.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></int-knob><boolean-knob knob="gpuAdapters[$index].collectGpuOpenCl" ng-if="item.gpuCollectForAdapter.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><boolean-knob knob="gpuAdapters[$index].gpuHWProfiling" ng-if="gpuAdapters[$index].gpuHWProfiling && item.gpuCollectForAdapter.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><enum-knob knob="gpuAdapters[$index].gpuProfilingMode" ng-if="item.gpuCollectForAdapter.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob></div></div></div></horizontal-box>',controller:"GpuMultiadapterGroupController"}}));
"use strict";angular.module("collectionpane").controller("GpuProfilingGroupController",["$scope","findKnob",function(e,o){function l(){e.overhead=0,"characterization"===e.gpuProfilingMode.value?"overview"===e.metricsGroup.value||"global-memory-accesses"===e.metricsGroup.value||"lsc-slm"===e.metricsGroup.value||"hdc"===e.metricsGroup.value||"compute-extended"===e.metricsGroup.value||"full-compute"===e.metricsGroup.value?(e.overhead=1,!0===e.gpuOpenCLCollection.value&&(e.overhead+=1)):"instruction-count"===e.metricsGroup.value&&(e.overhead=6):"source-analysis"===e.gpuProfilingMode.value&&("bb-latency"===e.profilingModes.value?e.overhead=5:"mem-latency"===e.profilingModes.value?e.overhead=4:"stall-sampling"===e.profilingModes.value&&(e.overhead=2))}e.gpuProfilingMode=o(e.knob,"gpuProfilingModeAtk"),e.metricsGroup=o(e.knob,"metricsGroup"),e.profilingModes=o(e.knob,"profilingMode"),e.gpuOpenCLCollection=o(e.knob,"gpuOpenCLCollection"),e.collectMemoryBW=o(e.knob,"collectMemoryBW"),e.gpuSamplingInterval=o(e.knob,"gpuSamplingInterval"),e.kernelsToProfileAtk=o(e.knob,"kernelsToProfileAtk"),e.analyzePowerUsage=o(e.knob,"analyzePowerUsage"),e.stallReasonsSamplingInterval=o(e.knob,"stallReasonsSamplingInterval"),e.gpuProfilingModeDescriptions=[e.metricsGroup.description,e.profilingModes.description],l(),e.onChildKnobChanged=o=>{e.onChange(o),l()}}]);
"use strict";angular.module("collectionpane").directive("gpuProfilingGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<horizontal-box><div class="gpu-profiling-mode group-enum knob" ng-attr-id="{{ ::gpuProfilingMode.id }}"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in gpuProfilingMode.items track by item.value" ng-attr-id="{{ ::gpuProfilingMode.id }}"><div class="ui radio checkbox"><input type="radio" class="ui" name="{{::gpuProfilingMode.id}}" ng-model="gpuProfilingMode.value" ng-value="item.value" ng-change="onChildKnobChanged(gpuProfilingMode)" ng-disabled="readOnly" ng-attr-id="{{::gpuProfilingMode.id + \'-\' + $index}}"> <label for="{{::gpuProfilingMode.id + \'-\' + $index}}" tooltip="{{gpuProfilingModeDescriptions[$index]}}">{{::item.display_value}} <span class="icon help-circle"></span></label></div><div class="details"><enum-knob knob="metricsGroup" ng-if="$index === 0 && gpuProfilingMode.value === item.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob><enum-knob knob="profilingModes" ng-if="$index === 1 && gpuProfilingMode.value === item.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob><int-knob knob="gpuSamplingInterval" ng-if="$index === 0 && gpuProfilingMode.value === item.value && metricsGroup.value !== \'instruction-count\'" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></int-knob><boolean-knob knob="collectMemoryBW" ng-if="$index === 0 && gpuProfilingMode.value === item.value && metricsGroup.value !== \'instruction-count\'" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><boolean-knob knob="gpuOpenCLCollection" ng-if="$index === 0 && gpuProfilingMode.value === item.value && !((gpuProfilingMode.value === \'characterization\' && metricsGroup.value === \'instruction-count\') || gpuProfilingMode.value === \'source-analysis\')" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><boolean-knob knob="analyzePowerUsage" ng-if="!!analyzePowerUsage && $index === 0 && gpuProfilingMode.value === item.value && gpuProfilingMode.value === \'characterization\'" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><int-knob knob="stallReasonsSamplingInterval" ng-if="$index === 1 && gpuProfilingMode.value === item.value && gpuProfilingMode.value === \'source-analysis\' && profilingModes.value == \'stall-sampling\'" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></int-knob></div><div class="details2"><kernel-grid-knob knob="kernelsToProfileAtk" ng-if="$index === 1 && (gpuOpenCLCollection.value || (gpuProfilingMode.value === \'characterization\' && metricsGroup.value === \'instruction-count\') || gpuProfilingMode.value === \'source-analysis\')" allow-empty-value="true" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></div></div></div><overhead-bar-chart localize="localize" default-msg-catalog="collectionpane" max-value="7" value="overhead" title-text="::localize(\'%knob.gpuProfilingGroup.chartLabel\')" tooltip="{{::localize(\'%knob.gpuProfilingGroup.chartTooltip\')}}"></overhead-bar-chart></horizontal-box>',controller:"GpuProfilingGroupController"}}));
"use strict";angular.module("collectionpane").controller("GpuTargetController",["$scope","findKnob","uiSession","localize","deviceTargetUtil",function(e,t,l,o,a){const p={gpuAdapterTileNames:t(e.knob,"gpuAdapterTileNames")};l.getPartitionSocket(e).then((()=>{o("%GPUTile","collectionpane").then((t=>{e.tileName=t}))}));const u=t(e.knob,"targetGPUAtk"),{groupDelimiter:r,tileDelimiter:d}=a.consts,n=e=>a.unpackKnobValueToMap(e),s=u.notPersistedValue?n(u.notPersistedValue):n(u.value),i=(e,t)=>a.createXpuCollectForAdapterAuxKnob(s,e,t),c=(g=p.gpuAdapterTileNames.value,a.unpackXpuTileAllValuesStr(g));var g;e.gpuAdapters=[];const h=e=>!0===e.gpuCollectForAdapter.value,A=()=>{const t=[],l=[];e.gpuAdapters.forEach((e=>{e.gpuCollectForAdapter.disabled=!1,e.gpuCollectForAdapter.value&&t.push(e),e.tiles.forEach((e=>{e.gpuCollectForAdapter.disabled=!1,e.gpuCollectForAdapter.value&&l.push(e)}))})),1===t.length&&(t[0].gpuCollectForAdapter.disabled=!0),1===l.length&&(l[0].gpuCollectForAdapter.disabled=!0)};e.onChildKnobChanged=t=>{if("gpuCollectForAdapter"===t.name){e.gpuAdapters.find((({gpuId:e})=>e===t.gpuId)).tiles.forEach((e=>{e.gpuCollectForAdapter.value=t.value}))}else{const l=e.gpuAdapters.find((({gpuId:e})=>e===t.gpuId));l.gpuCollectForAdapter.value=void 0!==l.tiles.find(h)}A(),(()=>{const t=[];e.gpuAdapters.forEach((e=>{const l=[];e.tiles.forEach((e=>{e.gpuCollectForAdapter.value&&l.push(e.tileId)})),0===e.tiles.length?e.gpuCollectForAdapter.value&&t.push([e.gpuId]):l.length===e.tiles.length?t.push(e.gpuId):l.forEach((l=>{t.push([e.gpuId,l].join(d))}))})),u.value=t.join(r)})(),e.onChange()},c.forEach(((t,l)=>{const o=[];t.tiles.length>1&&t.tiles.forEach((e=>{const t={gpuId:l,tileId:e,gpuCollectForAdapter:i(l,e)};o.push(t)}));const a={gpuId:l,name:t.name,tiles:o,gpuCollectForAdapter:i(l,void 0)};e.gpuAdapters.push(a),A()}))}]);
"use strict";angular.module("collectionpane").directive("gpuTargetKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="gpu-target-knob knob" id="{{ knob.id }}"><div class="ui styled accordion"><div class="title">{{knob.name}} <i class="chevron-right icon"></i></div><div class="content"><div class="description">{{knob.description}}</div><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="adapter in gpuAdapters track by adapter.gpuCollectForAdapter.id" ng-attr-id="{{ ::gpuAdapters.id }}"><div class="ui checkbox"><input type="checkbox" class="ui" name="::item.gpuCollectForAdapter.name" ng-model="adapter.gpuCollectForAdapter.value" ng-value="adapter.gpuCollectForAdapter.value" ng-change="onChildKnobChanged(adapter.gpuCollectForAdapter)" ng-disabled="readOnly || adapter.gpuCollectForAdapter.disabled" ng-attr-id="{{::knob.id + \'-\' + $index}}"> <label for="{{::knob.id + \'-\' + $index}}">{{::adapter.gpuId}} {{::adapter.name}}</label></div><div class="tiles" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="tile in adapter.tiles track by tile.gpuCollectForAdapter.id"><div class="ui checkbox"><input type="checkbox" class="ui" name="::item.gpuCollectForAdapter.name" ng-model="tile.gpuCollectForAdapter.value" ng-value="tile.gpuCollectForAdapter.value" ng-change="onChildKnobChanged(tile.gpuCollectForAdapter)" ng-disabled="readOnly || tile.gpuCollectForAdapter.disabled" ng-attr-id="{{::knob.id + \'-\' + $index + \'-\' + tile.tileId}}"> <label for="{{::knob.id + \'-\' + $index + \'-\' + tile.tileId}}">{{tileName + \' \' + tile.tileId}}</label></div></div></div></div></div></div>',controller:"GpuTargetController"}}));
"use strict";angular.module("collectionpane").controller("HardwareEventConfigKnobController",["$q","$scope","HardwareEvent","$http","workflow","error","uiSession","localize","requestIdentity","productHelp","collectionConstants",function(e,n,t,o,i,r,a,c,l,s,d){n.workflow=i.get(l.get(n));const p=e.defer();let u,f,v;a.getPartitionSocket(n).then((()=>{c(["%event_grid.event_name","%event_grid.description","%hardware_event_grid.sample_after","%hardware_event_grid.precise"],"collectionapi").then((e=>{n.messages=e,u=[{id:"event_name",caption:e["%event_grid.event_name"],sortable:!0,additionalSorting:!0,widthPercentage:35},{id:"sample_after_value",caption:e["%hardware_event_grid.sample_after"],sortable:!0,editable:!0,type:"number",widthPercentage:15},{id:"event_precision",caption:e["%hardware_event_grid.precise"],editable:!0,type:"boolean",widthPercentage:5},{id:"event_description",caption:e["%event_grid.description"]}],p.resolve()}))})),n.onHWEventDataChange=function(){n.knob.value=function(e){const n=[];return e.forEach((e=>{e.checked&&n.push(e.encode())})),n.join()}(n.rows),n.onChange(n.knob)},n.explainEvent=function(e){let n=e.event_name;n=n.replace(new RegExp("request=","g"),"request:"),n=n.replace(new RegExp("response=","g"),"response:");const t=`#pltfrm=${v.replace("crystalwell","haswell")}.html&pltfrmevent=${n}`;s.explainHWEvent(t)};const h=n.$watch((function(){return n.knob}),(function(){return function(){if(n.workflow.initMode===d.initModes.VIEWING_MODE)return e.resolve([]);return o.get("api/collection/configuration/hardwareEventList",{params:{knobId:n.knob.id,identity:l.get(n),analysisType:n.workflow.analysisType.id,connectionType:n.workflow.connectionType.id}}).then(r.validateResponse).then((e=>e.events))}().then((e=>{f=e})).then((function(){return o.get("api/collection/configuration/hardwareEventTableInfo",{params:{knobId:n.knob.id,identity:l.get(n),connectionType:n.workflow.connectionType.id}})})).then(r.validateResponse).then((e=>{v=e.sepCpuInfoId,n.cpuInfo=e.sepCpuInfoLabel,n.adjustInfo=e.sepAdjustInfoLabel})).catch(r.handle).finally((()=>{const e=function(e,o){const i=e?e.split(",").map((e=>t.create({eventToEncode:e,allEvents:o}))):[];return!n.readOnly&&o&&o.length&&o.forEach((e=>{e.checked||i.push(t.create({eventToEncode:e}))})),i}(n.knob.value,f);return p.promise.then((()=>{var t;if(n.columns=(t=u,JSON.parse(JSON.stringify(t))),!e.find((e=>void 0!==e.event_precision))){const e=n.columns.findIndex((e=>"event_precision"===e.id));e&&n.columns.splice(e,1)}})).finally((()=>{n.rows=e}))}))}));n.$on("$destroy",(function(){h&&h()}))}]);
"use strict";angular.module("collectionpane").directive("hardwareEventKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="hardware-event-config-knob knob" id="{{ knob.id }}"><div class="description field" ng-class="{disabled: readOnly}"><p>{{cpuInfo}}</p><p>{{adjustInfo}}</p></div><simple-grid columns="columns" rows="rows" read-only="readOnly" on-data-change="onHWEventDataChange" on-explain-row="explainEvent" explain="true"></simple-grid></div>',controller:"HardwareEventConfigKnobController"}}));
"use strict";angular.module("collectionpane").factory("HardwareEvent",(function(){const e=":",t="precise";function i(e={}){this.decode(e.eventToEncode,e.allEvents)}function n(e){return void 0!==e?"yes"===e:void 0}function o(e){return void 0===e?void 0:e?"yes":"no"}return Object.defineProperty(i.prototype,"event_name",{get:function(){return this._name}}),Object.defineProperty(i.prototype,"sample_after_value",{get:function(){return this.modifiers.sa},set:function(e){this.modifiers.sa=e}}),Object.defineProperty(i.prototype,"event_description",{get:function(){return this._description}}),Object.defineProperty(i.prototype,"event_precision",{get:function(){return this.modifiers.precise},set:function(e){this.modifiers.precise=void 0===e?void 0:!!e}}),i.prototype.decode=function(i,o){if("string"==typeof i){Object.assign(this,function(i){const o={modifiers:{}},s=i.match(/^.*:request=.*:response=[^:]*/);s&&s.length?(o._name=s[0],i=i.slice(o._name.length).split(e)):(i=i.split(e),o._name=i.shift());return i.forEach((e=>{const i=e.split("="),[s,r]=i;let c;c="sa"===s?Number.parseInt(r):s===t?n(r):r,o.modifiers[`${s}`]=c})),o}(i));const s=(o||[]).find((e=>e.name===this._name&&(e.checked=!0,!0)));s&&(this._description=s.description,(s.modifiers||[]).forEach((e=>{this.modifiers[`${e.name}`]=e.name===t?n(e.value):e.value}))),this.checked=!0}else this._name=i.name,this._description=i.description,this.modifiers={},(i.modifiers||[]).forEach((e=>{this.modifiers[`${e.name}`]=e.name===t?n(e.value):e.value})),this.checked=!1},i.prototype.encode=function(){let i="";for(const n in this.modifiers)if(void 0!==this.modifiers[n]){const s=n===t?o(this.modifiers[n]):this.modifiers[n];i+=`${e}${n}=${s}`}else i+=`${e}${n}`;return`${this._name}${i}`},{create:e=>new i(e)}}));
"use strict";angular.module("collectionpane").controller("HotspotsAdvancedController",["$scope","findKnob",function(n,e){const o=n.$watch((function(){return n.knob}),l);function l(){n.enableStackCollectKnob=e(n.knob,"enableStackCollect"),n.enableWaitTimeCSKnob=e(n.knob,"enableWaitTimeCS"),n.enableCallAndTripCountsKnob=e(n.knob,"enableCallAndTripCounts")}function a(){n.overhead=1+(n.enableStackCollectKnob.value?1:0)+(n.enableWaitTimeCSKnob.value?1:0)+(n.enableCallAndTripCountsKnob.value?1:0)}l(),a(),n.onChildKnobChanged=()=>{a(),n.onChange(n.knob)},n.$on("$destroy",(function(){o&&o()}))}]);
"use strict";angular.module("collectionpane").directive("hotspotsAdvanced",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<div class="knob ui styled fluid accordion advanced" id="{{ knob.id }}"><div class="title"><i class="ui dropdown icon"></i> {{knob.description}}</div><div class="content"><horizontal-box><knobs knobs="knob.knobs" class="ui form" on-knob-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></knobs><overhead-bar-chart max-value="9" value="overhead * 2"></overhead-bar-chart></horizontal-box></div></div>',controller:"HotspotsAdvancedController"}}));
"use strict";angular.module("collectionpane").controller("HotspotsGroupController",["$scope","findKnob",function(e,l){function o(){if("sw"===e.samplingMode.value)e.overhead=4;else{let l=3;e.enableStackCollect.value&&(l+=2),e.samplingInterval.value<.1?l+=4:e.samplingInterval.value<1?l+=2:e.samplingInterval.value>1&&l--,e.overhead=l}}e.samplingMode=l(e.knob,"samplingMode"),e.samplingInterval=l(e.knob,"samplingInterval"),e.enableStackCollect=l(e.knob,"enableStackCollect"),e.stackSizeCollect=l(e.knob,"stackSizeCollect"),e.samplingModeDescriptions=["%knob.hotspotsGroup.samplingModeDescription.SW","%knob.hotspotsGroup.samplingModeDescription.HW"],o(),e.onChildKnobChanged=l=>{e.onChange(l),o()}}]);
"use strict";angular.module("collectionpane").directive("hotspotsGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<horizontal-box localize="localize" default-msg-catalog="collectionapi" data-tour-item="hotspotsModesTourItem"><div class="sampling-mode group-enum knob" ng-attr-id="{{ ::samplingMode.id }}"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in samplingMode.items track by item.value" ng-attr-id="{{ ::samplingMode.id }}"><div class="ui radio checkbox"><input type="radio" class="ui" name="{{::samplingMode.id}}" ng-model="samplingMode.value" ng-value="item.value" ng-change="onChildKnobChanged(samplingMode)" ng-disabled="readOnly" ng-attr-id="{{::samplingMode.id + \'-\' + $index}}"> <label for="{{::samplingMode.id + \'-\' + $index}}" tooltip="{{::localize(samplingModeDescriptions[$index])}}">{{::item.display_value}} <span class="icon help-circle"></span></label></div><div class="details" ng-if="$index === 1 && samplingMode.value === item.value"><int-knob knob="samplingInterval" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></int-knob><boolean-knob knob="enableStackCollect" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><enum-knob knob="stackSizeCollect" ng-if="enableStackCollect.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob></div></div></div><overhead-bar-chart max-value="9" value="overhead" title-text="::localize(\'%knob.hotspotsGroup.chartLabel\')" tooltip="{{::localize(\'%knob.hotspotsGroup.chartTooltip\')}}"></overhead-bar-chart></horizontal-box>',controller:"HotspotsGroupController"}}));
"use strict";angular.module("collectionpane").controller("IntKnobController",["$scope","$timeout",function(e,n){let o;function r(){n.cancel(o),o=void 0,e.onChange(e.knob)}e.validateAndSave=()=>{n.cancel(o);const a=Number(e.knob.value);e.error=!Number.isFinite(a)||a<e.knob.min||a>e.knob.max,e.error||(o=n(r,1e3))},e.fixAndSave=()=>{if(o)r();else if(e.error){e.error=!1;const{knob:n}=e;n.value=Number(n.value)||n.min||0,n.value<n.min&&(n.value=n.min),n.value>n.max&&(n.value=n.max),r()}}}]);
"use strict";angular.module("collectionpane").directive("intKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",hideLabel:"=?",unitOfMeasure:"=?"},replace:!0,controller:"IntKnobController",template:'<div class="int knob field ui" tooltip="{{knob.description}}" ng-class="{disabled: readOnly, error: error}" id="{{ knob.id }}"><label ng-hide="hideLabel">{{knob.name}}</label><div class="ui input" ng-class="{\'right labeled\': unitOfMeasure}"><input type="text" ng-model="knob.value" ng-change="validateAndSave()" ng-blur="fixAndSave()" ng-disabled="readOnly"><div ng-if="unitOfMeasure" class="ui label">{{unitOfMeasure}}</div></div></div>'}}));
"use strict";angular.module("collectionpane").controller("KernelGridKnobController",["$scope","uiSession","localize","GpuKernel","stateMachine","requestIdentity","collectionConstants",function(e,l,n,o,t,a,r){e.stateMachine=t.get(a.get(e)),e.allowEmptyValue=!0,l.getPartitionSocket(e).then((()=>{n(["%kernel_grid.kernel_name_column","%kernel_grid.kernel_instance_step_column","%kernel_grid.kernel_placeholder","%kernel_grid.default_step"],"collectionapi").then((l=>{e.messages=l}))})),e.remove=function(l){e.rows.splice(e.rows.indexOf(l),1),e.save()},e.save=function(){let l=e.rows.every((e=>e.validate()));!e.allowEmptyValue&&1===e.rows.length&&e.rows[0].isPlaceholder()&&(l=!1),l?(e.knob.value=e.rows.map((e=>e.encode())).filter((e=>e)).join(","),e.onChange(e.knob),function(){const l=e.rows.length;0!==l&&e.rows[l-1].isPlaceholder()||(e.rows.push(new o({placeholder:!0,allowEmptyValue:e.allowEmptyValue})),e.save())}()):e.stateMachine.setValidationState(r.validationStates.invalid)};const s=e.$watch((function(){return e.knob}),i);function i(){var l;(e.rows=[],e.knob)&&(e.rows=(l=e.knob.value)?l.split(",").map((l=>new o({stringToEncode:l,allowEmptyValue:e.allowEmptyValue}))):[],e.readOnly||e.rows.push(new o({placeholder:!0,allowEmptyValue:e.allowEmptyValue})))}i(),e.$on("$destroy",(function(){s&&s()}))}]);
"use strict";angular.module("collectionpane").directive("kernelGridKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",allowEmptyValue:"=?"},replace:!0,template:'<div class="kernel-grid-knob knob" id="{{ knob.id }}"><div class="ui form field" ng-class="{ disabled: readOnly }"><div class="table-knob-container"><table class="ui celled very compact unstackable table" ng-show="!readOnly || (readOnly && rows.length)" ng-disabled="readOnly"><thead><tr><th ng-class="{error: (rows.length === 1 && !readOnly && !allowEmptyValue)}"><div class="kernel-name"><label class="caption">{{ messages[\'%kernel_grid.kernel_name_column\'] }}</label></div></th><th ng-class="{error: (rows.length === 1 && !readOnly && !allowEmptyValue)}"><div><label class="caption">{{ messages[\'%kernel_grid.kernel_instance_step_column\'] }}</label></div></th></tr></thead><tr ng-repeat="kernel in rows" ng-class="{error: !readOnly && (!kernel.validate() || (rows.length === 1 && !allowEmptyValue))}"><td class="kernel-name"><div class="ui fluid transparent icon input"><input ng-model="kernel.name" ng-change="save(kernel)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-disabled="readOnly" type="text" placeholder="{{ messages[\'%kernel_grid.kernel_placeholder\'] }}"></div></td><td><div class="ui fluid transparent icon input"><input ng-model="kernel.step" ng-change="save(kernel)" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-disabled="readOnly" type="text" placeholder="{{ defaultStep + messages[\'%kernel_grid.default_step\'] }}"> <i class="icon trash link" ng-click="remove(kernel)" ng-hide="kernel.default || $last || readOnly"></i></div></td></tr></table></div></div></div>',controller:"KernelGridKnobController"}}));
"use strict";angular.module("collectionpane").factory("GpuKernel",(function(){function t(t={}){const{stringToEncode:e}=t;this._name={value:""},this._start={value:this.DEFAULT_START},this._step={value:this.DEFAULT_STEP,repr:""},this._end={value:this.INSTANCE_MAX},this._isPlaceholder=!!t.placeholder,this._allowEmptyValue=!!t.allowEmptyValue,e&&this.decode(e)}return t.prototype.INVALID_INSTANCE_MAX=-1,t.prototype.SEPARATOR="#",t.prototype.DEFAULT_START=1,t.prototype.DEFAULT_STEP=1,t.prototype.INSTANCE_MAX=Math.pow(2,32)-1,t.prototype.encode=function(){return!this.isPlaceholder()&&this.validate()?[this._name.value,this._start.value,this._step.value,this._end.value].join(this.SEPARATOR):""},Object.defineProperty(t.prototype,"name",{get:function(){return this._name.value},set:function(t){this._isPlaceholder=!1,this._name.value=t}}),Object.defineProperty(t.prototype,"step",{get:function(){return this._step.repr},set:function(t){""!==t?(this._step.value=t,this._step.repr=t):(this._step.value=this.DEFAULT_STEP,this._step.repr=""),this._end.value=this.INSTANCE_MAX,this._isPlaceholder=!1}}),t.prototype.decode=function(t){const e=t.split(this.SEPARATOR);this.name=e[0],this._start.value=e[1]||this.DEFAULT_START,this.step=e[2]||this.DEFAULT_STEP,this._end.value=e[3]||this.INSTANCE_MAX},t.prototype.isPlaceholder=function(){return this._isPlaceholder},t.prototype.validateName=function(t){return t.match(/^[a-zA-Z_]+[a-zA-Z0-9$_@:<>\*]*$|^\*$/)||this.isPlaceholder()&&!t.trim()},t.prototype.validateStep=function(t){return(t=t.toString()).match(/^[0-9]+$/)?(t=parseInt(t))>0&&t+this._start.value<this.INSTANCE_MAX:!t.trim()},t.prototype.validate=function(){return this.validateStep(this._step.value)&&this.validateName(this._name.value)&&this._step.value!==this.INVALID_INSTANCE_MAX},t}));
"use strict";angular.module("collectionpane").controller("MruKnobController",["$scope",function(e){e.messages={mruTooltip:"Recently used values"},e.getModelOptions=function(){return"ssh.host"===e.knob.id?{updateOn:"blur",debounce:{blur:0}}:{updateOn:"default blur",debounce:{default:1e3,blur:0}}}}]);
"use strict";angular.module("collectionpane").directive("mruKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",hideLabel:"=?"},replace:!0,template:'<div class="mru knob field ui" tooltip="{{knob.description}}" ng-class="{disabled: readOnly}" id="{{knob.id}}"><label ng-hide="hideLabel">{{knob.name}}</label><div class="ui action input size-watch"><input type="text" ng-model="knob.value" ng-change="onChange(knob)" ng-disabled="readOnly" ng-model-options="getModelOptions()" placeholder="{{::knob.placeholder}}"><div class="ui icon top right pointing dropdown button" ng-model="knob.value" ng-change="onChange(knob)" ng-class="{disabled: readOnly || !knob.items || !knob.items.length}"><i class="icon history-o"></i><div class="menu"><div class="item" ng-repeat="item in knob.items track by item.value" data-value="{{item.value}}">{{item.value}}</div></div></div></div></div>',controller:"MruKnobController"}}));
"use strict";angular.module("collectionpane").directive("pmuModeKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="enum knob field ui" ng-class="{disabled: readOnly}" id="{{::knob.id}}" tooltip="{{::knob.description}}"><label>{{::knob.name}}</label><div class="ui selection dropdown" ng-model="knob.value" ng-change="onChange(knob)"><input type="hidden"> <i class="ui dropdown icon"></i><div class="default text"></div><div class="menu"><div class="item" ng-repeat="item in knob.items track by item.value" data-value="{{item.value}}">{{::item.display_value}}</div></div></div></div>'}}));
"use strict";angular.module("collectionpane").directive("radioGroupKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="radio-group knob" ng-class="{disabled: readOnly}" id="{{knob.id}}" tooltip="{{knob.description}}"><div class="field label-only" ng-if="::knob.name"><label class="ui" tooltip="{{::knob.description}}">{{::knob.name}}</label></div><div class="fields" ng-class="::{inline: !knob.name}"><div class="field" ng-class="{disabled: readOnly}" ng-repeat="item in ::knob.items track by item.value"><div class="ui radio checkbox"><input type="radio" class="ui" tooltip="{{::item.description}}" name="{{::knob.id}}" ng-model="$parent.knob.value" ng-value="item.value" ng-change="onChange(knob)" ng-disabled="readOnly" id="{{::knob.id + \'-\' + $index}}"> <label for="{{::knob.id + \'-\' + $index}}">{{::item.display_value}}</label></div></div></div></div>'}}));
"use strict";angular.module("collectionpane").controller("SniperRoiSelectorController",["$scope","findKnob","uiSession","localize","$q",function(e,n,t,s,o){e.types={roiFunctions:"roi-funcitons",sscMarks:"ssc",useFunction:"function"};const i=o.defer();t.getPartitionSocket(e).then((()=>{s(["%roiFunctions","%roiFunctionsDescription","%sscMarks","%sscMarksDescription","%useFunction","%useFunctionDescription","%startSSCMark","%endSSCMark","%selectROI"],"collectionapi").then((n=>{e.messages=n})).then((()=>i.resolve()))}));const a=e.$watch((function(){return e.knob}),r);function r(){e.sniperROISelector=n(e.knob,"sniperROISelector"),function(){const n=e.sniperROISelector.value.split(":"),t=n[0]||e.types.roiFunctions;let s,o,a;const r=new RegExp("^[0-9a-f]+$","i");t===e.types.sscMarks?(s=n[1],o=n[2]):t===e.types.useFunciton&&(a=n[1]);e.type={id:"1",value:t},e.startSSCMark={id:"2",value:s,pattern:r},e.endSSCMark={id:"3",value:o,pattern:r},e.functionName={id:"4",value:a},i.promise.then((()=>{e.startSSCMark.name=e.messages["%startSSCMark"],e.endSSCMark.name=e.messages["%endSSCMark"]}))}()}r(),e.onChangeInternal=n=>{e.type.value!==e.types.useFunction||n===e.functionName||e.functionName.value||4===n.id||(e.functionName.value="main"),function(){e.sniperROISelector.value=e.type.value,e.type.value===e.types.sscMarks?e.sniperROISelector.value+=":"+(e.startSSCMark.value||"")+":"+(e.endSSCMark.value||""):e.type.value===e.types.useFunction&&(e.sniperROISelector.value+=":"+e.functionName.value);e.onChange(e.sniperROISelector)}()},e.$on("$destroy",(function(){a&&a()}))}]);
"use strict";angular.module("collectionpane").directive("sniperRoiSelector",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="sniper-roi-selector knob" id="{{ knob.id }}"><div class="field"><label>{{messages[\'%selectROI\']}}</label></div><div class="inline fields"><div class="option"><div radio-knob knob="type" caption="messages[\'%roiFunctions\']" description="messages[\'%roiFunctionsDescription\']" value="types.roiFunctions" on-change="onChangeInternal" read-only="readOnly"></div></div></div><div class="inline fields"><div class="option"><div radio-knob knob="type" caption="messages[\'%sscMarks\']" description="messages[\'%sscMarksDescription\']" value="types.sscMarks" on-change="onChangeInternal" read-only="readOnly"></div></div><div class="value"><div string-knob knob="startSSCMark" error="type.value === types.sscMarks && !startSSCMark.value" on-change="onChangeInternal" read-only="readOnly || type.value !== types.sscMarks"></div></div><div class="value"><div string-knob knob="endSSCMark" error="type.value === types.sscMarks && !endSSCMark.value" on-change="onChangeInternal" read-only="readOnly || type.value !== types.sscMarks"></div></div></div><div class="inline fields"><div class="option"><div radio-knob knob="type" caption="messages[\'%useFunction\']" description="messages[\'%useFunctionDescription\']" value="types.useFunction" on-change="onChangeInternal" read-only="readOnly"></div></div><div class="value"><div string-knob knob="functionName" error="type.value === types.useFunction && !functionName.value" on-change="onChangeInternal" read-only="readOnly || type.value !== types.useFunction"></div></div></div></div>',controller:"SniperRoiSelectorController"}}));
"use strict";angular.module("collectionpane").controller("SoftwareEventConfigKnobController",["$q","$scope","SoftwareEvent","$http","workflow","error","uiSession","localize","requestIdentity","collectionConstants",function(e,n,t,o,i,a,c,r,s,l){n.workflow=i.get(s.get(n)),c.getPartitionSocket(n).then((()=>{r(["%event_grid.event_name","%event_grid.description"],"collectionapi").then((e=>{n.messages=e,n.columns=[{id:"event_name",caption:e["%event_grid.event_name"],sortable:!0,additionalSorting:!0,widthPercentage:35},{id:"event_description",caption:e["%event_grid.description"]}]}))})),n.onSWEventDataChange=function(){n.knob.value=function(e){const n=[];return e.forEach((e=>{e.checked&&n.push(e.encode())})),n.join()}(n.rows),n.onChange(n.knob)};const d=n.$watch((function(){return n.knob}));(n.workflow.initMode===l.initModes.VIEWING_MODE?e.resolve([]):o.get("api/collection/configuration/traceEventTableList",{params:{knobId:n.knob.id,identity:s.get(n),analysisType:n.workflow.analysisType.id}}).then(a.validateResponse).then((e=>e.events)).catch(a.handle)).then((e=>{n.rows=function(e,o){const i=e?e.split(",").map((e=>t.create({eventToEncode:e,allEvents:o}))):[];return!n.readOnly&&o&&o.length&&o.forEach((e=>{e.checked||i.push(t.create({eventToEncode:e}))})),i}(n.knob.value,e)})),n.$on("$destroy",(function(){d&&d()}))}]);
"use strict";angular.module("collectionpane").directive("softwareEventKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="software-event-config-knob knob"><div class="field" ng-class="{disabled: readOnly}"><label>{{knob.name}}</label></div><simple-grid columns="columns" rows="rows" read-only="readOnly" on-data-change="onSWEventDataChange"></simple-grid></div>',controller:"SoftwareEventConfigKnobController"}}));
"use strict";angular.module("collectionpane").factory("SoftwareEvent",(function(){function e(e={}){this._name=void 0,this._alias=void 0,this.decode(e.eventToEncode,e.allEvents)}return Object.defineProperty(e.prototype,"event_name",{get:function(){return`${this._alias}${this._name?` (${this._name})`:""}`}}),Object.defineProperty(e.prototype,"event_description",{get:function(){return this._description}}),e.prototype.decode=function(e,t){if("string"==typeof e){this._name=e;const i=(t||[]).find((e=>e.name===this._name&&(e.checked=!0,!0)));i&&(this._description=i.description,this._alias=i.alias),this.checked=!0}else this._name=e.name,this._description=e.description,this._alias=e.alias,this.checked=!1},e.prototype.encode=function(){return this._name},{create:t=>new e(t)}}));
"use strict";angular.module("collectionpane").directive("radioKnob",(function(){return{scope:{knob:"=",caption:"=",value:"=",description:"=?",onChange:"=?",readOnly:"=?"},replace:!0,template:'<div class="boolean knob field ui" tooltip="{{description}}" ng-class="{disabled: readOnly}" id="{{ knob.id }}"><div class="ui radio checkbox"><input type="radio" ng-model="knob.value" ng-value="value" name="{{knob.id}}" ng-change="onChange(knob)" id="input-{{knob.id}}" ng-disabled="readOnly"> <label for="input-{{knob.id}}-{{value}}">{{caption}}</label></div></div>'}}));
"use strict";angular.module("collectionpane").controller("SshConnectionController",["$scope","findKnob",function(e,o){e.username=o(e.knob,"username"),e.port=o(e.knob,"port"),e.authType=o(e.knob,"auth-type"),e.privateKey=o(e.knob,"private-key"),e.privateKeyPassphrase=o(e.knob,"private-key-passphrase"),e.password=o(e.knob,"password")}]);
"use strict";angular.module("collectionpane").directive("sshConnection",(function(){return{restrict:"E",scope:{knob:"<",onChange:"<",readOnly:"<?"},template:'<div><div class="equal width fields"><string-knob knob="username" on-change="onChange" read-only="readOnly"></string-knob><string-knob knob="port" on-change="onChange" read-only="readOnly"></string-knob></div><radio-group-knob knob="authType" on-change="onChange" read-only="readOnly"></radio-group-knob><file-content-knob ng-show="authType.value === \'public-key\'" knob="privateKey" on-change="onChange" read-only="readOnly"></file-content-knob><string-knob ng-show="authType.value === \'public-key\'" knob="privateKeyPassphrase" on-change="onChange" read-only="readOnly"></string-knob><string-knob ng-show="authType.value === \'password\'" knob="password" on-change="onChange" read-only="readOnly"></string-knob></div>',controller:"SshConnectionController"}}));
"use strict";angular.module("collectionpane").controller("SshDeployController",["uiSession","$scope","paneApi","workflow","collectionConstants","requestIdentity","Tracker",function(e,o,r,t,n,s,l){t=t.get(s.get(o)),o.showSshDeploy=()=>t.errors&&t.errors.length>0&&t.errors.some((e=>e.severity===n.severity.error&&(e.type===n.errorTypes.connection||e.type===n.errorTypes.targetSession)));const i=r.get(s.get(o));o.deploying=new l,o.deploy=()=>o.deploying.start().then(i.sshDeploy).then(t.reconnect).finally(o.deploying.stop)}]);
"use strict";angular.module("collectionpane").directive("sshDeploy",(function(){return{restrict:"E",template:'<div class="ssh-deploy" ng-if="showSshDeploy()" localize="localize" default-msg-catalog="collectionpane"><p ng-hide="deploying.isInProgress()">{{::localize(\'%sshDeploy.description\')}}</p><div class="progress-message" ng-if="deploying.isInProgress()"><i class="icon circle-third spin"></i> {{::localize(\'%sshDeploy.inProgress\')}}</div><button class="ui primary button" ng-click="deploy()">{{::localize(\'%sshDeploy.deploy\')}}</button></div>',controller:"SshDeployController"}}));
"use strict";angular.module("collectionpane").controller("StringKnobController",["$scope",function(n){n.type=!0===n.knob.sensitive?"password":"text",n.onChangeInternal=e=>{e.sensitive||n.onChange(e)}}]);
"use strict";angular.module("collectionpane").directive("stringKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",hideLabel:"=?",pattern:"=?",error:"=?"},replace:!0,template:'<div class="string knob field ui" tooltip="{{knob.description}}" ng-class="{disabled: readOnly, error: error}" id="{{knob.id}}"><label ng-hide="hideLabel">{{knob.name}}</label><div class="ui input"><input type="{{::type}}" ng-model="knob.value" ng-change="onChangeInternal(knob)" ng-disabled="readOnly" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-pattern="knob.pattern"></div></div>',controller:"StringKnobController"}}));
"use strict";angular.module("collectionpane").controller("SystemOverviewGroupController",["$scope","findKnob",function(n,o){n.collectingMode=o(n.knob,"collectingMode"),n.samplingInterval=o(n.knob,"samplingInterval"),n.onChildKnobChanged=o=>{n.onChange(o)}}]);
"use strict";angular.module("collectionpane").directive("systemOverviewGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<horizontal-box localize="localize" default-msg-catalog="collectionapi"><div class="collecting-mode group-enum knob" ng-attr-id="{{ ::collectingMode.id }}"><div class="field" ng-class="{disabled: readOnly}" ng-repeat="item in collectingMode.items track by item.value" ng-attr-id="{{ ::collectingMode.id }}"><div class="ui radio checkbox"><input type="radio" class="ui" name="{{::collectingMode.id}}" ng-model="collectingMode.value" ng-value="item.value" ng-change="onChildKnobChanged(collectingMode)" ng-disabled="readOnly" ng-attr-id="{{::collectingMode.id + \'-\' + $index}}"> <label for="{{::collectingMode.id + \'-\' + $index}}" tooltip="{{::localize(\'%knob.systemOverviewGroup.collectingModeDescription.\' + item.value)}}">{{::item.display_value}} <span class="icon help-circle"></span></label></div><div class="details" ng-if="item.value === \'hwSampling\' && collectingMode.value === item.value"><int-knob knob="samplingInterval" on-change="onChildKnobChanged" read-only="readOnly"></int-knob></div></div></div></horizontal-box>',controller:"SystemOverviewGroupController"}}));
"use strict";angular.module("collectionpane").controller("ThreadingGroupController",["$scope","findKnob",function(n,e){function l(){if("sw"===n.samplingAndWaits.value)n.overhead=7;else{let e;e=n.samplingInterval.value<.1?9:n.samplingInterval.value<1?7:n.samplingInterval.value>1?4:5,n.overhead=e}}n.samplingAndWaits=e(n.knob,"samplingAndWaits"),n.samplingInterval=e(n.knob,"samplingInterval"),n.samplingModeDescriptions=["%knob.threadingGroup.samplingModeDescription.SW","%knob.threadingGroup.samplingModeDescription.HW"],n.stackSizeCollect=e(n.knob,"stackSizeCollect"),n.enableStackCollect=e(n.knob,"enableStackCollect"),l(),n.onChildKnobChanged=e=>{n.onChange(e),l()}}]);
"use strict";angular.module("collectionpane").directive("threadingGroup",(function(){return{restrict:"E",scope:{knob:"=",onChange:"=",readOnly:"=?"},template:'<horizontal-box localize="localize" default-msg-catalog="collectionapi"><div class="sampling-mode group-enum knob" ng-attr-id="{{ ::samplingAndWaits.id }}"><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="item in samplingAndWaits.items track by item.value" ng-attr-id="{{ ::samplingAndWaits.id }}"><div class="ui radio checkbox"><input type="radio" class="ui" name="{{::samplingAndWaits.id}}" ng-model="samplingAndWaits.value" ng-value="item.value" ng-change="onChildKnobChanged(samplingAndWaits)" ng-disabled="readOnly" ng-attr-id="{{::samplingAndWaits.id + \'-\' + $index}}"> <label for="{{::samplingAndWaits.id + \'-\' + $index}}" tooltip="{{::localize(samplingModeDescriptions[$index])}}">{{::item.display_value}} <span class="icon help-circle"></span></label></div><div class="details" ng-if="$index === 1 && samplingAndWaits.value === item.value"><int-knob knob="samplingInterval" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></int-knob><boolean-knob knob="enableStackCollect" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></boolean-knob><enum-knob knob="stackSizeCollect" ng-if="enableStackCollect.value" on-change="onChildKnobChanged" read-only="readOnly || notActivated(knob)"></enum-knob></div></div></div><overhead-bar-chart max-value="9" value="overhead" title-text="::localize(\'%knob.hotspotsGroup.chartLabel\')" tooltip="{{::localize(\'%knob.hotspotsGroup.chartTooltip\')}}"></overhead-bar-chart></horizontal-box>',controller:"ThreadingGroupController"}}));
"use strict";angular.module("collectionpane").controller("TracingModeKnobController",["$scope","uiSession","localize","findKnob",function(e,n,a,i){let t=1e3,f=!1;n.getPartitionSocket(e).then((()=>{a(["%tracing_mode.max_value"],"collectionapi").then((n=>{e.messages=n}))}));const o=e.$watch((function(){return e.knob}),u);function u(){e.enableRingBuffer=i(e.knob,"enableRing"),e.dataLimit=i(e.knob,"dataLimit"),f||(f=!0,t=e.dataLimit.value),e.targetRingBuffer=i(e.knob,"targetRingBuffer"),e.disableRingBuffer=!e.enableRingBuffer.value}u(),e.onEnableRingBuffer=function(){e.dataLimit.value=t,e.disableRingBuffer=!e.enableRingBuffer.value,e.onChange(e.dataLimit),e.onChange(e.enableRingBuffer)},e.onDisableRingBuffer=function(){e.targetRingBuffer.value=0,e.enableRingBuffer.value=!e.disableRingBuffer,e.onChange(e.targetRingBuffer),e.onChange(e.enableRingBuffer)},e.$on("$destroy",(function(){o&&o()}))}]);
"use strict";angular.module("collectionpane").directive("tracingMode",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?"},replace:!0,template:'<div class="tracing-mode knob" id="{{ knob.id }}"><div class="field label-only" ng-class="{disabled: readOnly}"><label>Limit collected data by:</label></div><div class="inline fields"><div class="option"><div class="field" ng-class="{disabled: readOnly}"><div class="ui radio checkbox" tooltip="{{targetRingBuffer.description}}"><input type="checkbox" ng-model="enableRingBuffer.value" ng-change="onEnableRingBuffer()" ng-disabled="readOnly" id="tracing-mode-enable-ring-buffer"> <label for="tracing-mode-enable-ring-buffer">{{targetRingBuffer.name}}</label></div></div></div><div class="value"><div int-knob class="ui" tooltip="{{messages[\'%tracing_mode.max_value\'] + targetRingBuffer.max}}" hide-label="true" knob="targetRingBuffer" on-change="onChange" read-only="readOnly || !enableRingBuffer.value"></div></div></div><div class="inline fields"><div class="option"><div class="field" ng-class="{disabled: readOnly}"><div class="ui radio checkbox" tooltip="{{dataLimit.description}}"><input type="checkbox" ng-model="disableRingBuffer" ng-change="onDisableRingBuffer()" ng-disabled="readOnly" id="tracing-mode-disable-ring-buffer"> <label for="tracing-mode-disable-ring-buffer">{{dataLimit.name}}</label></div></div></div><div class="value"><div int-knob class="tracing-mode ui" tooltip="{{messages[\'%tracing_mode.max_value\'] + dataLimit.max}}" hide-label="true" knob="dataLimit" on-change="onChange" read-only="readOnly || enableRingBuffer.value"></div></div></div></div>',controller:"TracingModeKnobController"}}));
"use strict";angular.module("collectionpane").controller("XpuTargetController",["$scope","findKnob","uiSession","localize","deviceTargetUtil",function(e,l,t,a,p){const{groupDelimiter:o,tileDelimiter:u,GPU:r,NPU:n,XPU_MODE:d}=p.consts,{GPU_ADAPTERS_KNOB_ID:s,NPU_ADAPTERS_KNOB_ID:i}=p.consts,c={gpuAdapterTileNames:l(e.knob,s),npuAdapterTileNames:l(e.knob,i)};t.getPartitionSocket(e).then((()=>{a("%GPUTile","collectionpane").then((l=>{e.tileName=l}))}));const A=l(e.knob,"targetGPUAtk"),{isNpuSelected:x,isGpuSelected:h}=e,v=e=>p.unpackKnobValueToMap(e),g=A.notPersistedValue?A.notPersistedValue:A.value,C=x.value&&c.npuAdapterTileNames?c.npuAdapterTileNames.value:"",m=v(g),T=v(C),f=new Map([...m,...T]),F=(e,l)=>p.createXpuCollectForAdapterAuxKnob(f,e,l,d),N=c.gpuAdapterTileNames?c.gpuAdapterTileNames.value:"",I=c.npuAdapterTileNames?c.npuAdapterTileNames.value:"",P=(b=N+o+I,p.unpackXpuTileAllValuesStr(b));var b;e.xpuAdapters=[];const E=e=>!0===e.xpuCollectForAdapter.value,U=()=>{const l=[],t=[];e.xpuAdapters.forEach((e=>{e.xpuCollectForAdapter.disabled=!1,e.xpuCollectForAdapter.value&&l.push(e),e.tiles.forEach((e=>{e.xpuCollectForAdapter.disabled=!1,e.xpuCollectForAdapter.value&&t.push(e)}))})),1===l.length&&(l[0].xpuCollectForAdapter.disabled=!0),1===t.length&&(t[0].xpuCollectForAdapter.disabled=!0)};e.onChildKnobChanged=l=>{if("xpuCollectForAdapter"===l.name){e.xpuAdapters.find((({xpuId:e})=>e===l.xpuId)).tiles.forEach((e=>{e.xpuCollectForAdapter.value=l.value}))}else{const t=e.xpuAdapters.find((({xpuId:e})=>e===l.xpuId));t.xpuCollectForAdapter.value=void 0!==t.tiles.find(E)}U(),(()=>{if(void 0===A||void 0===h||void 0===x)return;const l=[],t=[];e.xpuAdapters.forEach((e=>{const a=e.tiles.filter((e=>e.xpuCollectForAdapter.value)).map((e=>e.tileId)),p=e.type===n?t:l;0===e.tiles.length?e.xpuCollectForAdapter.value&&p.push([e.xpuId]):a.length===e.tiles.length?p.push(e.xpuId):a.forEach((l=>{p.push([e.xpuId,l].join(u))}))})),h.value=l.length>0,h.value?A.value=l.join(o):A.value="none",x.value=t.length>0})(),e.onChange()},P.forEach(((l,t)=>{const a=[];l.tiles.length>1&&l.tiles.forEach((e=>{const l={xpuId:t,tileId:e,xpuCollectForAdapter:F(t,e)};a.push(l)}));const p=c.npuAdapterTileNames.value.includes(l.name)?n:r,o={xpuId:t,name:l.name,tiles:a,type:p,xpuCollectForAdapter:F(t)};e.xpuAdapters.push(o),U()}))}]);
"use strict";angular.module("collectionpane").directive("xpuTargetKnob",(function(){return{scope:{knob:"=",onChange:"=",readOnly:"=?",isGpuSelected:"=",isNpuSelected:"="},replace:!0,template:'<div class="xpu-target-knob knob" id="{{ knob.id }}"><div class="ui styled accordion"><div class="title">{{knob.name}} <i class="chevron-right icon"></i></div><div class="content"><div class="description">{{knob.description}}</div><div class="field" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="adapter in xpuAdapters track by adapter.xpuCollectForAdapter.id" ng-attr-id="{{ ::xpuAdapters.id }}"><div class="ui checkbox"><input type="checkbox" class="ui" name="::item.xpuCollectForAdapter.name" ng-model="adapter.xpuCollectForAdapter.value" ng-value="adapter.xpuCollectForAdapter.value" ng-change="onChildKnobChanged(adapter.xpuCollectForAdapter)" ng-disabled="readOnly || adapter.xpuCollectForAdapter.disabled" ng-attr-id="{{::knob.id + \'-\' + $index}}"> <label for="{{::knob.id + \'-\' + $index}}">{{::adapter.xpuId}} {{::adapter.name}}</label></div><div class="tiles" ng-class="{disabled: readOnly || notActivated(knob)}" ng-repeat="tile in adapter.tiles track by tile.xpuCollectForAdapter.id"><div class="ui checkbox"><input type="checkbox" class="ui" name="::item.xpuCollectForAdapter.name" ng-model="tile.xpuCollectForAdapter.value" ng-value="tile.xpuCollectForAdapter.value" ng-change="onChildKnobChanged(tile.xpuCollectForAdapter)" ng-disabled="readOnly || tile.xpuCollectForAdapter.disabled" ng-attr-id="{{::knob.id + \'-\' + $index + \'-\' + tile.tileId}}"> <label for="{{::knob.id + \'-\' + $index + \'-\' + tile.tileId}}">{{tileName + \' \' + tile.tileId}}</label></div></div></div></div></div></div>',controller:"XpuTargetController"}}));
"use strict";angular.module("collectionpane").directive("clientLink",(function(){return{template:'<div class="line"></div><div class="point"></div>'}}));
"use strict";angular.module("collectionpane").directive("targetsLink",(function(){return{template:'<div class="horizontal line"></div><div class="vertical line"></div><div class="point"></div>'}}));
"use strict";angular.module("collectionpane").controller("AndroidRunPanelController",["$scope","uiSession","$http","findKnob","error","workflow","localize","Tracker","requestIdentity",function(e,a,n,o,t,c,i,l,r){e.workflow=c.get(r.get(e)),e.loading=new l;const s=e.$watch((function(){return e.panel}),g);function g(){e.packageName=o(e.panel,"label.android_run")}function p(){return n.get("api/collection/configuration/android/packages",{params:{identity:r.get(e),connectionType:e.workflow.connectionType.id}})}function u(a){a.packages&&a.packages.forEach((e=>{e.debuggable=!0===e.debuggable||"true"===e.debuggable})),e.packages=a.packages,e.errors=a.errors}g(),a.getPartitionSocket(e).then((()=>{i(["%process_grid.hide_list","%process_grid.select_package","%package_column","%application_column","%selectable_only_label"],"collectionapi").then((a=>{e.messages=a,e.columns=[{id:"app_name",caption:a["%application_column"],sortable:!0,widthPercentage:50},{id:"package_name",caption:a["%package_column"],sortable:!0}]}))})),e.showPackagesList=function(){e.packagesListVisible=!0,delete e.packages,delete e.errors,e.loading.start().then(p).then(t.validateResponse).then(u).catch(t.handle(e)).finally(e.loading.stop)},e.hidePackagesList=function(){e.packagesListVisible=!1},e.selectPackage=function(a){e.packageName.value=a.package_name,e.onKnobChange(e.packageName)},e.isPackageDebuggable=function(e){return e.debuggable},e.$on("$destroy",(function(){s&&s()}))}]);
"use strict";angular.module("collectionpane").directive("androidRunPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="launch-android-package panel ui form"><div class="inline fields"><div mru-knob class="panel-knobs" knob="packageName" on-change="onKnobChange" read-only="readOnly"></div><div class="field"><button ng-click="showPackagesList()" class="ui button" ng-show="!packagesListVisible" ng-disabled="readOnly">{{ messages[\'%process_grid.select_package\'] }}</button> <button ng-click="hidePackagesList()" class="ui button" ng-show="packagesListVisible" ng-disabled="readOnly">{{ messages[\'%process_grid.hide_list\'] }}</button></div></div><div class="inline-dialog" ng-show="packagesListVisible && !readOnly"><errors errors="errors"></errors><simple-grid ng-show="packages.length> 0" columns="columns" rows="packages" can-be-selected="isPackageDebuggable" show-selectable-only-label="messages[\'%selectable_only_label\']" on-select="selectPackage" read-only="readOnly"></simple-grid><loading show-when="loading.isInProgress()"></loading></div></div>',controller:"AndroidRunPanelController"}}));
"use strict";angular.module("collectionpane").controller("AttachProcessRemotePanelController",["$scope","$http","uiSession","findKnob","error","localize","workflow","Tracker","requestIdentity",function(e,s,o,n,c,r,t,a,i){e.workflow=t.get(i.get(e)),e.loading=new a;const l=e.$watch((function(){return e.panel}),p);function p(){e.processName=n(e.panel,"process_panel.proc_name"),e.processId=n(e.panel,"process_panel.pid"),e.useProcessId=!!e.processId.value,e.useProcessName=!e.useProcessId}function d(){return s.get("api/collection/configuration/processes",{params:{identity:i.get(e),connectionType:e.workflow.connectionType.id}})}function u(s){s.processes&&s.processes.forEach((e=>{e.pid=Number(e.pid)})),e.processes=s.processes,e.errors=s.errors}p(),o.getPartitionSocket(e).then((()=>{r(["%process_grid.hide_list","%process_grid.select_package","%package_name_column","%package_id_column","%command_line_column"],"collectionapi").then((s=>{e.messages=s,e.columns=[{id:"name",caption:s["%package_name_column"],sortable:!0,widthPercentage:25},{id:"pid",caption:s["%package_id_column"],sortable:!0,type:"number",widthPercentage:25},{id:"cmd",caption:s["%command_line_column"]}]}))})),e.showProcessesList=function(){e.processesListVisible=!0,delete e.processes,delete e.errors,e.loading.start().then(d).then(c.validateResponse).then(u).catch(c.handle(e)).finally(e.loading.stop)},e.hideProcessesList=function(){e.processesListVisible=!1},e.selectProcess=function(s){e.useProcessName?(e.processName.value=s.name,e.processId.value=void 0,e.onKnobChange(e.processName)):(e.processName.value=void 0,e.processId.value=String(s.pid),e.onKnobChange(e.processId))};const m=e.$watch("useProcessName",(function(){e.useProcessId=!e.useProcessName,e.useProcessId&&e.onKnobChange(e.processId)})),g=e.$watch("useProcessId",(function(){e.useProcessName=!e.useProcessId,e.useProcessName&&e.onKnobChange(e.processName)}));e.$on("$destroy",(function(){l&&l(),m&&m(),g&&g()}))}]);
"use strict";angular.module("collectionpane").directive("attachProcessRemotePanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="attach-process-remote panel"><div class="ui form"><div class="inline fields"><div class="option"><div class="field" ng-class="{disabled: readOnly}"><div class="ui radio checkbox"><input type="checkbox" ng-model="useProcessName" ng-disabled="readOnly" id="attachProcessRemoteUseProcessName"> <label for="attachProcessRemoteUseProcessName">{{processName.name}}</label></div></div></div><div class="value process-name"><div mru-knob knob="processName" hide-label="true" on-change="onKnobChange" read-only="readOnly || !useProcessName"></div></div></div><div class="inline fields"><div class="option"><div class="field" ng-class="{disabled: readOnly}"><div class="ui radio checkbox"><input type="checkbox" ng-model="useProcessId" ng-disabled="readOnly" id="attachProcessRemoteUseProcessId"> <label for="attachProcessRemoteUseProcessId">{{processId.name}}</label></div></div></div><div class="value process-id"><div string-knob knob="processId" hide-label="true" on-change="onKnobChange" read-only="readOnly || !useProcessId"></div><button ng-click="showProcessesList()" ng-show="!processesListVisible" class="ui button" ng-disabled="readOnly">{{ messages[\'%process_grid.select_package\'] }}</button> <button ng-click="hideProcessesList()" ng-show="processesListVisible" class="ui button" ng-disabled="readOnly">{{ messages[\'%process_grid.hide_list\'] }}</button></div></div></div><div class="inline-dialog" ng-show="processesListVisible && !readOnly"><errors errors="errors"></errors><simple-grid ng-show="processes.length > 0" columns="columns" rows="processes" on-select="selectProcess" read-only="readOnly"></simple-grid><loading show-when="loading.isInProgress()"></loading></div></div>',controller:"AttachProcessRemotePanelController"}}));
"use strict";angular.module("collectionpane").controller("ApplicationPanelController",["$scope","collectionConstants","findKnob","productMode","workflow","requestIdentity",function(n,o,e,a,p,t){n.workflow=p.get(t.get(n));const{LOCALHOST_CONNECTION:r}=o.connectionTypeIds;n.isLocalhost=()=>n.workflow.connectionType&&n.workflow.connectionType.id===r&&!a.isBrowserMode();const l=n.$watch((function(){return n.panel}),i);function i(){n.incheretedFromVS=e(n.panel,"app_panel.incheretedFromVS"),n.applicationName=e(n.panel,"app_panel.application"),n.applicationParams=e(n.panel,"app_panel.app_parameters"),n.useWorkDir=e(n.panel,"app_panel.work_dir_sync_switcher"),n.workDirPath=e(n.panel,"app_panel.work_dir")}i(),n.saveKnobAndReloadTargetType=o=>n.onKnobChange(o).then(n.workflow.reloadAnalysisTarget),n.$on("$destroy",(function(){l&&l()}))}]);
"use strict";angular.module("collectionpane").directive("applicationPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="panel"><div class="ui form"><div class="fields" ng-show="incheretedFromVS.visibility"><div boolean-knob knob="incheretedFromVS" on-change="saveKnobAndReloadTargetType" read-only="readOnly"></div></div><div file-knob class="panel-knobs" local-file-system="isLocalhost()" knob="applicationName" dialog-title="applicationName.dialogTitle" file-filter="applicationName.dialogFileFilter" on-change="onKnobChange" read-only="readOnly || incheretedFromVS.value" data-tour-item="whatApplicationTourItem"></div><div mru-knob knob="applicationParams" class="panel-knobs" on-change="onKnobChange" read-only="readOnly || incheretedFromVS.value || !applicationName.value" data-tour-item="whatApplicationParamsTourItem"></div><div boolean-knob knob="useWorkDir" class="panel-knobs" on-change="onKnobChange" read-only="readOnly || incheretedFromVS.value || !applicationName.value"></div><div file-knob type="folder" local-file-system="isLocalhost()" knob="workDirPath" class="panel-knobs" ng-if="!useWorkDir.value" on-change="onKnobChange" read-only="readOnly || incheretedFromVS.value || !applicationName.value || useWorkDir.value"></div></div></div>',controller:"ApplicationPanelController"}}));
"use strict";angular.module("collectionpane").directive("inheritableKnobsPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="inheritable-knobs panel ui form"><knobs knobs="panel.knobs" on-knob-change="onKnobChange" read-only="readOnly"></knobs></div>'}}));
"use strict";angular.module("collectionpane").directive("connectionTypeKnobsPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="connection-type-knobs panel ui form"><knobs knobs="panel.knobs" on-knob-change="onKnobChange" read-only="readOnly"></knobs></div>'}}));
"use strict";angular.module("collectionpane").controller("mpiRunPanelController",["$scope","findKnob",function(n,e){const l=n.$watch((function(){return n.panel}),a);function a(){n.useMpiLauncher=e(n.panel,"mpirun_panel.enable"),n.mpiIntel=e(n.panel,"mpirun_panel.mpi_intel"),n.mpiLauncher=e(n.panel,"mpirun_panel.mpi_launcher"),n.otherLauncher=e(n.panel,"mpirun_panel.other_launcher"),n.numberOfRanks=e(n.panel,"mpirun_panel.number_of_ranks"),n.profileAllRanks=e(n.panel,"mpirun_panel.profile_all_ranks"),n.profileRanks=e(n.panel,"mpirun_panel.profile_ranks"),n.selectiveRanks=e(n.panel,"mpirun_panel.selective_ranks"),n.resultLocation=e(n.panel,"mpirun_panel.result_location")}a(),n.getMpiLauncher=function(){const e=n.otherLauncher.value?n.mpiLauncher.value:n.mpiIntel.value;return n.mpiLauncher.name+" "+e},n.getProfileRanks=function(){const e=n.selectiveRanks.value?n.profileRanks.value:n.profileAllRanks.value;return n.profileRanks.name+" "+e},n.$on("$destroy",(function(){l&&l()}))}]);
"use strict";angular.module("collectionpane").directive("mpiRunPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="mpi-run panel ui form"><div class="fields"><div boolean-knob knob="useMpiLauncher" on-change="onKnobChange" read-only="readOnly"></div></div><div class="details" ng-class="{visible: useMpiLauncher.value}"><div class="field label-only" ng-class="{disabled: readOnly}"><label>{{ getMpiLauncher() }}</label></div><div class="fields"><div boolean-knob knob="otherLauncher" on-change="onKnobChange" read-only="readOnly"></div><div string-knob knob="mpiLauncher" hide-label="true" on-change="onKnobChange" read-only="readOnly || !otherLauncher.value"></div></div><div class="fields"><div string-knob knob="numberOfRanks" hide-label="false" on-change="onKnobChange" read-only="readOnly"></div></div><div class="field label-only" ng-class="{disabled: readOnly}"><label>{{ getProfileRanks() }}</label></div><div class="fields"><div boolean-knob knob="selectiveRanks" on-change="onKnobChange" read-only="readOnly"></div><div string-knob knob="profileRanks" hide-label="true" on-change="onKnobChange" read-only="readOnly || !selectiveRanks.value"></div></div><div string-knob knob="resultLocation" on-change="onKnobChange" read-only="readOnly"></div></div></div>',controller:"mpiRunPanelController"}}));
"use strict";angular.module("collectionpane").controller("EnvironmentPanelController",["$scope","findKnob",function(n,e){const a=n.$watch((function(){return n.panel}),r);let t;function r(){n.environmentVars=e(n.panel,"env_var_panel.user_env_var"),n.variables=i(n.environmentVars.value),t=l()}function i(n){return n?n.split("\n").filter((n=>n.trim())).map((n=>{const e=n.match(/([^=]+)=?(.*)?/).slice(1);return{name:e[0].replace(/^\s*SET\s+/i,"").replace(/^\s*EXPORT\s+/i,""),value:e[1]}})):[]}function l(){const e={name:"",value:""};return n.variables.push(e),e}r(),n.onPaste=function(e){const a=i(e.clipboardData.getData("text"));n.variables.splice(...[n.variables.length-1,0].concat(a)),n.save(),e.preventDefault()},n.remove=function(e){e!==t&&(n.variables.splice(n.variables.indexOf(e),1),n.save())},n.save=function(){(t.name||t.value)&&(t=l()),n.environmentVars.value=n.variables.filter((n=>n!==t&&n.name&&n.name.trim())).map((n=>n.name+"="+n.value)).join("\n"),n.onKnobChange(n.environmentVars)},n.$on("$destroy",(function(){a&&a()}))}]);
"use strict";angular.module("collectionpane").directive("environmentPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="environment panel"><div class="ui form"><div class="field label-only" ng-class="{disabled: readOnly}"><label>{{environmentVars.name}}</label></div></div><div class="table-knob-container"><table class="variables ui celled very compact unstackable table"><tr ng-repeat="variable in variables"><td class="five wide"><div class="ui fluid transparent input"><input ng-model="variable.name" ng-change="save()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-paste="$last ? onPaste($event.originalEvent) : angular.noop" ng-disabled="readOnly" type="text" placeholder="{{$last ? panel.messages.newVariablePlaceholder : panel.messages.NamePlaceholder}}"></div></td><td class="eleven wide"><div class="ui fluid transparent icon input"><input ng-model="variable.value" ng-change="save()" ng-model-options="{ updateOn: \'default blur\', debounce: { \'default\': 1000, \'blur\': 0 } }" ng-disabled="readOnly" type="text" placeholder="{{$last ? \'\' : panel.messages.valuePlaceholder}}"> <i ng-click="remove(variable)" ng-hide="$last || readOnly" class="icon trash link"></i></div></td></tr></table></div></div>',controller:"EnvironmentPanelController"}}));
"use strict";angular.module("collectionpane").directive("nonInheritableKnobsPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="non-inheritable-knobs panel ui form"><knobs knobs="panel.knobs" on-knob-change="onKnobChange" read-only="readOnly"></knobs></div>'}}));
"use strict";angular.module("collectionpane").controller("resultDirPanelController",["$scope","findKnob",function(e,r){const t=e.$watch((function(){return e.panel}),o);let n;function o(){e.resultLocation=r(e.panel,"result_dir_panel.result_dir"),e.storeAnotherDir=r(e.panel,"radio_button.store_spec_dir"),e.anotherDirPath=r(e.panel,"string.store_spec_dir"),e.projectDirPath=r(e.panel,"string.store_proj_dir"),e.isMpi=r(e.panel,"bool.is_mpi"),n=r(e.panel,"string.dir_pattern")}o(),e.getResultDir=function(){let r=e.storeAnotherDir.value?e.anotherDirPath.value:e.projectDirPath.value;return r=r.replace(/(\\|\/)$/,""),e.resultLocation.value+" "+r+n.value},e.$on("$destroy",(function(){t&&t()}))}]);
"use strict";angular.module("collectionpane").directive("resultDirPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="result-dir panel ui form"><div class="field label-only" ng-class="{disabled: readOnly}"><label>{{ getResultDir() }}</label></div><div class="fields" ng-show="!isMpi.value"><div boolean-knob class="panel-knobs" knob="storeAnotherDir" on-change="onKnobChange" read-only="readOnly"></div><div file-knob type="folder" class="panel-knobs" knob="anotherDirPath" on-change="onKnobChange" hide-label="true" read-only="readOnly || !storeAnotherDir.value"></div></div></div>',controller:"resultDirPanelController"}}));
"use strict";angular.module("collectionpane").controller("ProcessPanelController",["$scope","findKnob",function(e,s){const o=e.$watch((function(){return e.panel}),c);function c(){e.useProcessName=s(e.panel,"process_panel.proc_name"),e.useProcessId=s(e.panel,"process_panel.pid"),e.processName=s(e.panel,"process_name"),e.processId=s(e.panel,"process_id"),e.useProcessId.value=!e.useProcessName.value}c();const n=e.$watch("useProcessName.value",(function(){e.useProcessId.value=!e.useProcessName.value})),a=e.$watch("useProcessId.value",(function(){e.useProcessName.value=!e.useProcessId.value}));e.$on("$destroy",(function(){o&&o(),n&&n(),a&&a()}))}]);
"use strict";angular.module("collectionpane").directive("processPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="attach panel ui form"><div class="inline fields"><div class="option"><div boolean-knob knob="useProcessName" on-change="onKnobChange" read-only="readOnly"></div></div><div class="value process-name"><div mru-knob class="panel-knobs" knob="processName" hide-label="true" on-change="onKnobChange" read-only="readOnly || !useProcessName.value"></div></div></div><div class="inline fields"><div class="option"><div boolean-knob knob="useProcessId" on-change="onKnobChange" read-only="readOnly"></div></div><div class="value"><div string-knob class="panel-knobs" knob="processId" hide-label="true" on-change="onKnobChange" read-only="readOnly || !useProcessId.value"></div></div></div></div>',controller:"ProcessPanelController"}}));
"use strict";angular.module("collectionpane").controller("ResumeAfterPanelController",["$scope","findKnob","stateMachine","requestIdentity",function(e,t,a,n){e.stateMachine=a.get(n.get(e));const r=e.$watch((function(){return e.panel}),u);function u(){e.useResumeAfter=t(e.panel,"exp_duration_panel.resume_after"),e.resumeAfterVal=t(e.panel,"exp_duration_panel.resume_after.tooltip"),e.useStopAfter=t(e.panel,"exp_duration_panel.proc_name"),e.stopAfterVal=t(e.panel,"exp_duration_panel.proc_name.tooltip"),e.stateMachine.setStartPausedMode(e.useResumeAfter.value),e.resumeAfterVal&&e.resumeAfterVal.value&&(e.resumeAfterVal.value=parseInt(e.resumeAfterVal.value)),e.stopAfterVal&&e.stopAfterVal.value&&(e.stopAfterVal.value=parseInt(e.stopAfterVal.value))}u(),e.onUseResumeAfterChange=()=>{e.stateMachine.setStartPausedMode(e.useResumeAfter.value),e.onKnobChange(e.useResumeAfter)},e.$on("$destroy",(function(){r&&r()}))}]);
"use strict";angular.module("collectionpane").directive("resumeAfterPanel",(function(){return{restrict:"E",scope:{panel:"=",readOnly:"=",onKnobChange:"="},template:'<div class="experimental-duration panel ui form"><div class="inline fields"><div boolean-knob class="panel-knobs" knob="useResumeAfter" on-change="onUseResumeAfterChange" read-only="readOnly"></div><div class="value"><div int-knob class="panel-knobs" knob="resumeAfterVal" on-change="onKnobChange" hide-label="true" read-only="readOnly || !useResumeAfter.value"></div></div></div><div class="inline fields"><div boolean-knob class="panel-knobs" knob="useStopAfter" on-change="onKnobChange" read-only="readOnly"></div><div class="value"><div int-knob class="panel-knobs" knob="stopAfterVal" on-change="onKnobChange" hide-label="true" read-only="readOnly || !useStopAfter.value"></div></div></div></div>',controller:"ResumeAfterPanelController"}}));
"use strict";angular.module("collectionpane").directive("manualDeployment",(function(){return{scope:{},template:'<div localize="localize" default-msg-catalog="collectionpane"><div class="message">{{::localize(\'%agentConnection.deployment.manualDeploymentNeeded\')}}</div><a class="ui button primary" href="api/collection-agent/download" target="_self">{{::localize(\'%agentConnection.deployment.manual.download\')}}</a></div>'}}));
"use strict";angular.module("collectionpane").directive("probingTarget",(function(){return{scope:{},template:'<div localize="localize" default-msg-catalog="collectionpane"><div class="message"><i class="icon circle-third spin"></i> {{::localize(\'%agentConnection.deployment.probingTarget\')}}</div><div><a class="ui button" href="api/collection-agent/download" target="_self">{{::localize(\'%agentConnection.deployment.manual.download\')}}</a></div></div>'}}));
"use strict";angular.module("collectionpane").controller("SshDeploymentController",["$http","$scope","error","findKnob","localize","sensitiveParameter","uiSession","$rootScope",async function(e,n,o,t,s,a,r,i){const l="inProgress",c="failed";let p,h="notStarted";n.hostname=t(n.knob,"hostname"),n.sshConnection=t(n.knob,"ssh-connection");const d=t(n.sshConnection,"username"),u=t(n.sshConnection,"port"),y=t(n.sshConnection,"private-key"),v=t(n.sshConnection,"private-key-passphrase"),m=t(n.sshConnection,"password"),g=t(n.sshConnection,"auth-type");n.installDir=t(n.knob,"installDir"),n.sharedAgent=t(n.knob,"shared-agent");const C={id:(await e.get("api/users/current")).data.id};r.getPartitionSocket(i).then((e=>{e.on("agent-deployment",(e=>{e.hostname!==n.hostname.value||e.installDir!==n.installDir.value||e.deployed||e.errorCode&&(h=c,p=e.errorCode)}))})),n.deploy=()=>{h=l;const t={hostname:n.hostname.value,username:d.value,port:u.value,installDir:n.installDir.value,shared:n.isShared(),owner:C.id};"public-key"===g.value?(t.privateKey=a(y.value),t.privateKeyPassphrase=a(v.value)):t.password=a(m.value),e.post("api/collection-agent/deploy",t).then(o.validateResponse).catch((()=>{h=c,p="unknown_error"}))},n.getDeploymentStateDescription=()=>{const e=h===c?p:h;return s.synchronously(`%agentConnection.deployment.ssh.${e}`,"collectionpane")},n.isDeploymentInProgress=()=>h===l,n.hasDeploymentFailed=()=>h===c,n.isShared=()=>n.sharedAgent.value}]);
"use strict";angular.module("collectionpane").directive("sshDeployment",(function(){return{scope:{knob:"<",onChange:"<"},template:'<div localize="localize" default-msg-catalog="collectionpane"><div class="message" ng-class="{ errors: hasDeploymentFailed() }"><i class="icon circle-third spin" ng-if="isDeploymentInProgress()"></i> <i class="icon error" ng-if="hasDeploymentFailed()"></i> {{getDeploymentStateDescription()}}</div><div ng-hide="isDeploymentInProgress()"><ssh-connection knob="sshConnection" on-change="onChange" read-only="readOnly"></ssh-connection><string-knob knob="installDir" on-change="onChange" error="isAgentRunning() || isNonWritableDeploymentTargetDir()"></string-knob><div><boolean-knob knob="sharedAgent" on-change="onChange" read-only="readOnly"></boolean-knob><div class="message warnings" ng-if="isShared()"><i class="icon warning"></i> {{::localize(\'%agentConnection.deployment.ssh.sharedAgent.warning\')}}</div></div><button class="ui primary button" id="deploy_agent" ng-click="deploy()">{{::localize(\'%agentConnection.deployment.ssh.deploy\')}}</button> <a class="ui button" id="download_agent_manually" href="api/collection-agent/download" target="_self">{{::localize(\'%agentConnection.deployment.manual.download\')}}</a></div></div>',controller:"SshDeploymentController"}}));
"use strict";angular.module("collectionpane").controller("AgentControlPanelController",["$http","$scope","workflow","requestIdentity",function(t,e,n,a){e.fingerprint=e.agent.fingerprint,e.stopAgent=()=>{t.post("api/collection-agent/stop",{uuids:[e.agent.agentUuid]})},e.admitAgent=async()=>{await t.post("api/collection-agent/admit",{uuids:[e.agent.agentUuid]}),await e.agent._refreshTargetState(n.get(a.get(e)))}}]);
"use strict";angular.module("collectionpane").directive("agentControlPanel",(function(){return{scope:{agent:"<",onChange:"<"},template:'<div localize="localize" default-msg-catalog="collectionpane"><div class="knob field ui" ng-if="!agent.isAdmitted" id="fingerprint"><label>{{::localize(\'%agentConnection.agentControlPanel.fingerprint\')}}</label><div class="ui transparent input"><input type="text" value="{{::fingerprint}}" readonly="readonly"></div></div><div class="inline fields"><div class="field" ng-if="!agent.isAdmitted"><a class="ui primary button" id="admit_agent" ng-click="admitAgent()">{{::localize(\'%agentConnection.agentControlPanel.admit\')}}</a></div><div class="field"><a class="ui compact mini button" id="stop_agent" ng-click="stopAgent()">{{::localize(\'%agentConnection.agentControlPanel.stopNow\')}}</a></div></div></div>',controller:"AgentControlPanelController"}}));
//# sourceMappingURL=collectionpane-630424.js.map
