<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:Xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="msxsl" xmlns:exsl="http://exslt.org/common"
                xmlns:str="http://exslt.org/strings" exsl:keep_exsl_namespace=""
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:double="http://www.w3.org/2001/XMLSchema#double"
                xmlns:fnc="urn:functions"
                syntax="norules">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="enablePython">false</xsl:param>
  <xsl:template match="/">
    <knobs>
      <xsl:variable name="pmuConditionsExtended" select="document('config://include/pmu_variables_extended.xsl')"/>
      <xsl:variable name="isExtendedIsaSupport" select="$pmuConditionsExtended//variables/isExtendedIsaSupport"/>
      <stringKnob id="pmuEventConfig" displayName="%PmuEventConfig" cliName="event-config">
        <knobProperty name="queryEventsOption">--event-value-list</knobProperty>
        <knobProperty name="knob_control_id">HWEventConfig</knobProperty>
        <boolean:knobProperty name="specifyPlatformType">true</boolean:knobProperty>
        <knobProperty name="HWTableInfo">pmuHWTableInfo</knobProperty>
        <description>%PmuEventConfigDescription</description>
        <value></value>
        <defaultValue></defaultValue>
      </stringKnob>
      <booleanKnob id="useEventBasedCounts" displayName="%UseEventBasedCounts">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%UseEventBasedCountsDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableHWBasedCSCollection" displayName="%EnableHWBasedCSCollection">
        <boolean:defaultValue>
          <xsl:value-of select="exsl:is_experimental('lbr-stack-stitching')"/>
        </boolean:defaultValue>
        <description>%EnableHWBasedCSCollectionDescription</description>
        <experimental>lbr-stack-stitching</experimental>
      </booleanKnob>
      <booleanKnob id="useCountingMode" displayName="%UseCountingMode" cliName="counting-mode">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%UseCountingModeDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <xsl:variable name="defaultGpuAdapter" select="exsl:ctx('preferedGpuAdapter', '')"/>
      <xsl:variable name="commonDoc" select="document('config://collector/include/common.xsl')"/>
      <xsl:variable name="computeExtendedExistance" select="string($commonDoc//common/variables/computeExtendedExistance)"/>
      <xsl:variable name="gpuPlatformIndexList" select="exsl:ctx('gpuPlatformIndexList', '')"/>
      <xsl:variable name="gpuAdapterNameList" select="exsl:ctx('gpuAdapterNameList', '')"/>
      <enumKnob id="targetGPU" displayName="%GPUSelectedAdapter" boolean:visible="false" cliName="target-gpu">
        <xsl:if test="$defaultGpuAdapter = 'none'">
          <knobProperty name="active_state">false</knobProperty>
        </xsl:if>
        <description>%GPUSelectedAdapterDescription</description>
        <xsl:choose>
          <xsl:when test="count(str:split(exsl:ctx('gpuAdapterNameList',''), ';')) = 0">
            <values>
              <value displayName="none">none</value>
              <defaultValue displayName="none">none</defaultValue>
            </values>
          </xsl:when>
          <xsl:otherwise>
            <values>
              <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
                <xsl:variable name="targetGPUInfo" select="str:split(., '|')"/>
                <xsl:variable name="targetGPUBDF" select="string($targetGPUInfo[1])"/>
                <xsl:variable name="targetGPUName" select="string($targetGPUInfo[2])"/>
                <value>
                  <xsl:attribute name="displayName">
                    <xsl:value-of select="concat($targetGPUBDF, ' : ', $targetGPUName)"/>
                  </xsl:attribute>
                  <xsl:value-of select="$targetGPUBDF"/>
                </value>
                <xsl:if test="$targetGPUBDF = $defaultGpuAdapter">
                  <defaultValue>
                    <xsl:attribute name="displayName">
                      <xsl:value-of select="concat($defaultGpuAdapter, ' : ', $targetGPUName)"/>
                    </xsl:attribute>
                    <xsl:value-of select="$defaultGpuAdapter"/>
                  </defaultValue>
                </xsl:if>
              </xsl:for-each>
            </values>
          </xsl:otherwise>
        </xsl:choose>
      </enumKnob>
      <groupKnob id="groupForGPUCustomCollection">
        <knobProperty name="knob_control_id">gpuMultiadapterGroup</knobProperty>
        <xsl:variable name="bdfNameList">
          <xsl:for-each select="str:split($gpuAdapterNameList, ';')">
            <xsl:variable name="info" select="str:split(., '|')"/>
            <value><xsl:value-of select="string($info[1])"/><xsl:text>|</xsl:text><xsl:value-of select="string($info[2])"/></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="bdfsList">
          <xsl:choose>
            <xsl:when test="$gpuAdapterNameList=''">
              <xsl:if test="exsl:ctx('targetGPU', 0)"><value><xsl:value-of select="exsl:ctx('targetGPU', 'none')"/></value></xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <xsl:for-each select="str:split($gpuAdapterNameList, ';')">
                <xsl:variable name="info" select="str:split(., '|')"/>
                <value><xsl:value-of select="string($info[1])"/></value>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="gpuProfilingModeValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|none</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="gpuSamplingIntervalValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|1</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="stallReasonsSamplingIntervalValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|0.0005</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="collectGpuOpenClValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|false</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="collectGpuOpenClArgValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|false</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="gpuCountersValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|none</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="gcCommonValuesNone">
          <item>none|%GpuProfilingModeNone,</item>
        </xsl:variable>
        <xsl:variable name="gcCommonValuesOverview">
          <item>overview|%GpuCollectOverview,</item>
          <description>%GpuCountersDescriptionOverview</description>
        </xsl:variable>
        <xsl:variable name="gcCommonValuesGlobalMemoryAccesses">
          <item>global-memory-accesses|%GpuCollectGlobalMemoryAccesses,</item>
          <description>%GpuCountersDescriptionGlobalMemoryAccesses</description>
        </xsl:variable>
        <xsl:variable name="gcCommonValues2">
          <item>render-basic|%GpuCollectRenderBasic,</item>
          <description></description>
        </xsl:variable>
        <xsl:variable name="gcValue2">
          <xsl:if test="exsl:is_experimental('gpu-metrics2')">
            <item><xsl:text>preset3|%GpuCollectPreset3,preset5|%GpuCollectPreset5,</xsl:text></item>
            <description></description>
          </xsl:if>
          <xsl:if test="exsl:is_experimental('gpu-euactivity')">
            <item>
              <xsl:text>euactivity7|%GpuCollectEuActivity7,euactivity8|%GpuCollectEuActivity8,</xsl:text>
            </item>
            <description></description>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="gpuHWProfilingValues">
          <xsl:for-each select="exsl:node-set($bdfsList)/value">
            <xsl:variable name="bdf" select="."/>
            <value><xsl:value-of select="$bdf"/><xsl:text>|false</xsl:text></value>
          </xsl:for-each>
        </xsl:variable>
        <knobs>
            <stringKnob id="gpuAdapterNames" boolean:visible="false">
              <defaultValue>
                <xsl:value-of select="fnc:node_join($bdfNameList)"/>
              </defaultValue>
              <knobProperty name="notPersistedValue">
                <xsl:value-of select="fnc:node_join($bdfNameList)"/>
              </knobProperty>
            </stringKnob>
            <stringKnob id="gpuProfilingMode" displayName="%GpuSwInstrumentationMode" boolean:visible="true" cliName="gpu-profiling-mode">
              <description>%GpuProfilingModeDescriptionCustomAnalysis</description>
              <defaultValue>
                <xsl:value-of select="fnc:node_join($gpuProfilingModeValues)"/>
              </defaultValue>
              <xsl:variable name="GpuSwInstrumentationModesList">
                <xsl:text>none|%GpuProfilingModeNone,bblatency|%GpuProfilingModeBBLatency,memlatency|%GpuProfilingModeMemLatency,instcount|%GpuProfilingModeInstCount</xsl:text>
                <xsl:if test="exsl:is_experimental('gpu-mem-analysis')">
                  <xsl:text>,memanalysis|%GpuProfilingModeMemAnalysis</xsl:text>
                </xsl:if>
              </xsl:variable>
              <knobProperty name="items"><xsl:value-of select="$GpuSwInstrumentationModesList"/></knobProperty>
            </stringKnob>
            <stringKnob id="gpuSamplingInterval" displayName="%GpuSamplingInterval" boolean:visible="true" cliName="gpu-sampling-interval">
              <description>%GpuSamplingIntervalDescription</description>
              <defaultValue>
                <xsl:value-of select="fnc:node_join($gpuSamplingIntervalValues)"/>
              </defaultValue>
              <double:knobProperty name="min">0.01</double:knobProperty>
              <double:knobProperty name="max">1000</double:knobProperty>
            </stringKnob>
            <stringKnob id="gpuHWProfiling" displayName="%GpuHwSampling" boolean:visible="false" cliName="gpu-hw-profiling">
              <xsl:if test="fnc:is_gpu_hw_stall_reason_collection_available()">
                <xsl:attribute name="boolean:visible">true</xsl:attribute>
              </xsl:if>
              <description>%GpuHwSamplingDescription</description>
              <defaultValue>
                <xsl:value-of select="fnc:node_join($gpuHWProfilingValues)"/>
              </defaultValue>
            </stringKnob>
            <stringKnob id="stallReasonsSamplingInterval" displayName="%StallReasonsSamplingInterval" boolean:visible="true" cliName="stall-reasons-sampling-interval">
              <description>%StallReasonsSamplingIntervalDescription</description>
              <defaultValue>
                <xsl:value-of select="fnc:node_join($stallReasonsSamplingIntervalValues)"/>
              </defaultValue>
              <double:knobProperty name="min">0.0001</double:knobProperty>
              <double:knobProperty name="max">2</double:knobProperty>
            </stringKnob>
            <stringKnob id="collectXpuCompute" displayName="%XpuTraceProgrammingAPIs" boolean:visible="true">
              <defaultValue>
                true
              </defaultValue>
            </stringKnob>
            <stringKnob id="collectGpuOpenCl" displayName="%GpuTraceProgrammingAPIs" boolean:visible="true" cliName="collect-programming-api">
              <xsl:choose>
                <xsl:when test="exsl:ctx('targetOS', '')='Windows' or exsl:ctx('targetOS', '')='Linux'">
                  <description>%CollectGpuOpenClModeDescription</description>
                </xsl:when>
                <xsl:when test="exsl:ctx('targetOS', '')='Android'">
                  <xsl:attribute name="displayName">%CollectAndroidGpuRuntimes</xsl:attribute>
                  <description>%CollectAndroidGpuRuntimesModeDescription</description>
                  <experimental>gpu-android-runtimes</experimental>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="boolean:visible">false</xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>
              <defaultValue>
                <xsl:value-of select="fnc:node_join($collectGpuOpenClValues)"/>
              </defaultValue>
            </stringKnob>
            <stringKnob id="collectGpuOpenClArg" boolean:visible="false">
              <defaultValue>
                <xsl:value-of select="fnc:node_join($collectGpuOpenClArgValues)"/>
              </defaultValue>
            </stringKnob>
            <stringKnob id="gpuCounters" displayName="%GpuCounters" boolean:visible="true" cliName="gpu-counters-mode">
              <defaultValue>
                <xsl:value-of select="fnc:node_join($gpuCountersValues)"/>
              </defaultValue>
                <xsl:for-each select="str:split($gpuPlatformIndexList, ';')">
                  <xsl:variable name="targetGPUInfo" select="str:split(., '|')"/>
                  <xsl:variable name="targetGPUPlatformIndex" select="number($targetGPUInfo[2])"/>
                  <xsl:variable name="gcValue0">
                    <xsl:if test="$targetGPUPlatformIndex != 25">
                      <item>overview|%GpuCollectOverview,</item>
                      <description>%GpuCountersDescriptionOverview</description>
                    </xsl:if>
                  </xsl:variable>
                  <xsl:variable name="gcValue1">
                    <xsl:if test="$targetGPUPlatformIndex >= 6 and
                                $targetGPUPlatformIndex != 17 and $targetGPUPlatformIndex != 21 and $targetGPUPlatformIndex != 22 and $targetGPUPlatformIndex != 25">
                      <item><xsl:text>compute-extended|%GpuComputeExtended,</xsl:text></item>
                      <description>%GpuCountersDescriptionComputeExt</description>
                    </xsl:if>
                  </xsl:variable>
                  <xsl:variable name="gcValueFull">
                    <xsl:if test="$targetGPUPlatformIndex != 25 and exsl:ctx('connectionType','') != 'ghs'">
                      <item><xsl:text>full-compute|%GpuFullCompute,</xsl:text></item>
                      <description>%GpuCountersDescriptionFullCompute</description>
                    </xsl:if>
                  </xsl:variable>
                  <knobProperty>
                    <xsl:attribute name='name'><xsl:value-of select="concat('items_', $targetGPUInfo[1])"/></xsl:attribute>
                    <xsl:value-of select="concat(exsl:node-set($gcCommonValuesNone)/item, exsl:node-set($gcValue0)/item, exsl:node-set($gcCommonValuesGlobalMemoryAccesses)/item, exsl:node-set($gcValue1)/item, exsl:node-set($gcCommonValues2)/item, exsl:node-set($gcValue2)/item, exsl:node-set($gcValueFull)/item)"/></knobProperty>
                  <knobProperty>
                    <xsl:attribute name='name'><xsl:value-of select="concat('description_', $targetGPUInfo[1])"/></xsl:attribute>
                    <xsl:value-of select="concat('%GpuCountersDescriptionCAStart,', exsl:node-set($gcValue0)/description, ',', exsl:node-set($gcCommonValuesGlobalMemoryAccesses)/description, ',', exsl:node-set($gcValue1)/description, ',', exsl:node-set($gcCommonValues2)/description, ',', exsl:node-set($gcValue2)/description, ',', exsl:node-set($gcValueFull)/description, ',%GpuCountersDescriptionCAEnd')"/>
                  </knobProperty>
                </xsl:for-each>
            </stringKnob>
        </knobs>
      </groupKnob>
      <stringKnob id="gpuMetricsSelected" displayName="%GpuMetricsSelected" boolean:visible="true" cliName="gpu-metrics-selected">
	<xsl:if test="$isExtendedIsaSupport='true'">
	  <xsl:attribute name="boolean:visible">false</xsl:attribute>
	</xsl:if>
        <knobProperty name="queryEventsOption">--gpu-metrics-config-list</knobProperty>
        <knobProperty name="knob_control_id">GpuEventConfig</knobProperty>
        <description>%GpuMetricsSelectedDescription</description>
        <value></value>
        <xsl:choose>
          <xsl:when test="exsl:is_experimental('gps-analysis')">
            <xsl:variable name="Filtered">
              <value><xsl:text>GpuCoreClocks</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="XVEOccupancy">
              <value><xsl:text>XVE_ACTIVE,XVE_STALL,XVE_THREADS_OCCUPANCY_ALL</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="L3">
              <value><xsl:text>L3_BANK_INPUT_AVAILABLE_L3BANK0,L3_OUTPUT_READY_L3BANK0,L3_BANK_INPUT_AVAILABLE_L3BANK1,L3_OUTPUT_READY_L3BANK1,L3_BANK_INPUT_AVAILABLE_L3BANK2,L3_OUTPUT_READY_L3BANK2,L3_BANK_INPUT_AVAILABLE_L3BANK3,L3_OUTPUT_READY_L3BANK3,L3_BANK_INPUT_AVAILABLE_L3BANK4,L3_OUTPUT_READY_L3BANK4,L3_BANK_INPUT_AVAILABLE_L3BANK5,L3_OUTPUT_READY_L3BANK5,L3_BANK_INPUT_AVAILABLE_L3BANK6,L3_OUTPUT_READY_L3BANK6,L3_BANK_INPUT_AVAILABLE_L3BANK7,L3_OUTPUT_READY_L3BANK7,L3_BANK_INPUT_AVAILABLE_L3BANK8,L3_OUTPUT_READY_L3BANK8,L3_BANK_INPUT_AVAILABLE_L3BANK9,L3_OUTPUT_READY_L3BANK9,L3_BANK_INPUT_AVAILABLE_L3BANK10,L3_OUTPUT_READY_L3BANK10,L3_BANK_INPUT_AVAILABLE_L3BANK11,L3_OUTPUT_READY_L3BANK11,L3_BANK_INPUT_AVAILABLE_L3BANK12,L3_OUTPUT_READY_L3BANK12,L3_BANK_INPUT_AVAILABLE_L3BANK13,L3_OUTPUT_READY_L3BANK13,L3_BANK_INPUT_AVAILABLE_L3BANK14,L3_OUTPUT_READY_L3BANK14,L3_BANK_INPUT_AVAILABLE_L3BANK15,L3_OUTPUT_READY_L3BANK15,L3_BANK_INPUT_AVAILABLE_L3BANK16,L3_OUTPUT_READY_L3BANK16,L3_BANK_INPUT_AVAILABLE_L3BANK17,L3_OUTPUT_READY_L3BANK17,L3_BANK_INPUT_AVAILABLE_L3BANK18,L3_OUTPUT_READY_L3BANK18,L3_BANK_INPUT_AVAILABLE_L3BANK19,L3_OUTPUT_READY_L3BANK19,L3_BANK_INPUT_AVAILABLE_L3BANK20,L3_OUTPUT_READY_L3BANK20,L3_BANK_INPUT_AVAILABLE_L3BANK21,L3_OUTPUT_READY_L3BANK21,L3_BANK_INPUT_AVAILABLE_L3BANK22,L3_OUTPUT_READY_L3BANK22,L3_BANK_INPUT_AVAILABLE_L3BANK23,L3_OUTPUT_READY_L3BANK23,L3_BANK_INPUT_AVAILABLE_L3BANK24,L3_OUTPUT_READY_L3BANK24,L3_BANK_INPUT_AVAILABLE_L3BANK25,L3_OUTPUT_READY_L3BANK25,L3_BANK_INPUT_AVAILABLE_L3BANK26,L3_OUTPUT_READY_L3BANK26,L3_BANK_INPUT_AVAILABLE_L3BANK27,L3_OUTPUT_READY_L3BANK27,L3_BANK_INPUT_AVAILABLE_L3BANK28,L3_OUTPUT_READY_L3BANK28,L3_BANK_INPUT_AVAILABLE_L3BANK29,L3_OUTPUT_READY_L3BANK29,L3_BANK_INPUT_AVAILABLE_L3BANK30,L3_OUTPUT_READY_L3BANK30,L3_BANK_INPUT_AVAILABLE_L3BANK31,L3_OUTPUT_READY_L3BANK31</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="GTI">
              <value><xsl:text>GtiReadThroughput,GtiWriteThroughput,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI2,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI3,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI4,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI5,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI6,GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI7,GPU_MEMORY_BYTE_READ_SQIDI0,GPU_MEMORY_BYTE_WRITE_SQIDI0,GPU_MEMORY_BYTE_READ_SQIDI1,GPU_MEMORY_BYTE_WRITE_SQIDI1,GPU_MEMORY_BYTE_READ_SQIDI2,GPU_MEMORY_BYTE_WRITE_SQIDI2,GPU_MEMORY_BYTE_READ_SQIDI3,GPU_MEMORY_BYTE_WRITE_SQIDI3,GPU_MEMORY_BYTE_READ_SQIDI4,GPU_MEMORY_BYTE_WRITE_SQIDI4,GPU_MEMORY_BYTE_READ_SQIDI5,GPU_MEMORY_BYTE_WRITE_SQIDI5,GPU_MEMORY_BYTE_READ_SQIDI6,GPU_MEMORY_BYTE_WRITE_SQIDI6,GPU_MEMORY_BYTE_READ_SQIDI7,GPU_MEMORY_BYTE_WRITE_SQIDI7,GPU_MEMORY_BYTE_READ,GPU_MEMORY_BYTE_WRITE,AvgGpuCoreFrequencyMHz</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="HDC">
              <value><xsl:text>DATAPORT_INPUT_AVAILABLE_XECORE0,DATAPORT_OUTPUT_READY_XECORE0,DATAPORT_INPUT_AVAILABLE_XECORE1,DATAPORT_OUTPUT_READY_XECORE1,DATAPORT_INPUT_AVAILABLE_XECORE2,DATAPORT_OUTPUT_READY_XECORE2,DATAPORT_INPUT_AVAILABLE_XECORE3,DATAPORT_OUTPUT_READY_XECORE3,DATAPORT_INPUT_AVAILABLE_XECORE4,DATAPORT_OUTPUT_READY_XECORE4,DATAPORT_INPUT_AVAILABLE_XECORE5,DATAPORT_OUTPUT_READY_XECORE5,DATAPORT_INPUT_AVAILABLE_XECORE6,DATAPORT_OUTPUT_READY_XECORE6,DATAPORT_INPUT_AVAILABLE_XECORE7,DATAPORT_OUTPUT_READY_XECORE7,DATAPORT_INPUT_AVAILABLE_XECORE8,DATAPORT_OUTPUT_READY_XECORE8,DATAPORT_INPUT_AVAILABLE_XECORE9,DATAPORT_OUTPUT_READY_XECORE9,DATAPORT_INPUT_AVAILABLE_XECORE10,DATAPORT_OUTPUT_READY_XECORE10,DATAPORT_INPUT_AVAILABLE_XECORE11,DATAPORT_OUTPUT_READY_XECORE11,DATAPORT_INPUT_AVAILABLE_XECORE12,DATAPORT_OUTPUT_READY_XECORE12,DATAPORT_INPUT_AVAILABLE_XECORE13,DATAPORT_OUTPUT_READY_XECORE13,DATAPORT_INPUT_AVAILABLE_XECORE14,DATAPORT_OUTPUT_READY_XECORE14,DATAPORT_INPUT_AVAILABLE_XECORE15,DATAPORT_OUTPUT_READY_XECORE15,DATAPORT_INPUT_AVAILABLE_XECORE16,DATAPORT_OUTPUT_READY_XECORE16,DATAPORT_INPUT_AVAILABLE_XECORE17,DATAPORT_OUTPUT_READY_XECORE17,DATAPORT_INPUT_AVAILABLE_XECORE18,DATAPORT_OUTPUT_READY_XECORE18,DATAPORT_INPUT_AVAILABLE_XECORE19,DATAPORT_OUTPUT_READY_XECORE19,DATAPORT_INPUT_AVAILABLE_XECORE20,DATAPORT_OUTPUT_READY_XECORE20,DATAPORT_INPUT_AVAILABLE_XECORE21,DATAPORT_OUTPUT_READY_XECORE21,DATAPORT_INPUT_AVAILABLE_XECORE22,DATAPORT_OUTPUT_READY_XECORE22,DATAPORT_INPUT_AVAILABLE_XECORE23,DATAPORT_OUTPUT_READY_XECORE23,DATAPORT_INPUT_AVAILABLE_XECORE24,DATAPORT_OUTPUT_READY_XECORE24,DATAPORT_INPUT_AVAILABLE_XECORE25,DATAPORT_OUTPUT_READY_XECORE25,DATAPORT_INPUT_AVAILABLE_XECORE26,DATAPORT_OUTPUT_READY_XECORE26,DATAPORT_INPUT_AVAILABLE_XECORE27,DATAPORT_OUTPUT_READY_XECORE27,DATAPORT_INPUT_AVAILABLE_XECORE28,DATAPORT_OUTPUT_READY_XECORE28,DATAPORT_INPUT_AVAILABLE_XECORE29,DATAPORT_OUTPUT_READY_XECORE29,DATAPORT_INPUT_AVAILABLE_XECORE30,DATAPORT_OUTPUT_READY_XECORE30,DATAPORT_INPUT_AVAILABLE_XECORE31,DATAPORT_OUTPUT_READY_XECORE31</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="LSC">
              <value><xsl:text>LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0,LOAD_STORE_CACHE_OUTPUT_READY_XECORE0,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1,LOAD_STORE_CACHE_OUTPUT_READY_XECORE1,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2,LOAD_STORE_CACHE_OUTPUT_READY_XECORE2,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3,LOAD_STORE_CACHE_OUTPUT_READY_XECORE3,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE4,LOAD_STORE_CACHE_OUTPUT_READY_XECORE4,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE5,LOAD_STORE_CACHE_OUTPUT_READY_XECORE5,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE6,LOAD_STORE_CACHE_OUTPUT_READY_XECORE6,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE7,LOAD_STORE_CACHE_OUTPUT_READY_XECORE7,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE8,LOAD_STORE_CACHE_OUTPUT_READY_XECORE8,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE9,LOAD_STORE_CACHE_OUTPUT_READY_XECORE9,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE10,LOAD_STORE_CACHE_OUTPUT_READY_XECORE10,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE11,LOAD_STORE_CACHE_OUTPUT_READY_XECORE11,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE12,LOAD_STORE_CACHE_OUTPUT_READY_XECORE12,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE13,LOAD_STORE_CACHE_OUTPUT_READY_XECORE13,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE14,LOAD_STORE_CACHE_OUTPUT_READY_XECORE14,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE15,LOAD_STORE_CACHE_OUTPUT_READY_XECORE15,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE16,LOAD_STORE_CACHE_OUTPUT_READY_XECORE16,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE17,LOAD_STORE_CACHE_OUTPUT_READY_XECORE17,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE18,LOAD_STORE_CACHE_OUTPUT_READY_XECORE18,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE19,LOAD_STORE_CACHE_OUTPUT_READY_XECORE19,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE20,LOAD_STORE_CACHE_OUTPUT_READY_XECORE20,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE21,LOAD_STORE_CACHE_OUTPUT_READY_XECORE21,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE22,LOAD_STORE_CACHE_OUTPUT_READY_XECORE22,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE23,LOAD_STORE_CACHE_OUTPUT_READY_XECORE23,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE24,LOAD_STORE_CACHE_OUTPUT_READY_XECORE24,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE25,LOAD_STORE_CACHE_OUTPUT_READY_XECORE25,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE26,LOAD_STORE_CACHE_OUTPUT_READY_XECORE26,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE27,LOAD_STORE_CACHE_OUTPUT_READY_XECORE27,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE28,LOAD_STORE_CACHE_OUTPUT_READY_XECORE28,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE29,LOAD_STORE_CACHE_OUTPUT_READY_XECORE29,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE30,LOAD_STORE_CACHE_OUTPUT_READY_XECORE30,LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE31,LOAD_STORE_CACHE_OUTPUT_READY_XECORE31</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="TDL">
              <value><xsl:text>THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE0,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE1,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE2,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE3,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE4,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE5,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE6,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE7,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE8,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE9,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE10,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE11,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE12,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE13,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE14,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE15,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE16,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE17,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE18,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE19,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE20,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE21,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE22,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE23,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE24,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE25,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE26,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE27,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE28,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE29,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE30,THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE31</xsl:text></value>
            </xsl:variable>
            <xsl:variable name="CommandParser">
              <value><xsl:text>COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS0,COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS1,COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS2,COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS3,COMMAND_PARSER_RENDER_ENGINE_BUSY</xsl:text></value>
            </xsl:variable>
            <defaultValue>
              <xsl:value-of select="concat($Filtered, ',', $GTI, ',', $XVEOccupancy, ',', $L3, ',', $HDC, ',', $LSC, ',', $TDL, ',', $CommandParser)"/>
            </defaultValue>
          </xsl:when>
          <xsl:otherwise>
            <defaultValue></defaultValue>
          </xsl:otherwise>
        </xsl:choose>
      </stringKnob>
      <stringKnob id="gpuFixedMetricsSelected" boolean:visible="false">
        <defaultValue></defaultValue>
      </stringKnob>
      <xsl:choose>
        <xsl:when test="exsl:ctx('targetOS', '')='Windows'">
          <booleanKnob id="gpuUsage" displayName="%GpuDX" boolean:visible="true" cliName="enable-gpu-usage">
            <description>%GpuDXDescription</description>
            <xsl:choose>
              <xsl:when test="exsl:ctx('gpuDX', 'false')='true'">
                <boolean:defaultValue>true</boolean:defaultValue>
              </xsl:when>
              <xsl:otherwise>
                <boolean:defaultValue>false</boolean:defaultValue>
              </xsl:otherwise>
            </xsl:choose>
          </booleanKnob>
        </xsl:when>
        <xsl:otherwise>
          <booleanKnob id="gpuUsage" displayName="%IGFXFtraceEvents" boolean:visible="true" cliName="enable-gpu-usage">
            <xsl:if test="$isExtendedIsaSupport='true'">
              <xsl:attribute name="boolean:visible">false</xsl:attribute>
            </xsl:if>
            <description>%IGFXFtraceEventsDescription</description>
            <boolean:defaultValue>false</boolean:defaultValue>
          </booleanKnob>
        </xsl:otherwise>
      </xsl:choose>
      <stringKnob id="kernelsToProfile" displayName="%GpuProfilingKernels" cliName="gpu-kernels-to-profile">
        <xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%GpuProfilingKernelsDescription</description>
        <knobProperty name="knob_control_id">KernelGrid</knobProperty>
        <defaultValue>*#1#1#4294967295</defaultValue>
      </stringKnob>
      <booleanKnob id="showGPUBandwidthHistogram" visible="false">
        <boolean:defaultValue>true</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="collectGpuMetal" displayName="%CollectGpuMetal" visible="true" cliName="enable-gpu-metal">
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS', '')='MacOSX'">
            <description>%CollectGpuMetalModeDescription</description>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="collectGpuCm" displayName="%CollectGpuCm" boolean:visible="false" cliName="enable-gpu-cm">
        <description>%CollectGpuCmModeDescription</description>
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS')='Windows' and exsl:is_experimental('gpu-cm')">
            <boolean:defaultValue>true</boolean:defaultValue>
          </xsl:when>
          <xsl:otherwise>
            <boolean:defaultValue>false</boolean:defaultValue>
          </xsl:otherwise>
        </xsl:choose>
      </booleanKnob>
      <booleanKnob id="collectFPGAOpenCl" displayName="%FPGATraceProgrammingAPIs" visible="true" cliName="collect-fpga-programming-api">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="useAOCLProfile" displayName="%UseAOCLProfile" cliName="aocl-profile">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="advancedLoopAnalysis" displayName="%AdvabncedLoopAnalysis" cliName="analyze-loops">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
	</xsl:if>
        <description>%AdvancedLoopAnalysisDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="showInlinesByDefault" boolean:visible="false">
        <boolean:defaultValue>true</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="hideSystemByDefault" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="openclSourceAsm" boolean:visible="false">
        <boolean:defaultValue>true</boolean:defaultValue>
      </booleanKnob>
      <stringKnob id="isFtraceAvailableKnob" boolean:visible="false">
        <defaultValue>
           <xsl:value-of select="exsl:ctx('isFtraceAvailable', 'valueNotPresent')"/>
        </defaultValue>
      </stringKnob>
      <enumKnob id="mrteType" displayName="%MrteType" cliName="mrte-type">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%MrteTypeDescription</description>
        <values>
          <xsl:choose>
            <xsl:when test="exsl:ctx('targetOS', '') = 'Windows'">
              <value displayName="%MrteTypeJavaNet">java,dotnet</value>
              <xsl:if test="$enablePython != 'false'">
                <value displayName="%MrteTypeJavaNetPython">java,dotnet,python</value>
                <value displayName="%MrteTypePython">python</value>
              </xsl:if>
              <defaultValue>java,dotnet</defaultValue>
            </xsl:when>
            <xsl:otherwise>
              <value displayName="%MrteTypeJava">java</value>
              <xsl:if test="$enablePython != 'false' and exsl:ctx('targetOS', '') = 'Linux'">
                <value displayName="%MrteTypeJavaPython">java,python</value>
                <value displayName="%MrteTypePython">python</value>
              </xsl:if>
              <defaultValue>java</defaultValue>
            </xsl:otherwise>
          </xsl:choose>
        </values>
      </enumKnob>
      <booleanKnob id="collectOpenMPRegions" displayName="%AnalyzeOpenMPRegions" visible="true" cliName="analyze-openmp">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <boolean:defaultValue>false</boolean:defaultValue>
        <description>%AnalyzeOpenMPRegionsDescription</description>
      </booleanKnob>
      <enumKnob id="calleeAttributionMode" displayName="%CalleeAttributionMode" boolean:visible="false">
        <description>%CalleeAttributionMode</description>
        <values>
          <value displayName="%NoneCalleeAttributionMode">none</value>
          <value displayName="%BottomUserCalleeAttributionMode">bottomUser</value>
          <value displayName="%TopSystemCalleeAttributionMode">topSystem</value>
          <value displayName="%InternalCalleeAttributionMode">internal</value>
          <value displayName="%UndefinedCalleeAttributionMode">undefined</value>
        </values>
        <defaultValue>undefined</defaultValue>
      </enumKnob>
      <booleanKnob id="collectMemObjects" displayName="%CollectMemObjects" boolean:visible="false">
       <xsl:if test="exsl:ctx('targetOS')='Linux' and $isExtendedIsaSupport='false'">
        <xsl:attribute name="boolean:visible">true</xsl:attribute>
       </xsl:if>
       <description>%CollectMemObjectsDescription</description>
       <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="analyzeMemoryConsumption" displayName="%AnalyzeMemoryConsumption" boolean:visible="false">
        <xsl:if test="exsl:ctx('targetOS')='Linux' and exsl:is_experimental('memory-consumption')">
         <xsl:attribute name="boolean:visible">true</xsl:attribute>
        </xsl:if>
        <description>%AnalyzeMemoryConsumptionDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <intKnob id="memoryObjectMinSize" displayName="%MemoryObjectMinSize" boolean:visible="false">
       <xsl:if test="exsl:ctx('targetOS')='Linux' and $isExtendedIsaSupport='false'">
        <xsl:attribute name="boolean:visible">true</xsl:attribute>
       </xsl:if>
       <description>%MemoryObjectMinSize</description>
       <int:min>1</int:min>
       <int:defaultValue>1024</int:defaultValue>
      </intKnob>
      <intKnob id="stackUnwindLimit" displayName="%StackUnwindLimit" cliName="stack-unwind-limit">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%StackUnwindLimit</description>
        <int:min>0</int:min>
        <int:defaultValue>8388608</int:defaultValue>
      </intKnob>
      <stringKnob id="tmamVersionCurrent" displayName="%TmamVersion" boolean:visible="false">
        <defaultValue>5_0</defaultValue>
      </stringKnob>
      <stringKnob id="fpuVersion" displayName="%FpuVersion" boolean:visible="false">
        <defaultValue>1_0</defaultValue>
      </stringKnob>
      <stringKnob id="numaVersionCurrent" displayName="%NumaVersion" boolean:visible="false">
        <defaultValue>1_0</defaultValue>
      </stringKnob>
      <booleanKnob id="handleLostEvents" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="ignorePowerData" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableOpenglesInstrumentation" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="collectFPGAOpenCl" displayName="%FPGATraceProgrammingAPIs" visible="true" cliName="collect-fpga-programming-api">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableDramBandwidthLimitsWarning" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <stringKnob id="systemCollectorConfig" displayName="%SystemCollectorConfig" boolean:visible="false" cliName="system-collector-config">
          <defaultValue></defaultValue>
      </stringKnob>
      <booleanKnob id="enableThreadAffinity" displayName="%enableThreadAffinity" cliName="enable-thread-affinity">
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS', '')='Linux' and $isExtendedIsaSupport='false'">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableParallelFsCollection" displayName="%enableParallelFsCollection" cliName="enable-parallel-fs-collection">
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS', '')='Linux' and exsl:is_experimental('lustre')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableMpiTracing" displayName="%enableMpiTracing" cliName="mpi-tracing">
        <xsl:choose>
          <xsl:when test="exsl:is_experimental('mpi')">
            <xsl:attribute name="boolean:visible">true</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="boolean:visible">false</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="collectSWHotspots" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="isUArchUsageAvailable" visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="inKernelProfilingAnalysis" visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="analyzeEnergyConsumption" displayName="%AnalyzeEnergyConsumption" visible="true">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%AnalyzeEnergyConsumptionDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="collectThrottlingReasons" displayName="%AnalyzeThrottlingReasons" boolean:visible="false">
        <xsl:if test="(exsl:ctx('targetOS', '')='Linux' or exsl:ctx('targetOS', '')='Windows') and exsl:is_experimental('throttling')">
          <xsl:attribute name="boolean:visible">true</xsl:attribute>
        </xsl:if>
        <description>%AnalyzeThrottlingReasonsDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="analyzeDgfxBandwidth" displayName="%AnalyzeDgfxBandwidth" visible="true">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%AnalyzeDgfxBandwidthDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="enableMemoryObjectCorrelation" visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="usePerfMetrics" visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="useAggregatedCounting" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="useGpuCounting" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <stringKnob id="fpgaSourceFile" displayName="%FpgaSourceFile" cliName="source-file-fpga">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%FpgaSourceFileDescription</description>
        <defaultValue></defaultValue>
      </stringKnob>
      <stringKnob id="fpgaAocxOrBinaryFile" displayName="%FpgaAocxOrBinaryFile" cliName="fpga-binary-aocx-file">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%FpgaAocxOrBinaryFileDescription</description>
        <defaultValue></defaultValue>
      </stringKnob>
      <intKnob id="fpgaPeriod" displayName="%FpgaPeriod" cliName="fpga-period">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%FpgaPeriodDescription</description>
        <int:min>0</int:min>
        <int:defaultValue>0</int:defaultValue>
      </intKnob>
      <booleanKnob id="fpgaNoTemporal" displayName="%FpgaNoTemporal" cliName="fpga-no-temporal">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%FpgaNoTemporalDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <booleanKnob id="fpgaNoMemTransfers" displayName="%FpgaNoMemTransfers" cliName="fpga-no-mem-transfers">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%FpgaNoMemTransfersDescription</description>
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
      <stringKnob id="l0MetricConfig" displayName="%L0MetricConfig" cliName="l0-metrics-config">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%L0MetricConfigDescription</description>
        <defaultValue></defaultValue>
      </stringKnob>
      <stringKnob id="l0SysmanConfig" displayName="%L0SysmanConfig" cliName="l0-sysman-config">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%L0SysmanConfigDescription</description>
        <defaultValue></defaultValue>
      </stringKnob>
      <enumKnob id="l0SamplingType" displayName="%L0SamplingType" cliName="l0-sampling-type">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%L0SamplingTypeDescription</description>
        <values>
          <value displayName="%L0EventType" cliName="event">event</value>
          <value displayName="%L0TimeType" cliName="time">time</value>
          <defaultValue>time</defaultValue>
        </values>
      </enumKnob>
      <doubleKnob id="l0SamplingInterval" displayName="%L0SamplingInterval" cliName="l0-sampling-interval">
	<xsl:if test="$isExtendedIsaSupport='true'">
          <xsl:attribute name="boolean:visible">false</xsl:attribute>
        </xsl:if>
        <description>%L0SamplingIntervalDescription</description>
        <double:min>0.01</double:min>
        <double:max>1000</double:max>
        <double:defaultValue>1</double:defaultValue>
        <knobProperty name="active_state">l0SamplingType=time</knobProperty>
      </doubleKnob>
      <booleanKnob id="isGpuMultiRunRequired" boolean:visible="false">
        <boolean:defaultValue>false</boolean:defaultValue>
      </booleanKnob>
    </knobs>
  </xsl:template>
</xsl:stylesheet>
