<?xml version="1.0" encoding="UTF-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:str="http://exslt.org/strings" str:keep_str_namespace=""
  xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace="">
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
  <queryLibrary>
    <derivedQuery id="VPUDDRData" displayName="%VPUDDRData" description="%VPUDDRData">
      <valueType>memory</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[NOC_noc]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUDRRBW" displayName="%VPUDRRBW" description="%VPUDRRBW">
      <queryInherit>/VPUDDRData</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>2</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
        <timeScalems>1000</timeScalems>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheHit" displayName="%VPUShave0IL1CacheHit" description="%VPUShave0IL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave0_IL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheMiss" displayName="%VPUShave0IL1CacheMiss" description="%VPUShave0IL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave0_IL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheAccess" displayName="%VPUShave0IL1CacheAccess" description="%VPUShave0IL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0IL1CacheHit") + query("/VPUShave0IL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheHitRatio" displayName="%VPUShave0IL1CacheHitRatio" description="%VPUShave0IL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0IL1CacheAccess") == 0 ? 0 : query("/VPUShave0IL1CacheHit") / query("/VPUShave0IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave0IL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheMissRatio" displayName="%VPUShave0IL1CacheMissRatio" description="%VPUShave0IL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0IL1CacheAccess") == 0 ? 0 : query("/VPUShave0IL1CacheMiss") / query("/VPUShave0IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0IL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave0IL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheHit" displayName="%VPUShave1IL1CacheHit" description="%VPUShave1IL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave1_IL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheMiss" displayName="%VPUShave1IL1CacheMiss" description="%VPUShave1IL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave1_IL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheAccess" displayName="%VPUShave1IL1CacheAccess" description="%VPUShave1IL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1IL1CacheHit") + query("/VPUShave1IL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheHitRatio" displayName="%VPUShave1IL1CacheHitRatio" description="%VPUShave1IL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1IL1CacheAccess") == 0 ? 0 : query("/VPUShave1IL1CacheHit") / query("/VPUShave1IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave1IL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheMissRatio" displayName="%VPUShave1IL1CacheMissRatio" description="%VPUShave1IL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1IL1CacheAccess") == 0 ? 0 : query("/VPUShave1IL1CacheMiss") / query("/VPUShave1IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1IL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave1IL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheHit" displayName="%VPUShave2IL1CacheHit" description="%VPUShave2IL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave2_IL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheMiss" displayName="%VPUShave2IL1CacheMiss" description="%VPUShave2IL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave2_IL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheAccess" displayName="%VPUShave2IL1CacheAccess" description="%VPUShave2IL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2IL1CacheHit") + query("/VPUShave2IL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheHitRatio" displayName="%VPUShave2IL1CacheHitRatio" description="%VPUShave2IL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2IL1CacheAccess") == 0 ? 0 : query("/VPUShave2IL1CacheHit") / query("/VPUShave2IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave2IL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheMissRatio" displayName="%VPUShave2IL1CacheMissRatio" description="%VPUShave2IL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2IL1CacheAccess") == 0 ? 0 : query("/VPUShave2IL1CacheMiss") / query("/VPUShave2IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2IL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave2IL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheHit" displayName="%VPUShave3IL1CacheHit" description="%VPUShave3IL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave3_IL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheMiss" displayName="%VPUShave3IL1CacheMiss" description="%VPUShave3IL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave3_IL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheAccess" displayName="%VPUShave3IL1CacheAccess" description="%VPUShave3IL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3IL1CacheHit") + query("/VPUShave3IL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheHitRatio" displayName="%VPUShave3IL1CacheHitRatio" description="%VPUShave3IL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3IL1CacheAccess") == 0 ? 0 : query("/VPUShave3IL1CacheHit") / query("/VPUShave3IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave3IL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheMissRatio" displayName="%VPUShave3IL1CacheMissRatio" description="%VPUShave3IL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3IL1CacheAccess") == 0 ? 0 : query("/VPUShave3IL1CacheMiss") / query("/VPUShave3IL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3IL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave3IL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheHit" displayName="%VPUShave0DL1CacheHit" description="%VPUShave0DL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave0_DL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheMiss" displayName="%VPUShave0DL1CacheMiss" description="%VPUShave0DL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave0_DL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheAccess" displayName="%VPUShave0DL1CacheAccess" description="%VPUShave0DL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0DL1CacheHit") + query("/VPUShave0DL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheHitRatio" displayName="%VPUShave0DL1CacheHitRatio" description="%VPUShave0DL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0DL1CacheAccess") == 0 ? 0 : query("/VPUShave0DL1CacheHit") / query("/VPUShave0DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave0DL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheMissRatio" displayName="%VPUShave0DL1CacheMissRatio" description="%VPUShave0DL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave0DL1CacheAccess") == 0 ? 0 : query("/VPUShave0DL1CacheMiss") / query("/VPUShave0DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave0DL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave0DL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheHit" displayName="%VPUShave1DL1CacheHit" description="%VPUShave1DL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave1_DL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheMiss" displayName="%VPUShave1DL1CacheMiss" description="%VPUShave1DL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave1_DL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheAccess" displayName="%VPUShave1DL1CacheAccess" description="%VPUShave1DL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1DL1CacheHit") + query("/VPUShave1DL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheHitRatio" displayName="%VPUShave1DL1CacheHitRatio" description="%VPUShave1DL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1DL1CacheAccess") == 0 ? 0 : query("/VPUShave1DL1CacheHit") / query("/VPUShave1DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave1DL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheMissRatio" displayName="%VPUShave1DL1CacheMissRatio" description="%VPUShave1DL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave1DL1CacheAccess") == 0 ? 0 : query("/VPUShave1DL1CacheMiss") / query("/VPUShave1DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave1DL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave1DL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheHit" displayName="%VPUShave2DL1CacheHit" description="%VPUShave2DL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave2_DL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheMiss" displayName="%VPUShave2DL1CacheMiss" description="%VPUShave2DL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave2_DL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheAccess" displayName="%VPUShave2DL1CacheAccess" description="%VPUShave2DL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2DL1CacheHit") + query("/VPUShave2DL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheHitRatio" displayName="%VPUShave2DL1CacheHitRatio" description="%VPUShave2DL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2DL1CacheAccess") == 0 ? 0 : query("/VPUShave2DL1CacheHit") / query("/VPUShave2DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave2DL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheMissRatio" displayName="%VPUShave2DL1CacheMissRatio" description="%VPUShave2DL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave2DL1CacheAccess") == 0 ? 0 : query("/VPUShave2DL1CacheMiss") / query("/VPUShave2DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave2DL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave2DL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheHit" displayName="%VPUShave3DL1CacheHit" description="%VPUShave3DL1CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave3_DL1_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheMiss" displayName="%VPUShave3DL1CacheMiss" description="%VPUShave3DL1CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave3_DL1_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheAccess" displayName="%VPUShave3DL1CacheAccess" description="%VPUShave3DL1CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3DL1CacheHit") + query("/VPUShave3DL1CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheHitRatio" displayName="%VPUShave3DL1CacheHitRatio" description="%VPUShave3DL1CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3DL1CacheAccess") == 0 ? 0 : query("/VPUShave3DL1CacheHit") / query("/VPUShave3DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShave3DL1CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheMissRatio" displayName="%VPUShave3DL1CacheMissRatio" description="%VPUShave3DL1CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShave3DL1CacheAccess") == 0 ? 0 : query("/VPUShave3DL1CacheMiss") / query("/VPUShave3DL1CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShave3DL1CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShave3DL1CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheHit" displayName="%VPUShaveL2CacheHit" description="%VPUShaveL2CacheHitDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave_L2_Cache_hit]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheMiss" displayName="%VPUShaveL2CacheMiss" description="%VPUShaveL2CacheMissDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Shave_L2_Cache_miss]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheAccess" displayName="%VPUShaveL2CacheAccess" description="%VPUShaveL2CacheAccessDescription">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/VPUShaveL2CacheHit") + query("/VPUShaveL2CacheMiss") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheHitRatio" displayName="%VPUShaveL2CacheHitRatio" description="%VPUShaveL2CacheHitRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShaveL2CacheAccess") == 0 ? 0 : query("/VPUShaveL2CacheHit") / query("/VPUShaveL2CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheHitRatioTimeline" displayName="%VPUCacheHitRatio">
      <queryInherit>/VPUShaveL2CacheHitRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>140,198,62</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheMissRatio" displayName="%VPUShaveL2CacheMissRatio" description="%VPUShaveL2CacheMissRatioDescription">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/VPUShaveL2CacheAccess") == 0 ? 0 : query("/VPUShaveL2CacheMiss") / query("/VPUShaveL2CacheAccess")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUShaveL2CacheMissRatioTimeline" displayName="%VPUCacheMissRatio">
      <queryInherit>/VPUShaveL2CacheMissRatio</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>242,100,33</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="VPUFixedFrequency" displayName="%VPUFixedFrequency" description="%VPUFixedFrequency">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Telemetry_fixed_frc]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUDynamicFrequency" displayName="%VPUDynamicFrequency" description="%VPUDynamicFrequency">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/LevelZeroEventCount/LevelZeroEventType[Telemetry_dynamic_frc]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUFrequency" displayName="%VPUFrequency" description="%VPUFrequency">
      <valueType>frequency</valueType>
      <valueEval><![CDATA[ ( query("/VPUFixedFrequency") == 0 ? 0 : query("/VPUDynamicFrequency") * 19200000 / query("/VPUFixedFrequency")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="VPUFrequencyMetrics" displayName="%VPUFrequency">
      <queryInherit>/VPUFrequency</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>128,0,128</timelineGraphColor>
        <timelinePenWidth>2</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
  </queryLibrary>
  </xsl:template>
</xsl:stylesheet>
