/*******************************************************************************
* Copyright (C) 2025 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

#ifndef _MATRIX_READER_H
#define _MATRIX_READER_H

#include "mkl.h"
#include "mmio.h"

/**
 * @brief Reads Matrix Market file and generates a CSR matrix
 *
 * @param[in] matrix_filename Name of the file.
 * @param[in] indexing 1 or 0-based output matrix.
 * @param[in] operation operation (SPARSE_OPERATION_NON_TRANSPOSE, SPARSE_OPERATION_TRANSPOSE or SPARSE_OPERATION_CONJUGATE_TRANSPOSE) to be performed on the matrix.
 * @param[out] is_symm function sets it to 1 if matrix is symmetric, else 0
 * @return CSR matrix of type sparse_matrix_t. In case of symmetric matrix only lower triangular part is returned
 */
/*Double-precision version*/
sparse_matrix_t d_matrix_reader(char *matrix_filename, const MKL_INT indexing, const sparse_operation_t operation, MKL_INT *is_symm);
/*Single-precision version*/
sparse_matrix_t s_matrix_reader(char *matrix_filename, const MKL_INT indexing, const sparse_operation_t operation, MKL_INT *is_symm);
/* complex valued functions not yet implemented*/

#endif
