#!/bin/tcsh -f
#
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

# =============================================================================
# Filename: sep_vars.tcsh
# Version: 1.0
# Purpose: SEP Runtime environment setup script
# Description: This script should be used to set up the run-time environment
#              for SEP.  It requires tcsh.  Run this script before running any
#              SEP/EMON executable, e.g., sep , emon or sfdump
#
# Usage: source sep_vars.tcsh
# =============================================================================

if ($# > 1) then
    echo "Usage: $0 [emon_api]"
else if ($# == 1) then
    if ("$1" != "emon_api") then
      echo "Usage: $0 [emon_api]"
    endif
endif

set PLATFORM="`uname -m`"
set OPERATING_SYS="`uname -s`"
set SCRIPT_DIR=`pwd`
set OS_BITNESS=""

setenv SEP_LOC_PATH "${SCRIPT_DIR}"
setenv ANDROID_TARGET_PATH "${SCRIPT_DIR}/android_target"
setenv EMON_API_HEADER_PATH "${SCRIPT_DIR}/config/emon_api"

if ("${OPERATING_SYS}" == 'Linux') then
    if ("${PLATFORM}" == 'x86_64') then
        set OS_BITNESS="64"
    else if ("${PLATFORM}" == 'i686') then
        echo "ERROR: 32-bit systems are not supported."
        exit 1
    endif
else if (${OPERATING_SYS} == 'FreeBSD') then
    set OS_BITNESS="64"
endif

setenv SEP_INSTALL_PATH "${SEP_LOC_PATH}/bin${OS_BITNESS}"
setenv SEP_LIB_INSTALL_PATH "${SEP_LOC_PATH}/lib${OS_BITNESS}"

if ( ${?PATH} ) then
    setenv PATH "${SEP_INSTALL_PATH}:${ANDROID_TARGET_PATH}:${PATH}"
else
    setenv PATH "${SEP_INSTALL_PATH}:${ANDROID_TARGET_PATH}"
endif

if ( ${?CPATH} ) then
    setenv CPATH "${EMON_API_HEADER_PATH}:${CPATH}"
else
    setenv CPATH "${EMON_API_HEADER_PATH}"
endif

if ( ${?LIBRARY_PATH} ) then
    setenv LIBRARY_PATH "${SEP_LIB_INSTALL_PATH}:${LIBRARY_PATH}"
else
    setenv LIBRARY_PATH "${SEP_LIB_INSTALL_PATH}"
endif

setenv EDP_PATH "${SEP_LOC_PATH}/config/edp:${SEP_LOC_PATH}/config/edp/pyedp"
if ( ${?PYTHONPATH} ) then
    setenv PYTHONPATH "${EDP_PATH}:${PYTHONPATH}"
else
    setenv PYTHONPATH "${EDP_PATH}"
endif

if ("$1" == "emon_api") then
    if ( ${?LD_LIBRARY_PATH} ) then
        setenv LD_LIBRARY_PATH "${SEP_LIB_INSTALL_PATH}:${LD_LIBRARY_PATH}"
    else
        setenv LD_LIBRARY_PATH "${SEP_LIB_INSTALL_PATH}"
    endif
endif

setenv SEP_BASE_DIR "${SEP_INSTALL_PATH}"

# show settings of various environment variables
echo "PATH=${PATH}"
echo "CPATH=${CPATH}"
echo "LIBRARY_PATH=${LIBRARY_PATH}"
if ( ${?LD_LIBRARY_PATH} ) then
    echo "LD_LIBRARY_PATH=${LD_LIBRARY_PATH}"
endif
echo "SEP_BASE_DIR=${SEP_BASE_DIR}"
echo SEP is currently installed under $SEP_INSTALL_PATH

